/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.table.PartialUpdateMode;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.util.ConfigUtils;

public class PartialUpdateHandler<T>
implements Serializable {
    private final RecordContext<T> recordContext;
    private final PartialUpdateMode partialUpdateMode;
    private final Map<String, String> mergeProperties;

    public PartialUpdateHandler(RecordContext<T> recordContext, PartialUpdateMode partialUpdateMode, TypedProperties props) {
        this.recordContext = recordContext;
        this.partialUpdateMode = partialUpdateMode;
        this.mergeProperties = PartialUpdateHandler.parseMergeProperties(props);
    }

    BufferedRecord<T> partialMerge(BufferedRecord<T> highOrderRecord, BufferedRecord<T> lowOrderRecord, Schema highOrderSchema, Schema lowOrderSchema, Schema newSchema) {
        if (null == lowOrderRecord || highOrderRecord.isDelete() || lowOrderRecord.isDelete()) {
            return highOrderRecord;
        }
        switch (this.partialUpdateMode) {
            case IGNORE_DEFAULTS: {
                return this.reconcileDefaultValues(highOrderRecord, lowOrderRecord, highOrderSchema, lowOrderSchema, newSchema);
            }
            case FILL_UNAVAILABLE: {
                return this.reconcileMarkerValues(highOrderRecord, lowOrderRecord, highOrderSchema, lowOrderSchema, newSchema);
            }
        }
        return highOrderRecord;
    }

    BufferedRecord<T> reconcileDefaultValues(BufferedRecord<T> highOrderRecord, BufferedRecord<T> lowOrderRecord, Schema highOrderSchema, Schema lowOrderSchema, Schema newSchema) {
        List fields = newSchema.getFields();
        Object[] fieldVals = new Object[fields.size()];
        int idx = 0;
        boolean updated = false;
        for (Schema.Field field : fields) {
            Object newValue;
            String fieldName = field.name();
            Object defaultValue = HoodieAvroUtils.toJavaDefaultValue(field);
            if (defaultValue == (newValue = this.recordContext.getValue(highOrderRecord.getRecord(), highOrderSchema, fieldName))) {
                fieldVals[idx++] = this.recordContext.getValue(lowOrderRecord.getRecord(), lowOrderSchema, fieldName);
                updated = true;
                continue;
            }
            fieldVals[idx++] = newValue;
        }
        if (!updated) {
            return highOrderRecord;
        }
        T engineRecord = this.recordContext.constructEngineRecord(newSchema, fieldVals);
        return new BufferedRecord<T>(highOrderRecord.getRecordKey(), highOrderRecord.getOrderingValue(), engineRecord, newSchema == highOrderSchema ? highOrderRecord.getSchemaId() : lowOrderRecord.getSchemaId(), highOrderRecord.getHoodieOperation());
    }

    BufferedRecord<T> reconcileMarkerValues(BufferedRecord<T> highOrderRecord, BufferedRecord<T> lowOrderRecord, Schema highOrderSchema, Schema lowOrderSchema, Schema newSchema) {
        List fields = newSchema.getFields();
        Object[] fieldVals = new Object[fields.size()];
        String partialUpdateCustomMarker = this.mergeProperties.get("hoodie.write.partial.update.unavailable.value");
        int idx = 0;
        boolean updated = false;
        for (Schema.Field field : fields) {
            String fieldName = field.name();
            Object newValue = this.recordContext.getValue(highOrderRecord.getRecord(), highOrderSchema, fieldName);
            if ((PartialUpdateHandler.isStringTyped(field) || PartialUpdateHandler.isBytesTyped(field)) && null != partialUpdateCustomMarker && partialUpdateCustomMarker.equals(this.recordContext.getTypeConverter().castToString(newValue))) {
                fieldVals[idx++] = this.recordContext.getValue(lowOrderRecord.getRecord(), lowOrderSchema, fieldName);
                updated = true;
                continue;
            }
            fieldVals[idx++] = newValue;
        }
        if (!updated) {
            return highOrderRecord;
        }
        T engineRecord = this.recordContext.constructEngineRecord(newSchema, fieldVals);
        return new BufferedRecord<T>(highOrderRecord.getRecordKey(), highOrderRecord.getOrderingValue(), engineRecord, newSchema == highOrderSchema ? highOrderRecord.getSchemaId() : lowOrderRecord.getSchemaId(), highOrderRecord.getHoodieOperation());
    }

    static boolean isStringTyped(Schema.Field field) {
        return PartialUpdateHandler.hasTargetType(field.schema(), Schema.Type.STRING);
    }

    static boolean isBytesTyped(Schema.Field field) {
        return PartialUpdateHandler.hasTargetType(field.schema(), Schema.Type.BYTES);
    }

    static boolean hasTargetType(Schema schema, Schema.Type targetType) {
        if (schema.getType() == targetType) {
            return true;
        }
        if (schema.getType() == Schema.Type.UNION) {
            return schema.getTypes().stream().anyMatch(s -> s.getType() == targetType);
        }
        return false;
    }

    static Map<String, String> parseMergeProperties(TypedProperties props) {
        return ConfigUtils.extractWithPrefix(props, "hoodie.record.merge.property.");
    }
}

