/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

public class ReaderParameters {
    private final boolean useRecordPosition;
    private final boolean emitDelete;
    private final boolean sortOutput;
    private final boolean allowInflightInstants;
    private final boolean enableOptimizedLogBlockScan;

    private ReaderParameters(boolean useRecordPosition, boolean emitDelete, boolean sortOutput, boolean allowInflightInstants, boolean enableOptimizedLogBlockScan) {
        this.useRecordPosition = useRecordPosition;
        this.emitDelete = emitDelete;
        this.sortOutput = sortOutput;
        this.allowInflightInstants = allowInflightInstants;
        this.enableOptimizedLogBlockScan = enableOptimizedLogBlockScan;
    }

    public boolean useRecordPosition() {
        return this.useRecordPosition;
    }

    public boolean emitDeletes() {
        return this.emitDelete;
    }

    public boolean sortOutputs() {
        return this.sortOutput;
    }

    public boolean allowInflightInstants() {
        return this.allowInflightInstants;
    }

    public boolean enableOptimizedLogBlockScan() {
        return this.enableOptimizedLogBlockScan;
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private boolean shouldUseRecordPosition = false;
        private boolean emitDelete = false;
        private boolean sortOutput = false;
        private boolean allowInflightInstants = false;
        private boolean enableOptimizedLogBlockScan = false;

        Builder() {
        }

        public Builder shouldUseRecordPosition(boolean shouldUseRecordPosition) {
            this.shouldUseRecordPosition = shouldUseRecordPosition;
            return this;
        }

        public Builder emitDeletes(boolean emitDelete) {
            this.emitDelete = emitDelete;
            return this;
        }

        public Builder sortOutputs(boolean sortOutput) {
            this.sortOutput = sortOutput;
            return this;
        }

        public Builder allowInflightInstants(boolean allowInflightInstants) {
            this.allowInflightInstants = allowInflightInstants;
            return this;
        }

        public Builder enableOptimizedLogBlockScan(boolean enableOptimizedLogBlockScan) {
            this.enableOptimizedLogBlockScan = enableOptimizedLogBlockScan;
            return this;
        }

        public ReaderParameters build() {
            return new ReaderParameters(this.shouldUseRecordPosition, this.emitDelete, this.sortOutput, this.allowInflightInstants, this.enableOptimizedLogBlockScan);
        }
    }
}

