/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.IOException;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.table.read.BaseFileUpdateCallback;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.metadata.HoodieMetadataPayload;

public interface UpdateProcessor<T> {
    public BufferedRecord<T> processUpdate(String var1, BufferedRecord<T> var2, BufferedRecord<T> var3, boolean var4);

    public static <T> UpdateProcessor<T> create(HoodieReadStats readStats, HoodieReaderContext<T> readerContext, boolean emitDeletes, Option<BaseFileUpdateCallback<T>> updateCallback, TypedProperties properties) {
        Option payloadClass = readerContext.getPayloadClasses(properties).map(Pair::getRight);
        boolean hasNonMetadataPayload = (Boolean)payloadClass.map(className -> !className.equals(HoodieMetadataPayload.class.getName())).orElse((Object)false);
        StandardUpdateProcessor handler = readerContext.getMergeMode() == RecordMergeMode.CUSTOM && hasNonMetadataPayload ? new PayloadUpdateProcessor<T>(readStats, readerContext, emitDeletes, properties, (String)payloadClass.get()) : new StandardUpdateProcessor(readStats, readerContext, emitDeletes);
        if (updateCallback.isPresent()) {
            return new CallbackProcessor<T>((BaseFileUpdateCallback)updateCallback.get(), handler);
        }
        return handler;
    }

    public static class CallbackProcessor<T>
    implements UpdateProcessor<T> {
        private final BaseFileUpdateCallback<T> callback;
        private final UpdateProcessor<T> delegate;

        public CallbackProcessor(BaseFileUpdateCallback<T> callback, UpdateProcessor<T> delegate) {
            this.callback = callback;
            this.delegate = delegate;
        }

        @Override
        public BufferedRecord<T> processUpdate(String recordKey, BufferedRecord<T> previousRecord, BufferedRecord<T> mergedRecord, boolean isDelete) {
            BufferedRecord<T> result = this.delegate.processUpdate(recordKey, previousRecord, mergedRecord, isDelete);
            if (isDelete) {
                this.callback.onDelete(recordKey, previousRecord, mergedRecord.getHoodieOperation());
            } else if (result != null && HoodieOperation.isUpdateAfter(result.getHoodieOperation())) {
                this.callback.onUpdate(recordKey, previousRecord, mergedRecord);
            } else if (result != null && HoodieOperation.isInsert(result.getHoodieOperation())) {
                this.callback.onInsert(recordKey, mergedRecord);
            }
            return result;
        }
    }

    public static class PayloadUpdateProcessor<T>
    extends StandardUpdateProcessor<T> {
        private final String payloadClass;
        private final Properties properties;

        public PayloadUpdateProcessor(HoodieReadStats readStats, HoodieReaderContext<T> readerContext, boolean emitDeletes, Properties properties, String payloadClass) {
            super(readStats, readerContext, emitDeletes);
            this.payloadClass = payloadClass;
            this.properties = properties;
        }

        @Override
        protected BufferedRecord<T> handleNonDeletes(BufferedRecord<T> previousRecord, BufferedRecord<T> mergedRecord) {
            if (previousRecord == null) {
                Schema recordSchema = this.readerContext.getRecordContext().decodeAvroSchema(mergedRecord.getSchemaId());
                GenericRecord record = this.readerContext.getRecordContext().convertToAvroRecord(mergedRecord.getRecord(), recordSchema);
                HoodieAvroRecord hoodieRecord = new HoodieAvroRecord(null, HoodieRecordUtils.loadPayload(this.payloadClass, record, mergedRecord.getOrderingValue()));
                try {
                    if (hoodieRecord.shouldIgnore(recordSchema, this.properties)) {
                        return null;
                    }
                    Schema readerSchema = this.readerContext.getSchemaHandler().getRequestedSchema();
                    hoodieRecord.rewriteRecordWithNewSchema(recordSchema, this.properties, readerSchema).toIndexedRecord(readerSchema, this.properties).ifPresent(rewrittenRecord -> mergedRecord.replaceRecord(this.readerContext.getRecordContext().convertAvroRecord(rewrittenRecord.getData())));
                }
                catch (IOException e) {
                    throw new HoodieIOException("Error processing record with payload class: " + this.payloadClass, e);
                }
            }
            return super.handleNonDeletes(previousRecord, mergedRecord);
        }
    }

    public static class StandardUpdateProcessor<T>
    implements UpdateProcessor<T> {
        protected final HoodieReadStats readStats;
        protected final HoodieReaderContext<T> readerContext;
        protected final boolean emitDeletes;

        public StandardUpdateProcessor(HoodieReadStats readStats, HoodieReaderContext<T> readerContext, boolean emitDeletes) {
            this.readStats = readStats;
            this.readerContext = readerContext;
            this.emitDeletes = emitDeletes;
        }

        @Override
        public BufferedRecord<T> processUpdate(String recordKey, BufferedRecord<T> previousRecord, BufferedRecord<T> mergedRecord, boolean isDelete) {
            if (isDelete) {
                this.readStats.incrementNumDeletes();
                if (this.emitDeletes) {
                    if (!HoodieOperation.isUpdateBefore(mergedRecord.getHoodieOperation())) {
                        mergedRecord.setHoodieOperation(HoodieOperation.DELETE);
                    }
                    if (mergedRecord.isEmpty()) {
                        T deleteRow = this.readerContext.getRecordContext().getDeleteRow(recordKey);
                        return deleteRow == null ? null : mergedRecord.replaceRecord(deleteRow);
                    }
                    return mergedRecord;
                }
                return null;
            }
            return this.handleNonDeletes(previousRecord, mergedRecord);
        }

        protected BufferedRecord<T> handleNonDeletes(BufferedRecord<T> previousRecord, BufferedRecord<T> mergedRecord) {
            Object prevRow = previousRecord != null ? previousRecord.getRecord() : null;
            T mergedRow = mergedRecord.getRecord();
            if (prevRow != null && prevRow != mergedRow) {
                mergedRecord.setHoodieOperation(HoodieOperation.UPDATE_AFTER);
                this.readStats.incrementNumUpdates();
            } else if (prevRow == null) {
                mergedRecord.setHoodieOperation(HoodieOperation.INSERT);
                this.readStats.incrementNumInserts();
            }
            return mergedRecord.seal(this.readerContext.getRecordContext());
        }
    }
}

