/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read.buffer;

import java.util.List;
import java.util.Properties;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.PartialUpdateMode;
import org.apache.hudi.common.table.read.BaseFileUpdateCallback;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.table.read.InputSplit;
import org.apache.hudi.common.table.read.ReaderParameters;
import org.apache.hudi.common.table.read.UpdateProcessor;
import org.apache.hudi.common.table.read.buffer.FileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.FileGroupRecordBufferLoader;
import org.apache.hudi.common.table.read.buffer.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.KeyBasedFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.LogScanningRecordBufferLoader;
import org.apache.hudi.common.table.read.buffer.PositionBasedFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.SortedKeyBasedFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.UnmergedFileGroupRecordBuffer;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.storage.HoodieStorage;

class DefaultFileGroupRecordBufferLoader<T>
extends LogScanningRecordBufferLoader
implements FileGroupRecordBufferLoader<T> {
    private static final DefaultFileGroupRecordBufferLoader INSTANCE = new DefaultFileGroupRecordBufferLoader();

    static <T> DefaultFileGroupRecordBufferLoader<T> getInstance() {
        return INSTANCE;
    }

    private DefaultFileGroupRecordBufferLoader() {
    }

    @Override
    public Pair<HoodieFileGroupRecordBuffer<T>, List<String>> getRecordBuffer(HoodieReaderContext<T> readerContext, HoodieStorage storage, InputSplit inputSplit, List<String> orderingFieldNames, HoodieTableMetaClient hoodieTableMetaClient, TypedProperties props, ReaderParameters readerParameters, HoodieReadStats readStats, Option<BaseFileUpdateCallback<T>> fileGroupUpdateCallback) {
        boolean isSkipMerge = ConfigUtils.getStringWithAltKeys((Properties)props, HoodieReaderConfig.MERGE_TYPE, true).equalsIgnoreCase("skip_merge");
        Option<PartialUpdateMode> partialUpdateModeOpt = hoodieTableMetaClient.getTableConfig().getPartialUpdateMode();
        UpdateProcessor<T> updateProcessor = UpdateProcessor.create(readStats, readerContext, readerParameters.emitDeletes(), fileGroupUpdateCallback, props);
        FileGroupRecordBuffer recordBuffer = isSkipMerge ? new UnmergedFileGroupRecordBuffer<T>(readerContext, hoodieTableMetaClient, readerContext.getMergeMode(), partialUpdateModeOpt, props, readStats) : (readerParameters.sortOutputs() ? new SortedKeyBasedFileGroupRecordBuffer<T>(readerContext, hoodieTableMetaClient, readerContext.getMergeMode(), partialUpdateModeOpt, props, orderingFieldNames, updateProcessor) : (readerParameters.useRecordPosition() && inputSplit.getBaseFileOption().isPresent() ? new PositionBasedFileGroupRecordBuffer<T>(readerContext, hoodieTableMetaClient, readerContext.getMergeMode(), partialUpdateModeOpt, ((HoodieBaseFile)inputSplit.getBaseFileOption().get()).getCommitTime(), props, orderingFieldNames, updateProcessor) : new KeyBasedFileGroupRecordBuffer<T>(readerContext, hoodieTableMetaClient, readerContext.getMergeMode(), partialUpdateModeOpt, props, orderingFieldNames, updateProcessor)));
        return Pair.of(recordBuffer, this.scanLogFiles(readerContext, storage, inputSplit, hoodieTableMetaClient, props, readerParameters, readStats, recordBuffer));
    }
}

