/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read.buffer;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaCache;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.PartialUpdateMode;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.BufferedRecordConverter;
import org.apache.hudi.common.table.read.BufferedRecordMerger;
import org.apache.hudi.common.table.read.BufferedRecordMergerFactory;
import org.apache.hudi.common.table.read.BufferedRecords;
import org.apache.hudi.common.table.read.DeleteContext;
import org.apache.hudi.common.table.read.UpdateProcessor;
import org.apache.hudi.common.table.read.buffer.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.InternalSchemaCache;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.action.InternalSchemaMerger;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;

abstract class FileGroupRecordBuffer<T>
implements HoodieFileGroupRecordBuffer<T> {
    protected final HoodieReaderContext<T> readerContext;
    protected final Schema readerSchema;
    protected final List<String> orderingFieldNames;
    protected final RecordMergeMode recordMergeMode;
    protected final Option<PartialUpdateMode> partialUpdateModeOpt;
    protected final Option<HoodieRecordMerger> recordMerger;
    protected final Option<Pair<String, String>> payloadClasses;
    protected final TypedProperties props;
    protected final ExternalSpillableMap<Serializable, BufferedRecord<T>> records;
    protected final DeleteContext deleteContext;
    protected final BufferedRecordConverter<T> bufferedRecordConverter;
    protected ClosableIterator<T> baseFileIterator;
    protected UpdateProcessor<T> updateProcessor;
    protected Iterator<BufferedRecord<T>> logRecordIterator;
    protected BufferedRecord<T> nextRecord;
    protected boolean enablePartialMerging = false;
    protected InternalSchema internalSchema;
    protected HoodieTableMetaClient hoodieTableMetaClient;
    protected BufferedRecordMerger<T> bufferedRecordMerger;
    protected long totalLogRecords = 0L;

    protected FileGroupRecordBuffer(HoodieReaderContext<T> readerContext, HoodieTableMetaClient hoodieTableMetaClient, RecordMergeMode recordMergeMode, Option<PartialUpdateMode> partialUpdateModeOpt, TypedProperties props, List<String> orderingFieldNames, UpdateProcessor<T> updateProcessor) {
        this.readerContext = readerContext;
        this.updateProcessor = updateProcessor;
        this.readerSchema = AvroSchemaCache.intern(readerContext.getSchemaHandler().getRequiredSchema());
        this.recordMergeMode = recordMergeMode;
        this.partialUpdateModeOpt = partialUpdateModeOpt;
        this.recordMerger = readerContext.getRecordMerger();
        this.payloadClasses = readerContext.getPayloadClasses(props);
        this.orderingFieldNames = orderingFieldNames;
        this.props = ConfigUtils.supplementOrderingFields(props, orderingFieldNames);
        this.internalSchema = readerContext.getSchemaHandler().getInternalSchema();
        this.hoodieTableMetaClient = hoodieTableMetaClient;
        String spillableMapBasePath = props.getString(HoodieMemoryConfig.SPILLABLE_MAP_BASE_PATH.key(), FileIOUtils.getDefaultSpillableMapBasePath());
        try {
            this.records = this.initializeRecordsMap(spillableMapBasePath);
        }
        catch (IOException e) {
            throw new HoodieIOException("IOException when creating ExternalSpillableMap at " + spillableMapBasePath, e);
        }
        this.bufferedRecordMerger = BufferedRecordMergerFactory.create(readerContext, recordMergeMode, this.enablePartialMerging, this.recordMerger, this.readerSchema, this.payloadClasses, props, partialUpdateModeOpt);
        this.deleteContext = readerContext.getSchemaHandler().getDeleteContext().withReaderSchema(this.readerSchema);
        this.bufferedRecordConverter = BufferedRecordConverter.createConverter(readerContext.getIteratorMode(), this.readerSchema, readerContext.getRecordContext(), orderingFieldNames);
    }

    protected ExternalSpillableMap<Serializable, BufferedRecord<T>> initializeRecordsMap(String spillableMapBasePath) throws IOException {
        long maxMemorySizeInBytes = this.props.getLong(HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE.key(), HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE.defaultValue());
        ExternalSpillableMap.DiskMapType diskMapType = ExternalSpillableMap.DiskMapType.valueOf(this.props.getString(HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.key(), HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.defaultValue().name()).toUpperCase(Locale.ROOT));
        boolean isBitCaskDiskMapCompressionEnabled = this.props.getBoolean(HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.key(), HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.defaultValue());
        return new ExternalSpillableMap<Serializable, BufferedRecord<T>>(maxMemorySizeInBytes, spillableMapBasePath, new DefaultSizeEstimator(), this.readerContext.getRecordSizeEstimator(), diskMapType, this.readerContext.getRecordSerializer(), isBitCaskDiskMapCompressionEnabled, this.getClass().getSimpleName());
    }

    @Override
    public void setBaseFileIterator(ClosableIterator<T> baseFileIterator) {
        this.baseFileIterator = baseFileIterator;
    }

    public DeleteContext getDeleteContext() {
        return this.deleteContext;
    }

    protected abstract boolean doHasNext() throws IOException;

    @Override
    public final boolean hasNext() throws IOException {
        return this.nextRecord != null || this.doHasNext();
    }

    @Override
    public final BufferedRecord<T> next() {
        BufferedRecord<T> record = this.nextRecord;
        this.nextRecord = null;
        return record;
    }

    @Override
    public Map<Serializable, BufferedRecord<T>> getLogRecords() {
        return this.records;
    }

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public long getTotalLogRecords() {
        return this.totalLogRecords;
    }

    @Override
    public ClosableIterator<BufferedRecord<T>> getLogRecordIterator() {
        return new LogRecordIterator(this);
    }

    @Override
    public void close() {
        this.records.close();
    }

    protected Pair<ClosableIterator<T>, Schema> getRecordsIterator(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) {
        try {
            ClosableIterator<T> blockRecordsIterator;
            if (keySpecOpt.isPresent()) {
                KeySpec keySpec = (KeySpec)keySpecOpt.get();
                blockRecordsIterator = dataBlock.getEngineRecordIterator(this.readerContext, keySpec.getKeys(), keySpec.isFullKey());
            } else {
                blockRecordsIterator = dataBlock.getEngineRecordIterator(this.readerContext);
            }
            Pair<Function<T, T>, Schema> schemaTransformerWithEvolvedSchema = this.getSchemaTransformerWithEvolvedSchema(dataBlock);
            return Pair.of(new CloseableMappingIterator<T, T>(blockRecordsIterator, schemaTransformerWithEvolvedSchema.getLeft()), schemaTransformerWithEvolvedSchema.getRight());
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to deser records from log files ", e);
        }
    }

    protected Option<Pair<Function<T, T>, Schema>> composeEvolvedSchemaTransformer(HoodieDataBlock dataBlock) {
        if (this.internalSchema.isEmptySchema()) {
            return Option.empty();
        }
        long currentInstantTime = Long.parseLong(dataBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME));
        InternalSchema fileSchema = InternalSchemaCache.searchSchemaAndCache(currentInstantTime, this.hoodieTableMetaClient);
        Pair<InternalSchema, Map<String, String>> mergedInternalSchema = new InternalSchemaMerger(fileSchema, this.internalSchema, true, false, false).mergeSchemaGetRenamed();
        Schema mergedAvroSchema = AvroInternalSchemaConverter.convert(mergedInternalSchema.getLeft(), this.readerSchema.getFullName());
        return Option.of(Pair.of(this.readerContext.getRecordContext().projectRecord(dataBlock.getSchema(), mergedAvroSchema, mergedInternalSchema.getRight()), mergedAvroSchema));
    }

    protected boolean hasNextBaseRecord(T baseRecord, BufferedRecord<T> logRecordInfo) throws IOException {
        if (logRecordInfo != null) {
            BufferedRecord<T> baseRecordInfo = BufferedRecords.fromEngineRecord(baseRecord, this.readerSchema, this.readerContext.getRecordContext(), this.orderingFieldNames, false);
            BufferedRecord<T> mergeResult = this.bufferedRecordMerger.finalMerge(baseRecordInfo, logRecordInfo);
            this.nextRecord = this.updateProcessor.processUpdate(logRecordInfo.getRecordKey(), baseRecordInfo, mergeResult, mergeResult.isDelete());
            return this.nextRecord != null;
        }
        this.nextRecord = this.bufferedRecordConverter.convert(this.readerContext.getRecordContext().seal(baseRecord));
        return true;
    }

    protected void initializeLogRecordIterator() {
        this.logRecordIterator = this.records.iterator();
    }

    protected boolean hasNextLogRecord() {
        if (this.logRecordIterator == null) {
            this.initializeLogRecordIterator();
        }
        while (this.logRecordIterator.hasNext()) {
            BufferedRecord<T> nextRecordInfo = this.logRecordIterator.next();
            this.nextRecord = this.updateProcessor.processUpdate(nextRecordInfo.getRecordKey(), null, nextRecordInfo, nextRecordInfo.isDelete());
            if (this.nextRecord == null) continue;
            return true;
        }
        return false;
    }

    protected Pair<Function<T, T>, Schema> getSchemaTransformerWithEvolvedSchema(HoodieDataBlock dataBlock) {
        Option<Pair<Function<T, T>, Schema>> schemaEvolutionTransformerOpt = this.composeEvolvedSchemaTransformer(dataBlock);
        Function transformer = (Function)schemaEvolutionTransformerOpt.map(Pair::getLeft).orElse(Function.identity());
        Schema evolvedSchema = (Schema)schemaEvolutionTransformerOpt.map(Pair::getRight).orElseGet(dataBlock::getSchema);
        return Pair.of(transformer, evolvedSchema);
    }

    private static class LogRecordIterator<T>
    implements ClosableIterator<BufferedRecord<T>> {
        private final FileGroupRecordBuffer<T> fileGroupRecordBuffer;
        private final Iterator<BufferedRecord<T>> logRecordIterator;

        private LogRecordIterator(FileGroupRecordBuffer<T> fileGroupRecordBuffer) {
            this.fileGroupRecordBuffer = fileGroupRecordBuffer;
            this.logRecordIterator = fileGroupRecordBuffer.records.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.logRecordIterator.hasNext();
        }

        @Override
        public BufferedRecord<T> next() {
            return this.logRecordIterator.next();
        }

        @Override
        public void close() {
            this.fileGroupRecordBuffer.close();
        }
    }
}

