/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read.buffer;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaCache;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.PartialUpdateMode;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.BufferedRecordMergerFactory;
import org.apache.hudi.common.table.read.BufferedRecords;
import org.apache.hudi.common.table.read.UpdateProcessor;
import org.apache.hudi.common.table.read.buffer.FileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;

public class KeyBasedFileGroupRecordBuffer<T>
extends FileGroupRecordBuffer<T> {
    public KeyBasedFileGroupRecordBuffer(HoodieReaderContext<T> readerContext, HoodieTableMetaClient hoodieTableMetaClient, RecordMergeMode recordMergeMode, Option<PartialUpdateMode> partialUpdateModeOpt, TypedProperties props, List<String> orderingFieldNames, UpdateProcessor<T> updateProcessor) {
        super(readerContext, hoodieTableMetaClient, recordMergeMode, partialUpdateModeOpt, props, orderingFieldNames, updateProcessor);
    }

    @Override
    public HoodieFileGroupRecordBuffer.BufferType getBufferType() {
        return HoodieFileGroupRecordBuffer.BufferType.KEY_BASED_MERGE;
    }

    @Override
    public void processDataBlock(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) throws IOException {
        Pair recordsIteratorSchemaPair = this.getRecordsIterator(dataBlock, keySpecOpt);
        if (dataBlock.containsPartialUpdates() && !this.enablePartialMerging) {
            this.enablePartialMerging = true;
            this.bufferedRecordMerger = BufferedRecordMergerFactory.create(this.readerContext, this.recordMergeMode, true, (Option<HoodieRecordMerger>)this.recordMerger, this.readerSchema, (Option<Pair<String, String>>)this.payloadClasses, this.props, (Option<PartialUpdateMode>)this.partialUpdateModeOpt);
        }
        Schema schema = AvroSchemaCache.intern(recordsIteratorSchemaPair.getRight());
        RecordContext recordContext = this.readerContext.getRecordContext();
        try (ClosableIterator recordIterator = recordsIteratorSchemaPair.getLeft();){
            while (recordIterator.hasNext()) {
                Object nextRecord = recordIterator.next();
                boolean isDelete = recordContext.isDeleteRecord(nextRecord, this.deleteContext);
                BufferedRecord bufferedRecord = BufferedRecords.fromEngineRecord(nextRecord, schema, this.readerContext.getRecordContext(), this.orderingFieldNames, isDelete);
                this.processNextDataRecord(bufferedRecord, (Serializable)((Object)bufferedRecord.getRecordKey()));
            }
        }
    }

    @Override
    public void processNextDataRecord(BufferedRecord<T> record, Serializable recordKey) throws IOException {
        BufferedRecord existingRecord = (BufferedRecord)this.records.get(recordKey);
        ++this.totalLogRecords;
        this.bufferedRecordMerger.deltaMerge(record, existingRecord).ifPresent(bufferedRecord -> this.records.put(recordKey, bufferedRecord.toBinary(this.readerContext.getRecordContext())));
    }

    @Override
    public void processDeleteBlock(HoodieDeleteBlock deleteBlock) throws IOException {
        Iterator it = Arrays.stream(deleteBlock.getRecordsToDelete()).iterator();
        while (it.hasNext()) {
            DeleteRecord record = (DeleteRecord)it.next();
            this.processNextDeletedRecord(record, (Serializable)((Object)record.getRecordKey()));
        }
    }

    @Override
    public void processNextDeletedRecord(DeleteRecord deleteRecord, Serializable recordIdentifier) {
        BufferedRecord existingRecord = (BufferedRecord)this.records.get(recordIdentifier);
        ++this.totalLogRecords;
        Option<DeleteRecord> recordOpt = this.bufferedRecordMerger.deltaMerge(deleteRecord, existingRecord);
        recordOpt.ifPresent(deleteRec -> this.records.put(recordIdentifier, BufferedRecords.fromDeleteRecord(deleteRec, this.readerContext.getRecordContext())));
    }

    @Override
    public boolean containsLogRecord(String recordKey) {
        return this.records.containsKey(recordKey);
    }

    protected boolean hasNextBaseRecord(T baseRecord) throws IOException {
        String recordKey = this.readerContext.getRecordContext().getRecordKey(baseRecord, this.readerSchema);
        BufferedRecord logRecordInfo = (BufferedRecord)this.records.remove(recordKey);
        return this.hasNextBaseRecord(baseRecord, logRecordInfo);
    }

    @Override
    protected boolean doHasNext() throws IOException {
        ValidationUtils.checkState((this.baseFileIterator != null ? 1 : 0) != 0, (String)"Base file iterator has not been set yet");
        while (this.baseFileIterator.hasNext()) {
            if (!this.hasNextBaseRecord(this.baseFileIterator.next())) continue;
            return true;
        }
        return this.hasNextLogRecord();
    }

    public boolean isPartialMergingEnabled() {
        return this.enablePartialMerging;
    }
}

