/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read.buffer;

import java.util.List;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.BaseHoodieLogRecordReader;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordReader;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.table.read.InputSplit;
import org.apache.hudi.common.table.read.ReaderParameters;
import org.apache.hudi.common.table.read.buffer.FileGroupRecordBuffer;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.storage.HoodieStorage;

abstract class LogScanningRecordBufferLoader {
    LogScanningRecordBufferLoader() {
    }

    protected <T> List<String> scanLogFiles(HoodieReaderContext<T> readerContext, HoodieStorage storage, InputSplit inputSplit, HoodieTableMetaClient hoodieTableMetaClient, TypedProperties props, ReaderParameters readerParameters, HoodieReadStats readStats, FileGroupRecordBuffer<T> recordBuffer) {
        try (BaseHoodieLogRecordReader logRecordReader = ((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)HoodieMergedLogRecordReader.newBuilder().withHoodieReaderContext((HoodieReaderContext)readerContext)).withStorage(storage)).withLogFiles((List)inputSplit.getLogFiles())).withReverseReader(false)).withBufferSize(ConfigUtils.getIntWithAltKeys(props, HoodieMemoryConfig.MAX_DFS_STREAM_BUFFER_SIZE))).withInstantRange((Option)readerContext.getInstantRange())).withPartition(inputSplit.getPartitionPath())).withRecordBuffer(recordBuffer).withAllowInflightInstants(readerParameters.allowInflightInstants()).withMetaClient(hoodieTableMetaClient).withOptimizedLogBlocksScan(readerParameters.enableOptimizedLogBlockScan())).build();){
            readStats.setTotalLogReadTimeMs(((HoodieMergedLogRecordReader)logRecordReader).getTotalTimeTakenToReadAndMergeBlocks());
            readStats.setTotalUpdatedRecordsCompacted(((HoodieMergedLogRecordReader)logRecordReader).getNumMergedRecordsInLog());
            readStats.setTotalLogFilesCompacted(logRecordReader.getTotalLogFiles());
            readStats.setTotalLogRecords(logRecordReader.getTotalLogRecords());
            readStats.setTotalLogBlocks(logRecordReader.getTotalLogBlocks());
            readStats.setTotalCorruptLogBlock(logRecordReader.getTotalCorruptBlocks());
            readStats.setTotalRollbackBlocks(logRecordReader.getTotalRollbacks());
            List<String> list = logRecordReader.getValidBlockInstants();
            return list;
        }
    }
}

