/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read.buffer;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaCache;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.PartialUpdateMode;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.BufferedRecordMergerFactory;
import org.apache.hudi.common.table.read.BufferedRecords;
import org.apache.hudi.common.table.read.UpdateProcessor;
import org.apache.hudi.common.table.read.buffer.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.KeyBasedFileGroupRecordBuffer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieKeyException;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionBasedFileGroupRecordBuffer<T>
extends KeyBasedFileGroupRecordBuffer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PositionBasedFileGroupRecordBuffer.class);
    private static final String ROW_INDEX_COLUMN_NAME = "row_index";
    public static final String ROW_INDEX_TEMPORARY_COLUMN_NAME = "_tmp_metadata_row_index";
    protected final String baseFileInstantTime;
    private long nextRecordPosition = 0L;
    private boolean needToDoHybridStrategy = false;

    public PositionBasedFileGroupRecordBuffer(HoodieReaderContext<T> readerContext, HoodieTableMetaClient hoodieTableMetaClient, RecordMergeMode recordMergeMode, Option<PartialUpdateMode> partialUpdateModeOpt, String baseFileInstantTime, TypedProperties props, List<String> orderingFieldNames, UpdateProcessor<T> updateProcessor) {
        super(readerContext, hoodieTableMetaClient, recordMergeMode, partialUpdateModeOpt, props, orderingFieldNames, updateProcessor);
        this.baseFileInstantTime = baseFileInstantTime;
    }

    @Override
    public HoodieFileGroupRecordBuffer.BufferType getBufferType() {
        return this.readerContext.getShouldMergeUseRecordPosition() ? HoodieFileGroupRecordBuffer.BufferType.POSITION_BASED_MERGE : super.getBufferType();
    }

    @Override
    public void processDataBlock(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) throws IOException {
        if (!this.readerContext.getShouldMergeUseRecordPosition()) {
            super.processDataBlock(dataBlock, keySpecOpt);
            return;
        }
        List<Long> recordPositions = PositionBasedFileGroupRecordBuffer.extractRecordPositions(dataBlock, this.baseFileInstantTime);
        if (recordPositions == null) {
            LOG.debug("Falling back to key based merge for data block");
            this.fallbackToKeyBasedBuffer();
            super.processDataBlock(dataBlock, keySpecOpt);
            return;
        }
        HashSet<String> keys = new HashSet();
        boolean isFullKey = true;
        if (keySpecOpt.isPresent()) {
            if (!((KeySpec)keySpecOpt.get()).getKeys().isEmpty()) {
                keys = new HashSet<String>(((KeySpec)keySpecOpt.get()).getKeys());
            }
            isFullKey = ((KeySpec)keySpecOpt.get()).isFullKey();
        }
        if (dataBlock.containsPartialUpdates() && !this.enablePartialMerging) {
            this.enablePartialMerging = true;
            this.bufferedRecordMerger = BufferedRecordMergerFactory.create(this.readerContext, this.recordMergeMode, true, (Option<HoodieRecordMerger>)this.recordMerger, this.readerSchema, (Option<Pair<String, String>>)this.payloadClasses, this.props, (Option<PartialUpdateMode>)this.partialUpdateModeOpt);
        }
        Pair schemaTransformerWithEvolvedSchema = this.getSchemaTransformerWithEvolvedSchema(dataBlock);
        Schema schema = AvroSchemaCache.intern(schemaTransformerWithEvolvedSchema.getRight());
        try (ClosableIterator recordIterator = dataBlock.getEngineRecordIterator(this.readerContext);){
            int recordIndex = 0;
            while (recordIterator.hasNext()) {
                Object nextRecord = recordIterator.next();
                if (this.shouldSkip(nextRecord, isFullKey, keys, dataBlock.getSchema())) {
                    ++recordIndex;
                    continue;
                }
                long recordPosition = recordPositions.get(recordIndex++);
                Object evolvedNextRecord = schemaTransformerWithEvolvedSchema.getLeft().apply(nextRecord);
                boolean isDelete = this.readerContext.getRecordContext().isDeleteRecord(evolvedNextRecord, this.deleteContext);
                BufferedRecord bufferedRecord = BufferedRecords.fromEngineRecord(evolvedNextRecord, schema, this.readerContext.getRecordContext(), this.orderingFieldNames, isDelete);
                this.processNextDataRecord(bufferedRecord, Long.valueOf(recordPosition));
            }
        }
    }

    private void fallbackToKeyBasedBuffer() {
        this.readerContext.setShouldMergeUseRecordPosition(false);
        ArrayList positions = new ArrayList(this.records.keySet());
        for (Serializable position : positions) {
            BufferedRecord entry = (BufferedRecord)this.records.get(position);
            String recordKey = entry.getRecordKey();
            if (!entry.isDelete() || recordKey != null) {
                this.records.put(recordKey, entry);
                this.records.remove(position);
                continue;
            }
            this.needToDoHybridStrategy = true;
        }
    }

    @Override
    public void processDeleteBlock(HoodieDeleteBlock deleteBlock) throws IOException {
        if (!this.readerContext.getShouldMergeUseRecordPosition()) {
            super.processDeleteBlock(deleteBlock);
            return;
        }
        List<Long> recordPositions = PositionBasedFileGroupRecordBuffer.extractRecordPositions(deleteBlock, this.baseFileInstantTime);
        if (recordPositions == null) {
            LOG.debug("Falling back to key based merging for delete block");
            this.fallbackToKeyBasedBuffer();
            super.processDeleteBlock(deleteBlock);
            return;
        }
        switch (this.recordMergeMode) {
            case COMMIT_TIME_ORDERING: {
                int commitTimeBasedRecordIndex = 0;
                DeleteRecord[] deleteRecords = deleteBlock.getRecordsToDelete();
                for (Long recordPosition : recordPositions) {
                    DeleteRecord deleteRecord = deleteRecords[commitTimeBasedRecordIndex++];
                    BufferedRecord record = BufferedRecords.fromDeleteRecord(deleteRecord, this.readerContext.getRecordContext());
                    this.records.put(recordPosition, record);
                }
                return;
            }
        }
        int recordIndex = 0;
        Iterator it = Arrays.stream(deleteBlock.getRecordsToDelete()).iterator();
        while (it.hasNext()) {
            DeleteRecord record = (DeleteRecord)it.next();
            long recordPosition = recordPositions.get(recordIndex++);
            this.processNextDeletedRecord(record, Long.valueOf(recordPosition));
        }
    }

    @Override
    public boolean containsLogRecord(String recordKey) {
        return this.records.values().stream().filter(r -> !r.isDelete()).map(r -> this.readerContext.getRecordContext().getRecordKey(r.getRecord(), this.readerSchema)).anyMatch(recordKey::equals);
    }

    @Override
    protected boolean hasNextBaseRecord(T baseRecord) throws IOException {
        if (!this.readerContext.getShouldMergeUseRecordPosition()) {
            return this.doHasNextFallbackBaseRecord(baseRecord);
        }
        this.nextRecordPosition = this.readerContext.getRecordContext().extractRecordPosition(baseRecord, this.readerSchema, ROW_INDEX_TEMPORARY_COLUMN_NAME, this.nextRecordPosition);
        BufferedRecord logRecordInfo = (BufferedRecord)this.records.remove(this.nextRecordPosition++);
        return super.hasNextBaseRecord(baseRecord, logRecordInfo);
    }

    private boolean doHasNextFallbackBaseRecord(T baseRecord) throws IOException {
        if (this.needToDoHybridStrategy) {
            BufferedRecord logRecordInfo;
            this.nextRecordPosition = this.readerContext.getRecordContext().extractRecordPosition(baseRecord, this.readerSchema, ROW_INDEX_TEMPORARY_COLUMN_NAME, this.nextRecordPosition);
            if ((logRecordInfo = (BufferedRecord)this.records.remove(this.nextRecordPosition++)) != null) {
                this.records.remove(this.readerContext.getRecordContext().getRecordKey(baseRecord, this.readerSchema));
                return false;
            }
        }
        return super.hasNextBaseRecord(baseRecord);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean shouldSkip(T record, boolean isFullKey, Set<String> keys, Schema writerSchema) {
        if (keys.isEmpty()) {
            return false;
        }
        String recordKey = this.readerContext.getRecordContext().getRecordKey(record, writerSchema);
        if (recordKey == null) throw new HoodieKeyException("Can not extract the key for a record");
        if (recordKey.isEmpty()) {
            throw new HoodieKeyException("Can not extract the key for a record");
        }
        if (isFullKey) {
            if (keys.contains(recordKey)) return false;
        }
        if (isFullKey) return true;
        if (!keys.stream().noneMatch(recordKey::startsWith)) return false;
        return true;
    }

    protected static List<Long> extractRecordPositions(HoodieLogBlock logBlock, String baseFileInstantTime) throws IOException {
        ArrayList<Long> blockPositions = new ArrayList<Long>();
        String blockBaseFileInstantTime = logBlock.getBaseFileInstantTimeOfPositions();
        if (StringUtils.isNullOrEmpty((String)blockBaseFileInstantTime) || !baseFileInstantTime.equals(blockBaseFileInstantTime)) {
            LOG.debug("The record positions cannot be used because the base file instant time is either missing or different from the base file to merge. Instant time in the header: {}, base file instant time of the file group: {}.", (Object)blockBaseFileInstantTime, (Object)baseFileInstantTime);
            return null;
        }
        Roaring64NavigableMap positions = logBlock.getRecordPositions();
        if (positions == null || positions.isEmpty()) {
            LOG.info("No record position info is found when attempting to do position based merge.");
            return null;
        }
        Iterator iterator = positions.iterator();
        while (iterator.hasNext()) {
            blockPositions.add((Long)iterator.next());
        }
        if (blockPositions.isEmpty()) {
            LOG.info("No positions are extracted.");
            return null;
        }
        return blockPositions;
    }
}

