/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read.buffer;

import java.io.Closeable;
import java.util.List;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.PartialUpdateMode;
import org.apache.hudi.common.table.read.BaseFileUpdateCallback;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.table.read.InputSplit;
import org.apache.hudi.common.table.read.ReaderParameters;
import org.apache.hudi.common.table.read.UpdateProcessor;
import org.apache.hudi.common.table.read.buffer.FileGroupRecordBufferLoader;
import org.apache.hudi.common.table.read.buffer.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.KeyBasedFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.LogScanningRecordBufferLoader;
import org.apache.hudi.common.table.read.buffer.ReusableKeyBasedRecordBuffer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.storage.HoodieStorage;

public class ReusableFileGroupRecordBufferLoader<T>
extends LogScanningRecordBufferLoader
implements FileGroupRecordBufferLoader<T>,
Closeable {
    private final HoodieReaderContext<T> readerContextWithoutFilters;
    private Pair<KeyBasedFileGroupRecordBuffer<T>, List<String>> cachedResults;

    ReusableFileGroupRecordBufferLoader(HoodieReaderContext<T> readerContextWithoutFilters) {
        this.readerContextWithoutFilters = readerContextWithoutFilters;
    }

    @Override
    public synchronized Pair<HoodieFileGroupRecordBuffer<T>, List<String>> getRecordBuffer(HoodieReaderContext<T> readerContext, HoodieStorage storage, InputSplit inputSplit, List<String> orderingFieldNames, HoodieTableMetaClient hoodieTableMetaClient, TypedProperties props, ReaderParameters readerParameters, HoodieReadStats readStats, Option<BaseFileUpdateCallback<T>> fileGroupUpdateCallback) {
        UpdateProcessor<T> updateProcessor = UpdateProcessor.create(readStats, readerContext, readerParameters.emitDeletes(), fileGroupUpdateCallback, props);
        Option<PartialUpdateMode> partialUpdateModeOpt = hoodieTableMetaClient.getTableConfig().getPartialUpdateMode();
        if (this.cachedResults == null) {
            KeyBasedFileGroupRecordBuffer<T> initialBuffer = new KeyBasedFileGroupRecordBuffer<T>(readerContext, hoodieTableMetaClient, readerContext.getMergeMode(), partialUpdateModeOpt, props, orderingFieldNames, updateProcessor);
            List<String> validInstants = this.scanLogFiles(this.readerContextWithoutFilters, storage, inputSplit, hoodieTableMetaClient, props, readerParameters, readStats, initialBuffer);
            this.cachedResults = Pair.of(initialBuffer, validInstants);
        }
        ReusableKeyBasedRecordBuffer<T> reusableBuffer = new ReusableKeyBasedRecordBuffer<T>(readerContext, hoodieTableMetaClient, readerContext.getMergeMode(), partialUpdateModeOpt, props, orderingFieldNames, updateProcessor, this.cachedResults.getLeft().getLogRecords());
        return Pair.of(reusableBuffer, this.cachedResults.getRight());
    }

    @Override
    public void close() {
        if (this.cachedResults != null && this.cachedResults.getLeft() != null) {
            this.cachedResults.getLeft().close();
            this.cachedResults = null;
        }
    }
}

