/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read.buffer;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.PartialUpdateMode;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.UpdateProcessor;
import org.apache.hudi.common.table.read.buffer.FileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.expression.Expression;
import org.apache.hudi.expression.Predicates;

public class ReusableKeyBasedRecordBuffer<T>
extends FileGroupRecordBuffer<T> {
    private final Set<String> validKeys;
    private final Map<Serializable, BufferedRecord<T>> existingRecords;

    ReusableKeyBasedRecordBuffer(HoodieReaderContext<T> readerContext, HoodieTableMetaClient hoodieTableMetaClient, RecordMergeMode recordMergeMode, Option<PartialUpdateMode> partialUpdateModeOpt, TypedProperties props, List<String> orderingFieldNames, UpdateProcessor<T> updateProcessor, Map<Serializable, BufferedRecord<T>> records) {
        super(readerContext, hoodieTableMetaClient, recordMergeMode, partialUpdateModeOpt, props, orderingFieldNames, updateProcessor);
        this.existingRecords = records;
        ValidationUtils.checkArgument((boolean)(readerContext.getKeyFilterOpt().orElse(null) instanceof Predicates.In), () -> "Key filter should be of type Predicates.In, but found: " + (String)readerContext.getKeyFilterOpt().map(filter -> filter.getClass().getSimpleName()).orElse((Object)"NULL"));
        List<Expression> children = ((Predicates.In)readerContext.getKeyFilterOpt().get()).getRightChildren();
        this.validKeys = children.stream().map(e -> (String)e.eval(null)).collect(Collectors.toSet());
    }

    @Override
    protected ExternalSpillableMap<Serializable, BufferedRecord<T>> initializeRecordsMap(String spillableMapBasePath) {
        return null;
    }

    @Override
    protected void initializeLogRecordIterator() {
        this.logRecordIterator = new RemainingRecordIterator<BufferedRecord<T>>(this.validKeys, this.existingRecords);
    }

    @Override
    public HoodieFileGroupRecordBuffer.BufferType getBufferType() {
        return HoodieFileGroupRecordBuffer.BufferType.KEY_BASED_MERGE;
    }

    @Override
    protected boolean doHasNext() throws IOException {
        ValidationUtils.checkState((this.baseFileIterator != null ? 1 : 0) != 0, (String)"Base file iterator has not been set yet");
        while (this.baseFileIterator.hasNext()) {
            if (!this.hasNextBaseRecord(this.baseFileIterator.next())) continue;
            return true;
        }
        return this.hasNextLogRecord();
    }

    protected boolean hasNextBaseRecord(T baseRecord) throws IOException {
        String recordKey = this.readerContext.getRecordContext().getRecordKey(baseRecord, this.readerSchema);
        BufferedRecord<T> logRecordInfo = this.existingRecords.get(recordKey);
        if (logRecordInfo != null) {
            this.validKeys.remove(recordKey);
        }
        return this.hasNextBaseRecord(baseRecord, logRecordInfo);
    }

    @Override
    public void processDataBlock(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) {
        throw new HoodieNotSupportedException("Reusable record buffer does not perform the processing of the data blocks");
    }

    @Override
    public void processNextDataRecord(BufferedRecord<T> record, Serializable index) {
        throw new HoodieNotSupportedException("Reusable record buffer does not process the data records from the logs");
    }

    @Override
    public void processDeleteBlock(HoodieDeleteBlock deleteBlock) {
        throw new HoodieNotSupportedException("Reusable record buffer does not perform the processing of the delete blocks");
    }

    @Override
    public void processNextDeletedRecord(DeleteRecord record, Serializable index) {
        throw new HoodieNotSupportedException("Reusable record buffer does not process the delete records from the logs");
    }

    @Override
    public boolean containsLogRecord(String recordKey) {
        return this.validKeys.contains(recordKey) && this.existingRecords.containsKey(recordKey);
    }

    @Override
    public void close() {
    }

    private static class RemainingRecordIterator<T>
    implements Iterator<T> {
        private final Iterator<String> validKeys;
        private final Map<Serializable, T> recordsByKey;
        private String nextKey;

        public RemainingRecordIterator(Set<String> validKeys, Map<Serializable, T> recordsByKey) {
            this.validKeys = validKeys.iterator();
            this.recordsByKey = recordsByKey;
        }

        @Override
        public boolean hasNext() {
            if (this.nextKey != null) {
                return true;
            }
            while (this.nextKey == null && this.validKeys.hasNext()) {
                String candidateKey = this.validKeys.next();
                if (!this.recordsByKey.containsKey(candidateKey)) continue;
                this.nextKey = candidateKey;
            }
            return this.nextKey != null;
        }

        @Override
        public T next() {
            T result = this.recordsByKey.get(this.nextKey);
            this.nextKey = null;
            return result;
        }
    }
}

