/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read.buffer;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.PartialUpdateMode;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.UpdateProcessor;
import org.apache.hudi.common.table.read.buffer.KeyBasedFileGroupRecordBuffer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;

class SortedKeyBasedFileGroupRecordBuffer<T>
extends KeyBasedFileGroupRecordBuffer<T> {
    private Option<T> queuedBaseFileRecord = Option.empty();
    private Queue<String> logRecordKeysSorted = null;

    SortedKeyBasedFileGroupRecordBuffer(HoodieReaderContext<T> readerContext, HoodieTableMetaClient hoodieTableMetaClient, RecordMergeMode recordMergeMode, Option<PartialUpdateMode> partialUpdateModeOpt, TypedProperties props, List<String> orderingFieldNames, UpdateProcessor<T> updateProcessor) {
        super(readerContext, hoodieTableMetaClient, recordMergeMode, partialUpdateModeOpt, props, orderingFieldNames, updateProcessor);
    }

    @Override
    protected void initializeLogRecordIterator() {
        this.logRecordIterator = this.records.values().stream().sorted(Comparator.comparing(BufferedRecord::getRecordKey)).iterator();
    }

    @Override
    protected boolean hasNextBaseRecord(T baseRecord) throws IOException {
        String recordKey = this.readerContext.getRecordContext().getRecordKey(baseRecord, this.readerSchema);
        int comparison = 0;
        while (!this.getLogRecordKeysSorted().isEmpty() && (comparison = this.getLogRecordKeysSorted().peek().compareTo(recordKey)) <= 0) {
            String nextLogRecordKey = this.getLogRecordKeysSorted().poll();
            if (comparison == 0) break;
            BufferedRecord nextLogRecord = (BufferedRecord)this.records.remove(nextLogRecordKey);
            this.nextRecord = this.updateProcessor.processUpdate(recordKey, null, nextLogRecord, nextLogRecord.isDelete());
            if (this.nextRecord == null) continue;
            this.queuedBaseFileRecord = Option.of(baseRecord);
            return true;
        }
        BufferedRecord logRecordInfo = comparison == 0 ? (BufferedRecord)this.records.remove(recordKey) : null;
        return this.hasNextBaseRecord(baseRecord, logRecordInfo);
    }

    @Override
    protected boolean doHasNext() throws IOException {
        ValidationUtils.checkState((this.baseFileIterator != null ? 1 : 0) != 0, (String)"Base file iterator has not been set yet");
        if (this.queuedBaseFileRecord.isPresent()) {
            Object nextRecord = this.queuedBaseFileRecord.get();
            this.queuedBaseFileRecord = Option.empty();
            if (this.hasNextBaseRecord(nextRecord)) {
                return true;
            }
        }
        return super.doHasNext();
    }

    private Queue<String> getLogRecordKeysSorted() {
        if (this.logRecordKeysSorted == null) {
            this.logRecordKeysSorted = this.records.keySet().stream().map(Object::toString).collect(Collectors.toCollection(PriorityQueue::new));
        }
        return this.logRecordKeysSorted;
    }
}

