/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read.buffer;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaCache;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.PartialUpdateMode;
import org.apache.hudi.common.table.read.BaseFileUpdateCallback;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.BufferedRecords;
import org.apache.hudi.common.table.read.DeleteContext;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.table.read.InputSplit;
import org.apache.hudi.common.table.read.ReaderParameters;
import org.apache.hudi.common.table.read.UpdateProcessor;
import org.apache.hudi.common.table.read.buffer.FileGroupRecordBufferLoader;
import org.apache.hudi.common.table.read.buffer.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.KeyBasedFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.SortedKeyBasedFileGroupRecordBuffer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;

public class StreamingFileGroupRecordBufferLoader<T>
implements FileGroupRecordBufferLoader<T> {
    private static final StreamingFileGroupRecordBufferLoader INSTANCE = new StreamingFileGroupRecordBufferLoader();

    static <T> StreamingFileGroupRecordBufferLoader<T> getInstance() {
        return INSTANCE;
    }

    @Override
    public Pair<HoodieFileGroupRecordBuffer<T>, List<String>> getRecordBuffer(HoodieReaderContext<T> readerContext, HoodieStorage storage, InputSplit inputSplit, List<String> orderingFieldNames, HoodieTableMetaClient hoodieTableMetaClient, TypedProperties props, ReaderParameters readerParameters, HoodieReadStats readStats, Option<BaseFileUpdateCallback<T>> fileGroupUpdateCallback) {
        Schema recordSchema = AvroSchemaCache.intern(StreamingFileGroupRecordBufferLoader.getRecordSchema(readerContext, props));
        readerContext.getSchemaHandler().setSchemaForUpdates(recordSchema);
        HoodieTableConfig tableConfig = hoodieTableMetaClient.getTableConfig();
        Option<PartialUpdateMode> partialUpdateModeOpt = tableConfig.getPartialUpdateMode();
        UpdateProcessor<T> updateProcessor = UpdateProcessor.create(readStats, readerContext, readerParameters.emitDeletes(), fileGroupUpdateCallback, props);
        KeyBasedFileGroupRecordBuffer recordBuffer = readerParameters.sortOutputs() ? new SortedKeyBasedFileGroupRecordBuffer<T>(readerContext, hoodieTableMetaClient, readerContext.getMergeMode(), partialUpdateModeOpt, props, orderingFieldNames, updateProcessor) : new KeyBasedFileGroupRecordBuffer<T>(readerContext, hoodieTableMetaClient, readerContext.getMergeMode(), partialUpdateModeOpt, props, orderingFieldNames, updateProcessor);
        RecordContext<T> recordContext = readerContext.getRecordContext();
        Iterator<HoodieRecord> recordIterator = inputSplit.getRecordIterator();
        String[] orderingFieldsArray = orderingFieldNames.toArray(new String[0]);
        DeleteContext deleteContext = DeleteContext.fromRecordSchema(props, recordSchema);
        while (recordIterator.hasNext()) {
            HoodieRecord hoodieRecord = recordIterator.next();
            try {
                BufferedRecord<T> bufferedRecord = BufferedRecords.fromHoodieRecord(hoodieRecord, recordSchema, recordContext, (Properties)props, orderingFieldsArray, deleteContext);
                recordBuffer.processNextDataRecord(bufferedRecord, (Serializable)((Object)bufferedRecord.getRecordKey()));
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to process next buffered record", e);
            }
        }
        return Pair.of(recordBuffer, Collections.emptyList());
    }

    private static <T> Schema getRecordSchema(HoodieReaderContext<T> readerContext, TypedProperties props) {
        Option<Pair<String, String>> payloadClasses = readerContext.getPayloadClasses(props);
        if (payloadClasses.isPresent() && ((String)((Pair)payloadClasses.get()).getRight()).equals("org.apache.spark.sql.hudi.command.payload.ExpressionPayload")) {
            String schemaStr = props.getString("hoodie.payload.record.schema");
            return new Schema.Parser().parse(schemaStr);
        }
        return HoodieAvroUtils.removeMetadataFields(readerContext.getSchemaHandler().getRequestedSchema());
    }
}

