/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read.buffer;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.PartialUpdateMode;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.table.read.buffer.FileGroupRecordBuffer;
import org.apache.hudi.common.table.read.buffer.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;

class UnmergedFileGroupRecordBuffer<T>
extends FileGroupRecordBuffer<T> {
    private final Deque<HoodieLogBlock> currentInstantLogBlocks;
    private final HoodieReadStats readStats;
    private ClosableIterator<T> recordIterator;

    UnmergedFileGroupRecordBuffer(HoodieReaderContext<T> readerContext, HoodieTableMetaClient hoodieTableMetaClient, RecordMergeMode recordMergeMode, Option<PartialUpdateMode> partialUpdateModeOpt, TypedProperties props, HoodieReadStats readStats) {
        super(readerContext, hoodieTableMetaClient, recordMergeMode, partialUpdateModeOpt, props, Collections.emptyList(), null);
        this.readStats = readStats;
        this.currentInstantLogBlocks = new ArrayDeque<HoodieLogBlock>();
    }

    @Override
    protected boolean doHasNext() {
        ValidationUtils.checkState((this.baseFileIterator != null ? 1 : 0) != 0, (String)"Base file iterator has not been set yet");
        if (this.baseFileIterator.hasNext()) {
            this.nextRecord = this.bufferedRecordConverter.convert(this.readerContext.getRecordContext().seal(this.baseFileIterator.next()));
            return true;
        }
        while (!(this.recordIterator != null && this.recordIterator.hasNext() || this.currentInstantLogBlocks.isEmpty())) {
            HoodieLogBlock logBlock = this.currentInstantLogBlocks.pop();
            if (!(logBlock instanceof HoodieDataBlock)) continue;
            HoodieDataBlock dataBlock = (HoodieDataBlock)logBlock;
            Pair iteratorSchemaPair = this.getRecordsIterator(dataBlock, (Option<KeySpec>)Option.empty());
            if (this.recordIterator != null) {
                this.recordIterator.close();
            }
            this.recordIterator = iteratorSchemaPair.getLeft();
        }
        if (this.recordIterator == null || !this.recordIterator.hasNext()) {
            return false;
        }
        this.nextRecord = this.bufferedRecordConverter.convert(this.readerContext.getRecordContext().seal(this.recordIterator.next()));
        this.readStats.incrementNumInserts();
        return true;
    }

    @Override
    public ClosableIterator<BufferedRecord<T>> getLogRecordIterator() {
        throw new UnsupportedOperationException("Not supported for " + this.getClass().getSimpleName());
    }

    @Override
    public HoodieFileGroupRecordBuffer.BufferType getBufferType() {
        return HoodieFileGroupRecordBuffer.BufferType.UNMERGED;
    }

    @Override
    public void processDataBlock(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) {
        this.currentInstantLogBlocks.add(dataBlock);
    }

    @Override
    public void processNextDataRecord(BufferedRecord<T> record, Serializable index) {
    }

    @Override
    public void processDeleteBlock(HoodieDeleteBlock deleteBlock) {
    }

    @Override
    public void processNextDeletedRecord(DeleteRecord deleteRecord, Serializable index) {
    }

    @Override
    public boolean containsLogRecord(String recordKey) {
        throw new UnsupportedOperationException("Not supported for " + this.getClass().getSimpleName());
    }

    @Override
    public void close() {
        if (this.recordIterator != null) {
            this.recordIterator.close();
        }
        super.close();
    }
}

