/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import org.apache.hudi.common.util.StringUtils;

public class HoodieInstant
implements Serializable,
Comparable<HoodieInstant> {
    public static final String FILE_NAME_FORMAT_ERROR = "The provided file name %s does not conform to the required format";
    public static final String UNDERSCORE = "_";
    public static final String EMPTY_FILE_EXTENSION = "";
    private final State state;
    private final String action;
    private final String requestedTime;
    private final String completionTime;
    private boolean isLegacy = false;
    private final Comparator<HoodieInstant> comparator;

    public HoodieInstant(State state, String action, String requestTime, Comparator<HoodieInstant> comparator) {
        this(state, action, requestTime, null, comparator);
    }

    public HoodieInstant(State state, String action, String requestTime, String completionTime, Comparator<HoodieInstant> comparator) {
        this(state, action, requestTime, completionTime, false, comparator);
    }

    public HoodieInstant(State state, String action, String requestedTime, String completionTime, boolean isLegacy, Comparator<HoodieInstant> comparator) {
        this.state = state;
        this.action = action;
        this.requestedTime = requestedTime;
        this.completionTime = completionTime;
        this.isLegacy = isLegacy;
        this.comparator = comparator;
    }

    public boolean isCompleted() {
        return this.state == State.COMPLETED;
    }

    public boolean isInflight() {
        return this.state == State.INFLIGHT;
    }

    public boolean isRequested() {
        return this.state == State.REQUESTED;
    }

    public String getAction() {
        return this.action;
    }

    public String requestedTime() {
        return this.requestedTime;
    }

    public boolean isLegacy() {
        return this.isLegacy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieInstant that = (HoodieInstant)o;
        return this.state == that.state && Objects.equals(this.action, that.action) && Objects.equals(this.requestedTime, that.requestedTime);
    }

    public State getState() {
        return this.state;
    }

    public String getCompletionTime() {
        return this.completionTime;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.action, this.requestedTime});
    }

    @Override
    public int compareTo(HoodieInstant o) {
        return this.comparator.compare(this, o);
    }

    public String toString() {
        return "[" + (this.isInflight() || this.isRequested() ? "==>" : EMPTY_FILE_EXTENSION) + this.requestedTime + (StringUtils.isNullOrEmpty((String)this.completionTime) ? EMPTY_FILE_EXTENSION : "__" + this.completionTime) + "__" + this.action + "__" + (Object)((Object)this.state) + "]";
    }

    public static enum State {
        REQUESTED,
        INFLIGHT,
        COMPLETED,
        NIL;

    }
}

