/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.hudi.avro.model.HoodieArchivedMetaEntry;
import org.apache.hudi.avro.model.HoodieCommitMetadata;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieLSMTimelineInstant;
import org.apache.hudi.avro.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.common.model.ActionType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.ActiveAction;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.JsonUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataConversionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataConversionUtils.class);

    public static HoodieArchivedMetaEntry createMetaWrapper(HoodieInstant hoodieInstant, HoodieTableMetaClient metaClient) {
        try {
            HoodieArchivedMetaEntry archivedMetaWrapper = new HoodieArchivedMetaEntry();
            archivedMetaWrapper.setCommitTime(hoodieInstant.requestedTime());
            archivedMetaWrapper.setActionState(hoodieInstant.getState().name());
            archivedMetaWrapper.setStateTransitionTime(hoodieInstant.getCompletionTime());
            CommitMetadataSerDe serDe = metaClient.getCommitMetadataSerDe();
            switch (hoodieInstant.getAction()) {
                case "clean": {
                    if (hoodieInstant.isCompleted()) {
                        archivedMetaWrapper.setHoodieCleanMetadata(CleanerUtils.getCleanerMetadata(metaClient, hoodieInstant));
                    } else {
                        archivedMetaWrapper.setHoodieCleanerPlan(CleanerUtils.getCleanerPlan(metaClient, hoodieInstant));
                    }
                    archivedMetaWrapper.setActionType(ActionType.clean.name());
                    break;
                }
                case "commit": {
                    MetadataConversionUtils.getCommitMetadata(metaClient, hoodieInstant, org.apache.hudi.common.model.HoodieCommitMetadata.class).ifPresent(commitMetadata -> archivedMetaWrapper.setHoodieCommitMetadata((HoodieCommitMetadata)((Object)((Object)MetadataConversionUtils.convertCommitMetadataToAvro(commitMetadata)))));
                    archivedMetaWrapper.setActionType(ActionType.commit.name());
                    break;
                }
                case "deltacommit": {
                    MetadataConversionUtils.getCommitMetadata(metaClient, hoodieInstant, org.apache.hudi.common.model.HoodieCommitMetadata.class).ifPresent(deltaCommitMetadata -> archivedMetaWrapper.setHoodieCommitMetadata((HoodieCommitMetadata)((Object)((Object)MetadataConversionUtils.convertCommitMetadataToAvro(deltaCommitMetadata)))));
                    archivedMetaWrapper.setActionType(ActionType.deltacommit.name());
                    break;
                }
                case "replacecommit": 
                case "clustering": {
                    if (hoodieInstant.isCompleted()) {
                        MetadataConversionUtils.getCommitMetadata(metaClient, hoodieInstant, org.apache.hudi.common.model.HoodieReplaceCommitMetadata.class).ifPresent(replaceCommitMetadata -> archivedMetaWrapper.setHoodieReplaceCommitMetadata((HoodieReplaceCommitMetadata)((Object)((Object)MetadataConversionUtils.convertCommitMetadataToAvro(replaceCommitMetadata)))));
                    } else if (hoodieInstant.isInflight()) {
                        Option<org.apache.hudi.common.model.HoodieCommitMetadata> inflightCommitMetadata = MetadataConversionUtils.getCommitMetadata(metaClient, hoodieInstant, org.apache.hudi.common.model.HoodieCommitMetadata.class);
                        if (inflightCommitMetadata.isPresent()) {
                            archivedMetaWrapper.setHoodieInflightReplaceMetadata((HoodieCommitMetadata)((Object)MetadataConversionUtils.convertCommitMetadataToAvro((org.apache.hudi.common.model.HoodieCommitMetadata)inflightCommitMetadata.get())));
                        }
                    } else {
                        Option requestedReplaceMetadata = Option.of((Object)((Object)metaClient.getActiveTimeline().readRequestedReplaceMetadata(hoodieInstant)));
                        if (requestedReplaceMetadata.isPresent()) {
                            archivedMetaWrapper.setHoodieRequestedReplaceMetadata((HoodieRequestedReplaceMetadata)((Object)requestedReplaceMetadata.get()));
                        }
                    }
                    archivedMetaWrapper.setActionType(hoodieInstant.getAction().equals("replacecommit") ? ActionType.replacecommit.name() : ActionType.clustering.name());
                    break;
                }
                case "rollback": {
                    if (hoodieInstant.isCompleted()) {
                        archivedMetaWrapper.setHoodieRollbackMetadata(metaClient.getActiveTimeline().readRollbackMetadata(hoodieInstant));
                    }
                    archivedMetaWrapper.setActionType(ActionType.rollback.name());
                    break;
                }
                case "savepoint": {
                    archivedMetaWrapper.setHoodieSavePointMetadata(metaClient.getActiveTimeline().readSavepointMetadata(hoodieInstant));
                    archivedMetaWrapper.setActionType(ActionType.savepoint.name());
                    break;
                }
                case "compaction": {
                    if (hoodieInstant.isRequested()) {
                        HoodieCompactionPlan plan = CompactionUtils.getCompactionPlan(metaClient, hoodieInstant);
                        archivedMetaWrapper.setHoodieCompactionPlan(plan);
                    }
                    archivedMetaWrapper.setActionType(ActionType.compaction.name());
                    break;
                }
                case "logcompaction": {
                    if (hoodieInstant.isRequested()) {
                        HoodieCompactionPlan plan = CompactionUtils.getCompactionPlan(metaClient, hoodieInstant);
                        archivedMetaWrapper.setHoodieCompactionPlan(plan);
                    }
                    archivedMetaWrapper.setActionType(ActionType.logcompaction.name());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Action not fully supported yet");
                }
            }
            return archivedMetaWrapper;
        }
        catch (IOException | HoodieIOException ex) {
            if (metaClient.getActiveTimeline().isEmpty(hoodieInstant)) {
                return MetadataConversionUtils.createMetaWrapperForEmptyInstant(hoodieInstant);
            }
            throw new HoodieException(ex);
        }
    }

    public static HoodieArchivedMetaEntry createMetaWrapper(HoodieTableMetaClient metaClient, GenericRecord lsmTimelineRecord) throws IOException {
        ValidationUtils.checkState((boolean)metaClient.getTableConfig().getTableVersion().greaterThanOrEquals(HoodieTableVersion.EIGHT), (String)"The meta client should be created from table version >= 8");
        ByteBuffer metadataBuffer = (ByteBuffer)lsmTimelineRecord.get("metadata");
        Option instantDetails = metadataBuffer != null ? Option.of((Object)metadataBuffer.array()) : Option.empty();
        ByteBuffer planBuffer = (ByteBuffer)lsmTimelineRecord.get("plan");
        Option planBytes = planBuffer != null ? Option.of((Object)planBuffer.array()) : Option.empty();
        String instantTime = lsmTimelineRecord.get("instantTime").toString();
        String completionTime = lsmTimelineRecord.get("completionTime").toString();
        HoodieArchivedMetaEntry archivedMetaWrapper = new HoodieArchivedMetaEntry();
        archivedMetaWrapper.setCommitTime(instantTime);
        archivedMetaWrapper.setActionState(HoodieInstant.State.COMPLETED.name());
        archivedMetaWrapper.setStateTransitionTime(completionTime);
        String actionType = lsmTimelineRecord.get("action").toString();
        HoodieInstant hoodieInstant = metaClient.getInstantGenerator().createNewInstant(HoodieInstant.State.COMPLETED, actionType, instantTime, completionTime);
        switch (actionType) {
            case "clean": {
                archivedMetaWrapper.setHoodieCleanMetadata(CleanerUtils.getCleanerMetadata(metaClient, new ByteArrayInputStream((byte[])instantDetails.get())));
                if (planBytes.isPresent()) {
                    archivedMetaWrapper.setHoodieCleanerPlan(CleanerUtils.getCleanerPlan(metaClient, new ByteArrayInputStream((byte[])planBytes.get())));
                }
                archivedMetaWrapper.setActionType(ActionType.clean.name());
                break;
            }
            case "commit": {
                org.apache.hudi.common.model.HoodieCommitMetadata commitMetadata = metaClient.getCommitMetadataSerDe().deserialize(hoodieInstant, new ByteArrayInputStream((byte[])instantDetails.get()), () -> ((byte[])instantDetails.get()).length == 0, org.apache.hudi.common.model.HoodieCommitMetadata.class);
                archivedMetaWrapper.setHoodieCommitMetadata((HoodieCommitMetadata)((Object)MetadataConversionUtils.convertCommitMetadataToAvro(commitMetadata)));
                archivedMetaWrapper.setActionType(ActionType.commit.name());
                if (!planBytes.isPresent()) break;
                HoodieCompactionPlan plan = CompactionUtils.getCompactionPlan(metaClient, new ByteArrayInputStream((byte[])planBytes.get()));
                archivedMetaWrapper.setHoodieCompactionPlan(plan);
                break;
            }
            case "deltacommit": {
                org.apache.hudi.common.model.HoodieCommitMetadata deltaCommitMetadata = metaClient.getCommitMetadataSerDe().deserialize(hoodieInstant, new ByteArrayInputStream((byte[])instantDetails.get()), () -> ((byte[])instantDetails.get()).length == 0, org.apache.hudi.common.model.HoodieCommitMetadata.class);
                archivedMetaWrapper.setHoodieCommitMetadata((HoodieCommitMetadata)((Object)MetadataConversionUtils.convertCommitMetadataToAvro(deltaCommitMetadata)));
                archivedMetaWrapper.setActionType(ActionType.deltacommit.name());
                if (!planBytes.isPresent()) break;
                HoodieCompactionPlan plan = CompactionUtils.getCompactionPlan(metaClient, new ByteArrayInputStream((byte[])planBytes.get()));
                archivedMetaWrapper.setHoodieCompactionPlan(plan);
                break;
            }
            case "replacecommit": 
            case "clustering": {
                org.apache.hudi.common.model.HoodieCommitMetadata replaceCommitMetadata = metaClient.getCommitMetadataSerDe().deserialize(hoodieInstant, new ByteArrayInputStream((byte[])instantDetails.get()), () -> ((byte[])instantDetails.get()).length == 0, org.apache.hudi.common.model.HoodieReplaceCommitMetadata.class);
                archivedMetaWrapper.setHoodieReplaceCommitMetadata((HoodieReplaceCommitMetadata)((Object)MetadataConversionUtils.convertCommitMetadataToAvro(replaceCommitMetadata)));
                Option<org.apache.hudi.common.model.HoodieCommitMetadata> inflightCommitMetadata = MetadataConversionUtils.getInflightCommitMetadata(metaClient, hoodieInstant, (Option<byte[]>)instantDetails);
                if (inflightCommitMetadata.isPresent()) {
                    archivedMetaWrapper.setHoodieInflightReplaceMetadata((HoodieCommitMetadata)((Object)MetadataConversionUtils.convertCommitMetadataToAvro((org.apache.hudi.common.model.HoodieCommitMetadata)inflightCommitMetadata.get())));
                }
                archivedMetaWrapper.setActionType(ActionType.replacecommit.name());
                break;
            }
            case "rollback": {
                archivedMetaWrapper.setHoodieRollbackMetadata(TimelineMetadataUtils.deserializeAvroMetadata(new ByteArrayInputStream((byte[])instantDetails.get()), HoodieRollbackMetadata.class));
                archivedMetaWrapper.setActionType(ActionType.rollback.name());
                break;
            }
            case "savepoint": {
                archivedMetaWrapper.setHoodieSavePointMetadata(TimelineMetadataUtils.deserializeAvroMetadata(new ByteArrayInputStream((byte[])instantDetails.get()), HoodieSavepointMetadata.class));
                archivedMetaWrapper.setActionType(ActionType.savepoint.name());
                break;
            }
            case "compaction": {
                HoodieCompactionPlan plan = CompactionUtils.getCompactionPlan(metaClient, new ByteArrayInputStream((byte[])planBytes.get()));
                archivedMetaWrapper.setHoodieCompactionPlan(plan);
                archivedMetaWrapper.setActionType(ActionType.compaction.name());
                break;
            }
            case "logcompaction": {
                HoodieCompactionPlan plan = CompactionUtils.getCompactionPlan(metaClient, new ByteArrayInputStream((byte[])planBytes.get()));
                archivedMetaWrapper.setHoodieCompactionPlan(plan);
                archivedMetaWrapper.setActionType(ActionType.logcompaction.name());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Action not fully supported yet");
            }
        }
        return archivedMetaWrapper;
    }

    private static Option<org.apache.hudi.common.model.HoodieCommitMetadata> getInflightCommitMetadata(HoodieTableMetaClient metaClient, HoodieInstant instant, Option<byte[]> inflightContent) throws IOException {
        if (!inflightContent.isPresent() || ((byte[])inflightContent.get()).length == 0) {
            return Option.empty();
        }
        return Option.of((Object)metaClient.getCommitMetadataSerDe().deserialize(instant, new ByteArrayInputStream((byte[])inflightContent.get()), () -> ((byte[])inflightContent.get()).length == 0, org.apache.hudi.common.model.HoodieCommitMetadata.class));
    }

    public static HoodieLSMTimelineInstant createLSMTimelineInstant(ActiveAction activeAction, HoodieTableMetaClient metaClient) {
        HoodieLSMTimelineInstant lsmTimelineInstant = new HoodieLSMTimelineInstant();
        lsmTimelineInstant.setInstantTime(activeAction.getInstantTime());
        lsmTimelineInstant.setCompletionTime(activeAction.getCompletionTime());
        lsmTimelineInstant.setAction(activeAction.getAction());
        activeAction.getCommitMetadata(metaClient).ifPresent(commitMetadata -> lsmTimelineInstant.setMetadata(ByteBuffer.wrap(commitMetadata)));
        lsmTimelineInstant.setVersion(1);
        switch (activeAction.getPendingAction()) {
            case "clean": {
                activeAction.getCleanPlan(metaClient).ifPresent(plan -> lsmTimelineInstant.setPlan(ByteBuffer.wrap(plan)));
                break;
            }
            case "replacecommit": 
            case "clustering": {
                activeAction.getRequestedCommitMetadata(metaClient).ifPresent(metadata -> lsmTimelineInstant.setPlan(ByteBuffer.wrap(metadata)));
                activeAction.getInflightCommitMetadata(metaClient).ifPresent(metadata -> lsmTimelineInstant.setPlan(ByteBuffer.wrap(metadata)));
                break;
            }
            case "compaction": {
                activeAction.getCompactionPlan(metaClient).ifPresent(plan -> lsmTimelineInstant.setPlan(ByteBuffer.wrap(plan)));
                break;
            }
            case "logcompaction": {
                activeAction.getLogCompactionPlan(metaClient).ifPresent(plan -> lsmTimelineInstant.setPlan(ByteBuffer.wrap(plan)));
                break;
            }
        }
        return lsmTimelineInstant;
    }

    public static HoodieArchivedMetaEntry createMetaWrapperForEmptyInstant(HoodieInstant hoodieInstant) {
        HoodieArchivedMetaEntry archivedMetaWrapper = new HoodieArchivedMetaEntry();
        archivedMetaWrapper.setCommitTime(hoodieInstant.requestedTime());
        archivedMetaWrapper.setActionState(hoodieInstant.getState().name());
        archivedMetaWrapper.setStateTransitionTime(hoodieInstant.getCompletionTime());
        switch (hoodieInstant.getAction()) {
            case "clean": {
                archivedMetaWrapper.setActionType(ActionType.clean.name());
                break;
            }
            case "commit": {
                archivedMetaWrapper.setActionType(ActionType.commit.name());
                break;
            }
            case "deltacommit": {
                archivedMetaWrapper.setActionType(ActionType.deltacommit.name());
                break;
            }
            case "replacecommit": {
                archivedMetaWrapper.setActionType(ActionType.replacecommit.name());
                break;
            }
            case "clustering": {
                archivedMetaWrapper.setActionType(ActionType.clustering.name());
                break;
            }
            case "rollback": {
                archivedMetaWrapper.setActionType(ActionType.rollback.name());
                break;
            }
            case "savepoint": {
                archivedMetaWrapper.setActionType(ActionType.savepoint.name());
                break;
            }
            case "compaction": {
                archivedMetaWrapper.setActionType(ActionType.compaction.name());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Action not fully supported yet");
            }
        }
        return archivedMetaWrapper;
    }

    private static <T extends org.apache.hudi.common.model.HoodieCommitMetadata> Option<T> getCommitMetadata(HoodieTableMetaClient metaClient, HoodieInstant instant, Class<T> clazz) throws IOException {
        org.apache.hudi.common.model.HoodieCommitMetadata commitMetadata = (org.apache.hudi.common.model.HoodieCommitMetadata)metaClient.getActiveTimeline().readInstantContent(instant, clazz);
        if (commitMetadata.getOperationType() == WriteOperationType.UNKNOWN) {
            return Option.empty();
        }
        return Option.of((Object)commitMetadata);
    }

    public static Option<org.apache.hudi.common.model.HoodieCommitMetadata> getHoodieCommitMetadata(HoodieTableMetaClient metaClient, HoodieInstant hoodieInstant) throws IOException {
        HoodieTimeline timeline = metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        return Option.of((Object)TimelineUtils.getCommitMetadata(hoodieInstant, timeline));
    }

    public static <T extends SpecificRecordBase> T convertCommitMetadataToAvro(org.apache.hudi.common.model.HoodieCommitMetadata hoodieCommitMetadata) {
        MetadataConversionUtils.removeNullKeyFromMapMembersForCommitMetadata(hoodieCommitMetadata);
        if (hoodieCommitMetadata instanceof org.apache.hudi.common.model.HoodieReplaceCommitMetadata) {
            return (T)((SpecificRecordBase)JsonUtils.getObjectMapper().convertValue((Object)hoodieCommitMetadata, HoodieReplaceCommitMetadata.class));
        }
        HoodieCommitMetadata avroMetaData = (HoodieCommitMetadata)((Object)JsonUtils.getObjectMapper().convertValue((Object)hoodieCommitMetadata, HoodieCommitMetadata.class));
        return (T)((Object)avroMetaData);
    }

    public static <T> void removeNullKeyFromMapMembersForCommitMetadata(T metadata) {
        org.apache.hudi.common.model.HoodieCommitMetadata hoodieCommitMetadata;
        if (metadata instanceof org.apache.hudi.common.model.HoodieReplaceCommitMetadata) {
            org.apache.hudi.common.model.HoodieReplaceCommitMetadata hoodieCommitMetadata2 = (org.apache.hudi.common.model.HoodieReplaceCommitMetadata)metadata;
            if (hoodieCommitMetadata2.getPartitionToWriteStats().containsKey(null)) {
                LOG.info("partition path is null for {}", hoodieCommitMetadata2.getPartitionToWriteStats().get(null));
                hoodieCommitMetadata2.getPartitionToWriteStats().remove(null);
            }
            if (hoodieCommitMetadata2.getPartitionToReplaceFileIds().containsKey(null)) {
                LOG.info("partition path is null for {}", hoodieCommitMetadata2.getPartitionToReplaceFileIds().get(null));
                hoodieCommitMetadata2.getPartitionToReplaceFileIds().remove(null);
            }
        } else if (metadata instanceof org.apache.hudi.common.model.HoodieCommitMetadata && (hoodieCommitMetadata = (org.apache.hudi.common.model.HoodieCommitMetadata)metadata).getPartitionToWriteStats().containsKey(null)) {
            LOG.info("partition path is null for {}", hoodieCommitMetadata.getPartitionToWriteStats().get(null));
            hoodieCommitMetadata.getPartitionToWriteStats().remove(null);
        }
    }

    public static org.apache.hudi.common.model.HoodieReplaceCommitMetadata convertReplaceCommitMetadataToPojo(HoodieReplaceCommitMetadata replaceCommitMetadata) {
        replaceCommitMetadata.getPartitionToWriteStats().remove(null);
        replaceCommitMetadata.getPartitionToReplaceFileIds().remove(null);
        return (org.apache.hudi.common.model.HoodieReplaceCommitMetadata)JsonUtils.getObjectMapper().convertValue((Object)replaceCommitMetadata, org.apache.hudi.common.model.HoodieReplaceCommitMetadata.class);
    }
}

