/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.TimelineFactory;
import org.apache.hudi.common.table.timeline.dto.InstantDTO;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TimelineDTO {
    @JsonProperty(value="instants")
    List<InstantDTO> instants;

    public static TimelineDTO fromTimeline(HoodieTimeline timeline) {
        TimelineDTO dto = new TimelineDTO();
        dto.instants = timeline.getInstantsAsStream().map(InstantDTO::fromInstant).collect(Collectors.toList());
        return dto;
    }

    public static TimelineDTO fromInstants(List<HoodieInstant> instants) {
        TimelineDTO dto = new TimelineDTO();
        dto.instants = instants.stream().map(InstantDTO::fromInstant).collect(Collectors.toList());
        return dto;
    }

    public static HoodieTimeline toTimeline(TimelineDTO dto, HoodieTableMetaClient metaClient) {
        InstantGenerator instantGenerator = metaClient.getInstantGenerator();
        TimelineFactory factory = metaClient.getTableFormat().getTimelineFactory();
        return factory.createDefaultTimeline(dto.instants.stream().map(d -> InstantDTO.toInstant(d, instantGenerator)), metaClient.getActiveTimeline());
    }

    public static HoodieTimeline toTimeline(TimelineDTO dto, TimelineFactory factory, HoodieTimeline timeline, InstantGenerator instantGenerator) {
        return factory.createDefaultTimeline(dto.instants.stream().map(d -> InstantDTO.toInstant(d, instantGenerator)), timeline.getInstantReader());
    }
}

