/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.common;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import org.apache.hudi.common.table.timeline.HoodieInstant;

public class InstantComparators {

    public static class CompletionTimeBasedComparator
    implements Serializable,
    Comparator<HoodieInstant> {
        private final RequestedTimeBasedComparator timestampBasedComparator;

        public CompletionTimeBasedComparator(Map<String, String> comparableActions) {
            this.timestampBasedComparator = new RequestedTimeBasedComparator(comparableActions);
        }

        @Override
        public int compare(HoodieInstant instant1, HoodieInstant instant2) {
            if (instant1.getCompletionTime() == null && instant2.getCompletionTime() != null) {
                return 1;
            }
            if (instant2.getCompletionTime() == null && instant1.getCompletionTime() != null) {
                return -1;
            }
            if (instant1.getCompletionTime() == null && instant2.getCompletionTime() == null) {
                return this.timestampBasedComparator.compare(instant1, instant2);
            }
            int res = instant1.getCompletionTime().compareTo(instant2.getCompletionTime());
            if (res == 0) {
                res = this.timestampBasedComparator.compare(instant1, instant2);
            }
            return res;
        }
    }

    public static class RequestedTimeBasedComparator
    implements Serializable,
    Comparator<HoodieInstant> {
        private final ActionComparator actionComparator;

        public RequestedTimeBasedComparator(Map<String, String> comparableActions) {
            this.actionComparator = new ActionComparator(comparableActions);
        }

        @Override
        public int compare(HoodieInstant instant1, HoodieInstant instant2) {
            int res = instant1.requestedTime().compareTo(instant2.requestedTime());
            if (res == 0 && (res = this.actionComparator.compare(instant1, instant2)) == 0) {
                res = instant1.getState().compareTo(instant2.getState());
            }
            return res;
        }
    }

    public static class ActionComparator
    implements Serializable,
    Comparator<HoodieInstant> {
        private final Map<String, String> comparableActions;

        public ActionComparator(Map<String, String> comparableActions) {
            this.comparableActions = comparableActions;
        }

        @Override
        public int compare(HoodieInstant instant1, HoodieInstant instant2) {
            String action1 = this.getComparableAction(instant1.getAction());
            String action2 = this.getComparableAction(instant2.getAction());
            return action1.compareTo(action2);
        }

        private String getComparableAction(String action) {
            return this.comparableActions.getOrDefault(action, action);
        }
    }
}

