/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.ArchivedTimelineLoader;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantReader;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.table.timeline.versioning.v2.ArchivedTimelineLoaderV2;
import org.apache.hudi.common.table.timeline.versioning.v2.BaseTimelineV2;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchivedTimelineV2
extends BaseTimelineV2
implements HoodieArchivedTimeline,
HoodieInstantReader {
    public static final String INSTANT_TIME_ARCHIVED_META_FIELD = "instantTime";
    public static final String COMPLETION_TIME_ARCHIVED_META_FIELD = "completionTime";
    public static final String ACTION_ARCHIVED_META_FIELD = "action";
    public static final String METADATA_ARCHIVED_META_FIELD = "metadata";
    public static final String PLAN_ARCHIVED_META_FIELD = "plan";
    private HoodieTableMetaClient metaClient;
    private final Map<String, byte[]> readCommits = new ConcurrentHashMap<String, byte[]>();
    private static final Logger LOG = LoggerFactory.getLogger(HoodieArchivedTimeline.class);
    private String cursorInstant;
    private final ArchivedTimelineLoader timelineLoader = new ArchivedTimelineLoaderV2();

    public ArchivedTimelineV2(HoodieTableMetaClient metaClient) {
        this.metaClient = metaClient;
        this.setInstants(this.loadInstants());
        this.cursorInstant = (String)this.firstInstant().map(HoodieInstant::requestedTime).orElse(null);
        this.instantReader = this;
    }

    public ArchivedTimelineV2(HoodieTableMetaClient metaClient, String startTs) {
        this.metaClient = metaClient;
        this.setInstants(this.loadInstants(new HoodieArchivedTimeline.StartTsFilter(startTs), HoodieArchivedTimeline.LoadMode.METADATA));
        this.cursorInstant = startTs;
        this.instantReader = this;
    }

    public ArchivedTimelineV2() {
        this.instantReader = this;
    }

    @Override
    public HoodieInstantReader getInstantReader() {
        return this;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public void loadInstantDetailsInMemory(String startTs, String endTs) {
        this.loadInstants(startTs, endTs);
    }

    @Override
    public void loadCompletedInstantDetailsInMemory() {
        this.loadInstants(null, HoodieArchivedTimeline.LoadMode.METADATA);
    }

    @Override
    public void loadCompactionDetailsInMemory(String compactionInstantTime) {
        this.loadCompactionDetailsInMemory(compactionInstantTime, compactionInstantTime);
    }

    @Override
    public void loadCompactionDetailsInMemory(String startTs, String endTs) {
        this.loadInstants(new HoodieArchivedTimeline.TimeRangeFilter(startTs, endTs), HoodieArchivedTimeline.LoadMode.PLAN, record -> record.get(ACTION_ARCHIVED_META_FIELD).toString().equals("commit") && record.get(PLAN_ARCHIVED_META_FIELD) != null);
    }

    @Override
    public void clearInstantDetailsFromMemory(String instantTime) {
        this.readCommits.remove(instantTime);
    }

    @Override
    public void clearInstantDetailsFromMemory(String startTs, String endTs) {
        this.findInstantsInRange(startTs, endTs).getInstants().forEach(instant -> this.readCommits.remove(instant.requestedTime()));
    }

    @Override
    public Option<byte[]> getInstantDetails(HoodieInstant instant) {
        return Option.ofNullable((Object)this.readCommits.get(instant.requestedTime()));
    }

    @Override
    public InputStream getContentStream(HoodieInstant instant) {
        Option<InputStream> stream = TimelineUtils.getInputStreamOptionLegacy(this, instant);
        if (stream.isEmpty()) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return (InputStream)stream.get();
    }

    @Override
    public HoodieArchivedTimeline reload() {
        return new ArchivedTimelineV2(this.metaClient);
    }

    @Override
    public HoodieArchivedTimeline reload(String startTs) {
        if (this.cursorInstant != null) {
            if (InstantComparison.compareTimestamps(startTs, InstantComparison.LESSER_THAN, this.cursorInstant)) {
                this.appendInstants(this.loadInstants(new HoodieArchivedTimeline.ClosedOpenTimeRangeFilter(startTs, this.cursorInstant), HoodieArchivedTimeline.LoadMode.METADATA));
                this.cursorInstant = startTs;
            }
            return this;
        }
        return new ArchivedTimelineV2(this.metaClient, startTs);
    }

    private HoodieInstant readCommit(String instantTime, GenericRecord record, Option<BiConsumer<String, GenericRecord>> instantDetailsConsumer) {
        String action = record.get(ACTION_ARCHIVED_META_FIELD).toString();
        String completionTime = record.get(COMPLETION_TIME_ARCHIVED_META_FIELD).toString();
        instantDetailsConsumer.ifPresent(consumer -> consumer.accept(instantTime, record));
        return this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, action, instantTime, completionTime);
    }

    private BiConsumer<String, GenericRecord> getInstantDetailsFunc(HoodieArchivedTimeline.LoadMode loadMode) {
        switch (loadMode) {
            case METADATA: {
                return (instant, record) -> {
                    ByteBuffer commitMeta = (ByteBuffer)record.get(METADATA_ARCHIVED_META_FIELD);
                    if (commitMeta != null) {
                        this.readCommits.put((String)instant, commitMeta.array());
                    }
                };
            }
            case PLAN: {
                return (instant, record) -> {
                    ByteBuffer plan = (ByteBuffer)record.get(PLAN_ARCHIVED_META_FIELD);
                    if (plan != null) {
                        this.readCommits.put((String)instant, plan.array());
                    }
                };
            }
        }
        return null;
    }

    private List<HoodieInstant> loadInstants() {
        return this.loadInstants(null, HoodieArchivedTimeline.LoadMode.ACTION);
    }

    private List<HoodieInstant> loadInstants(String startTs, String endTs) {
        return this.loadInstants(new HoodieArchivedTimeline.TimeRangeFilter(startTs, endTs), HoodieArchivedTimeline.LoadMode.METADATA);
    }

    private List<HoodieInstant> loadInstants(HoodieArchivedTimeline.TimeRangeFilter filter, HoodieArchivedTimeline.LoadMode loadMode) {
        return this.loadInstants(filter, loadMode, r -> true);
    }

    private List<HoodieInstant> loadInstants(HoodieArchivedTimeline.TimeRangeFilter filter, HoodieArchivedTimeline.LoadMode loadMode, Function<GenericRecord, Boolean> commitsFilter) {
        ConcurrentHashMap instantsInRange = new ConcurrentHashMap();
        Option instantDetailsConsumer = Option.ofNullable(this.getInstantDetailsFunc(loadMode));
        this.timelineLoader.loadInstants(this.metaClient, filter, loadMode, commitsFilter, (instantTime, avroRecord) -> instantsInRange.putIfAbsent(instantTime, this.readCommit((String)instantTime, (GenericRecord)avroRecord, (Option<BiConsumer<String, GenericRecord>>)instantDetailsConsumer)));
        ArrayList<HoodieInstant> result = new ArrayList<HoodieInstant>(instantsInRange.values());
        Collections.sort(result);
        return result;
    }

    @Override
    public HoodieTimeline getWriteTimeline() {
        Set<String> validActions = CollectionUtils.createSet("commit", "deltacommit", "compaction", "logcompaction", "replacecommit", "clustering");
        return new BaseTimelineV2(this.getInstantsAsStream().filter((? super T i) -> this.readCommits.containsKey(i.requestedTime())).filter((? super T s) -> validActions.contains(s.getAction())), this.instantReader);
    }

    @Override
    public boolean isEmpty(HoodieInstant instant) {
        return this.getInstantDetails(instant).isEmpty();
    }
}

