/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v2;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.table.timeline.CompletionTimeQueryView;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.VisibleForTesting;

public class CompletionTimeQueryViewV2
implements CompletionTimeQueryView,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final long MILLI_SECONDS_IN_ONE_DAY = 86400000L;
    private static final Function<String, String> GET_INSTANT_ONE_DAY_BEFORE = instant -> HoodieInstantTimeGenerator.instantTimeMinusMillis(instant, 86400000L);
    private final HoodieTableMetaClient metaClient;
    private final ConcurrentMap<String, String> instantTimeToCompletionTimeMap;
    private volatile String cursorInstant;
    private final String firstNonSavepointCommit;

    public CompletionTimeQueryViewV2(HoodieTableMetaClient metaClient) {
        this.metaClient = metaClient;
        this.instantTimeToCompletionTimeMap = new ConcurrentHashMap<String, String>();
        this.cursorInstant = (String)metaClient.getActiveTimeline().firstInstant().map(HoodieInstant::requestedTime).orElse((Object)"");
        this.firstNonSavepointCommit = (String)metaClient.getActiveTimeline().getWriteTimeline().getFirstNonSavepointCommit().map(HoodieInstant::requestedTime).orElse((Object)"");
        this.load();
    }

    @Override
    public boolean isCompleted(String instantTime) {
        return this.instantTimeToCompletionTimeMap.containsKey(instantTime) || this.isArchived(instantTime);
    }

    @Override
    public boolean isArchived(String instantTime) {
        return InstantComparison.compareTimestamps(instantTime, InstantComparison.LESSER_THAN, this.firstNonSavepointCommit);
    }

    @Override
    public boolean isCompletedBefore(String baseInstant, String instantTime) {
        Option<String> completionTimeOpt = this.getCompletionTime(baseInstant, instantTime);
        if (completionTimeOpt.isPresent()) {
            return InstantComparison.compareTimestamps((String)completionTimeOpt.get(), InstantComparison.LESSER_THAN, baseInstant);
        }
        return false;
    }

    @Override
    public boolean isSlicedAfterOrOn(String baseInstant, String instantTime) {
        Option<String> completionTimeOpt = this.getCompletionTime(baseInstant, instantTime);
        if (completionTimeOpt.isPresent()) {
            return InstantComparison.compareTimestamps((String)completionTimeOpt.get(), InstantComparison.GREATER_THAN_OR_EQUALS, baseInstant);
        }
        return true;
    }

    @Override
    public Option<String> getCompletionTime(String baseInstant, String instantTime) {
        String completionTime;
        Option<String> completionTimeOpt = this.getCompletionTime(instantTime);
        if (completionTimeOpt.isPresent() && (completionTime = (String)completionTimeOpt.get()).length() != baseInstant.length()) {
            return Option.of((Object)instantTime);
        }
        return completionTimeOpt;
    }

    @Override
    public Option<String> getCompletionTime(String instantTime) {
        String completionTime = (String)this.instantTimeToCompletionTimeMap.get(instantTime);
        if (completionTime != null) {
            return Option.of((Object)completionTime);
        }
        if (InstantComparison.compareTimestamps(instantTime, InstantComparison.GREATER_THAN_OR_EQUALS, this.cursorInstant)) {
            return Option.empty();
        }
        this.loadCompletionTimeIncrementally(instantTime);
        return Option.ofNullable(this.instantTimeToCompletionTimeMap.get(instantTime));
    }

    @Override
    public List<String> getInstantTimes(HoodieTimeline timeline, Option<String> startCompletionTime, Option<String> endCompletionTime, InstantRange.RangeType rangeType) {
        return this.getInstantTimes(timeline, startCompletionTime, endCompletionTime, rangeType, GET_INSTANT_ONE_DAY_BEFORE);
    }

    @Override
    @VisibleForTesting
    public List<String> getInstantTimes(String startCompletionTime, String endCompletionTime, Function<String, String> earliestInstantTimeFunc) {
        return this.getInstantTimes(this.metaClient.getCommitsTimeline().filterCompletedInstants(), (Option<String>)Option.ofNullable((Object)startCompletionTime), (Option<String>)Option.ofNullable((Object)endCompletionTime), InstantRange.RangeType.CLOSED_CLOSED, earliestInstantTimeFunc);
    }

    private List<String> getInstantTimes(HoodieTimeline timeline, Option<String> startCompletionTime, Option<String> endCompletionTime, InstantRange.RangeType rangeType, Function<String, String> earliestInstantTimeFunc) {
        boolean startFromEarliest = "earliest".equalsIgnoreCase((String)startCompletionTime.orElse(null));
        String earliestInstantToLoad = null;
        if (startCompletionTime.isPresent() && !startFromEarliest) {
            earliestInstantToLoad = earliestInstantTimeFunc.apply((String)startCompletionTime.get());
        } else if (endCompletionTime.isPresent()) {
            earliestInstantToLoad = earliestInstantTimeFunc.apply((String)endCompletionTime.get());
        }
        if (earliestInstantToLoad != null && InstantComparison.compareTimestamps(this.cursorInstant, InstantComparison.GREATER_THAN, earliestInstantToLoad)) {
            this.loadCompletionTimeIncrementally(earliestInstantToLoad);
        }
        if (startCompletionTime.isEmpty() && endCompletionTime.isPresent()) {
            String maxInstantTime = timeline.getInstantsAsStream().filter(instant -> instant.isCompleted() && InstantComparison.compareTimestamps(instant.getCompletionTime(), InstantComparison.LESSER_THAN_OR_EQUALS, (String)endCompletionTime.get())).max(Comparator.comparing(HoodieInstant::getCompletionTime)).map(HoodieInstant::requestedTime).orElse(null);
            if (maxInstantTime != null) {
                return Collections.singletonList(maxInstantTime);
            }
            return this.instantTimeToCompletionTimeMap.entrySet().stream().filter(entry -> InstantComparison.compareTimestamps((String)entry.getValue(), InstantComparison.LESSER_THAN_OR_EQUALS, (String)endCompletionTime.get())).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
        }
        if (startFromEarliest) {
            startCompletionTime = Option.empty();
        }
        if (startCompletionTime.isEmpty() && endCompletionTime.isEmpty()) {
            return (List)timeline.filterCompletedInstants().lastInstant().map(instant -> Collections.singletonList(instant.requestedTime())).orElse(Collections.emptyList());
        }
        InstantRange instantRange = InstantRange.builder().rangeType(rangeType).startInstant((String)startCompletionTime.orElse(null)).endInstant((String)endCompletionTime.orElse(null)).nullableBoundary(true).build();
        return this.instantTimeToCompletionTimeMap.entrySet().stream().filter(entry -> instantRange.isInRange((String)entry.getValue())).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCompletionTimeIncrementally(String startTime) {
        CompletionTimeQueryViewV2 completionTimeQueryViewV2 = this;
        synchronized (completionTimeQueryViewV2) {
            if (InstantComparison.compareTimestamps(startTime, InstantComparison.LESSER_THAN, this.cursorInstant)) {
                this.metaClient.getTableFormat().getTimelineFactory().createArchivedTimelineLoader().loadInstants(this.metaClient, new HoodieArchivedTimeline.ClosedOpenTimeRangeFilter(startTime, this.cursorInstant), HoodieArchivedTimeline.LoadMode.TIME, r -> true, this::readCompletionTime);
            }
            this.cursorInstant = startTime;
        }
    }

    private void load() {
        this.metaClient.getActiveTimeline().filterCompletedInstants().getInstantsAsStream().forEach(instant -> this.setCompletionTime(instant.requestedTime(), instant.getCompletionTime()));
    }

    private void readCompletionTime(String instantTime, GenericRecord record) {
        String completionTime = record.get("completionTime").toString();
        this.setCompletionTime(instantTime, completionTime);
    }

    private void setCompletionTime(String beginInstantTime, String completionTime) {
        if (completionTime == null) {
            completionTime = beginInstantTime;
        }
        this.instantTimeToCompletionTimeMap.putIfAbsent(beginInstantTime, completionTime);
    }

    @Override
    public String getCursorInstant() {
        return this.cursorInstant;
    }

    @Override
    public boolean isEmptyTable() {
        return this.instantTimeToCompletionTimeMap.isEmpty();
    }

    @Override
    public void close() {
        this.instantTimeToCompletionTimeMap.clear();
    }
}

