/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.util.ObjectSizeCalculator;
import org.apache.hudi.common.util.SizeEstimator;

class HoodieFileGroupSizeEstimator
implements SizeEstimator<List<HoodieFileGroup>>,
Serializable {
    HoodieFileGroupSizeEstimator() {
    }

    @Override
    public long sizeEstimate(List<HoodieFileGroup> hoodieFileGroups) {
        long sizeOfFileSlices;
        if (hoodieFileGroups.isEmpty()) {
            return 0L;
        }
        long sizeOfFileGroupIds = ObjectSizeCalculator.getObjectSize(hoodieFileGroups.get(0).getFileGroupId()) * (long)hoodieFileGroups.size();
        long totalFileSlices = hoodieFileGroups.stream().flatMap(HoodieFileGroup::getAllFileSlices).count();
        if (totalFileSlices > 10L) {
            double samplingFactor = (double)totalFileSlices / 10.0;
            sizeOfFileSlices = Math.round((double)ObjectSizeCalculator.getObjectSize(hoodieFileGroups.stream().flatMap(HoodieFileGroup::getAllFileSlices).limit(10L).collect(Collectors.toList())) * samplingFactor);
        } else {
            sizeOfFileSlices = ObjectSizeCalculator.getObjectSize(hoodieFileGroups.stream().flatMap(HoodieFileGroup::getAllFileSlices).collect(Collectors.toList()));
        }
        return sizeOfFileSlices + sizeOfFileGroupIds;
    }
}

