/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.PropertiesConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    public static final String STREAMER_CONFIG_PREFIX = "hoodie.streamer.";
    @Deprecated
    public static final String DELTA_STREAMER_CONFIG_PREFIX = "hoodie.deltastreamer.";
    public static final String SCHEMAPROVIDER_CONFIG_PREFIX = "hoodie.streamer.schemaprovider.";
    @Deprecated
    public static final String OLD_SCHEMAPROVIDER_CONFIG_PREFIX = "hoodie.deltastreamer.schemaprovider.";
    public static final String IS_QUERY_AS_RO_TABLE = "hoodie.query.as.ro.table";
    public static final String TABLE_SERDE_PATH = "path";
    public static final HoodieConfig DEFAULT_HUDI_CONFIG_FOR_READER = new HoodieConfig();
    private static final Logger LOG = LoggerFactory.getLogger(ConfigUtils.class);

    @Nullable
    public static String[] getOrderingFields(Properties properties) {
        String orderField = ConfigUtils.getOrderingFieldsStr(properties);
        return StringUtils.isNullOrEmpty((String)orderField) ? null : orderField.split(",");
    }

    @Nullable
    public static String getOrderingFieldsStr(Properties properties) {
        String orderField = ConfigUtils.getOrderingFieldsStrDuringWrite(properties);
        if (orderField == null && properties.containsKey("hoodie.payload.ordering.field")) {
            orderField = properties.getProperty("hoodie.payload.ordering.field");
        }
        return orderField;
    }

    @Nullable
    public static String getOrderingFieldsStrDuringWrite(Properties properties) {
        String orderField = null;
        if (ConfigUtils.containsConfigProperty(properties, HoodieTableConfig.ORDERING_FIELDS)) {
            orderField = ConfigUtils.getStringWithAltKeys(properties, HoodieTableConfig.ORDERING_FIELDS);
        } else if (properties.containsKey("hoodie.datasource.write.precombine.field")) {
            orderField = properties.getProperty("hoodie.datasource.write.precombine.field");
        }
        return orderField;
    }

    @Nullable
    public static String getOrderingFieldsStrDuringWrite(Map<String, String> properties) {
        String orderField = null;
        if (ConfigUtils.containsConfigProperty(properties, HoodieTableConfig.ORDERING_FIELDS)) {
            orderField = ConfigUtils.getStringWithAltKeys(properties, HoodieTableConfig.ORDERING_FIELDS);
        } else if (properties.containsKey("hoodie.datasource.write.precombine.field")) {
            orderField = properties.get("hoodie.datasource.write.precombine.field");
        }
        return orderField;
    }

    public static TypedProperties supplementOrderingFields(TypedProperties props, List<String> orderingFields) {
        String orderingFieldsAsString = String.join((CharSequence)",", orderingFields);
        props.putIfAbsent("hoodie.payload.ordering.field", orderingFieldsAsString);
        props.putIfAbsent(HoodieTableConfig.ORDERING_FIELDS.key(), orderingFieldsAsString);
        return props;
    }

    public static TypedProperties getMergeProps(TypedProperties props, HoodieTableConfig tableConfig) {
        Map<String, String> mergeProps = tableConfig.getTableMergeProperties();
        if (mergeProps.isEmpty()) {
            return props;
        }
        TypedProperties copied = TypedProperties.copy(props);
        mergeProps.forEach(copied::setProperty);
        return copied;
    }

    public static String getPayloadClass(Properties props) {
        return HoodieRecordPayload.getPayloadClassName(props);
    }

    public static boolean isTrackingEventTimeWatermark(TypedProperties props) {
        return props.getBoolean("hoodie.write.track.event.time.watermark", false);
    }

    public static boolean shouldKeepConsistentLogicalTimestamp(TypedProperties props) {
        return Boolean.parseBoolean(props.getProperty(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.defaultValue()));
    }

    @Nullable
    public static String getEventTimeFieldName(TypedProperties props) {
        return props.getProperty("hoodie.payload.event.time.field");
    }

    public static List<String> split2List(String param) {
        return StringUtils.split((String)param, (String)",").stream().map(String::trim).distinct().collect(Collectors.toList());
    }

    public static Map<String, String> toMap(String keyValueConfig) {
        return ConfigUtils.toMap(keyValueConfig, "\n");
    }

    public static Map<String, String> toMap(String keyValueConfig, String separator) {
        if (StringUtils.isNullOrEmpty((String)keyValueConfig)) {
            return new HashMap<String, String>();
        }
        String[] keyvalues = keyValueConfig.split(separator);
        HashMap<String, String> tableProperties = new HashMap<String, String>();
        for (String keyValue : keyvalues) {
            if (keyValue.trim().isEmpty()) continue;
            String[] keyValueArray = keyValue.split("=");
            if (keyValueArray.length == 1 || keyValueArray.length == 2) {
                String key = keyValueArray[0].trim();
                String value = keyValueArray.length == 2 ? keyValueArray[1].trim() : "";
                tableProperties.put(key, value);
                continue;
            }
            throw new IllegalArgumentException("Bad key-value config: " + keyValue + ", must be the format 'key = value'");
        }
        return tableProperties;
    }

    public static String configToString(Map<String, String> config) {
        if (config == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : config.entrySet()) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb.toString();
    }

    public static <T extends Enum<T>> T resolveEnum(Class<T> enumType, String name) {
        Enum[] enumConstants;
        for (Enum constant : enumConstants = (Enum[])enumType.getEnumConstants()) {
            if (!constant.name().equalsIgnoreCase(name)) continue;
            return (T)constant;
        }
        throw new IllegalArgumentException("No enum constant found " + enumType.getName() + "." + name);
    }

    public static <T extends Enum<T>> String[] enumNames(Class<T> enumType) {
        Enum[] enumConstants = (Enum[])enumType.getEnumConstants();
        return (String[])Arrays.stream(enumConstants).map(Enum::name).toArray(String[]::new);
    }

    public static Option<String> stripPrefix(String prop, ConfigProperty<String> prefixConfig) {
        if (prop.startsWith(prefixConfig.key())) {
            return Option.of((Object)String.join((CharSequence)"", prop.split(prefixConfig.key())));
        }
        for (String altPrefix : prefixConfig.getAlternatives()) {
            if (!prop.startsWith(altPrefix)) continue;
            return Option.of((Object)String.join((CharSequence)"", prop.split(altPrefix)));
        }
        return Option.empty();
    }

    public static boolean containsConfigProperty(Properties props, ConfigProperty<?> configProperty) {
        if (!props.containsKey(configProperty.key())) {
            for (String alternative : configProperty.getAlternatives()) {
                if (!props.containsKey(alternative)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean containsConfigProperty(Map<String, ?> props, ConfigProperty<?> configProperty) {
        return ConfigUtils.containsConfigProperty(props::containsKey, configProperty);
    }

    public static boolean containsConfigProperty(Function<String, Boolean> keyExistsFn, ConfigProperty<?> configProperty) {
        if (!keyExistsFn.apply(configProperty.key()).booleanValue()) {
            for (String alternative : configProperty.getAlternatives()) {
                if (!keyExistsFn.apply(alternative).booleanValue()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static void checkRequiredProperties(TypedProperties props, List<String> checkPropNames) {
        checkPropNames.forEach(prop -> {
            if (!props.containsKey(prop)) {
                throw new HoodieNotSupportedException("Required property " + prop + " is missing");
            }
        });
    }

    public static void checkRequiredConfigProperties(TypedProperties props, List<ConfigProperty<?>> configPropertyList) {
        configPropertyList.forEach(configProperty -> {
            if (!ConfigUtils.containsConfigProperty(props, configProperty)) {
                throw new HoodieNotSupportedException("Required property " + configProperty.key() + " is missing");
            }
        });
    }

    public static Option<Object> getRawValueWithAltKeys(Properties props, ConfigProperty<?> configProperty) {
        if (props.containsKey(configProperty.key())) {
            return Option.ofNullable((Object)props.get(configProperty.key()));
        }
        for (String alternative : configProperty.getAlternatives()) {
            if (!props.containsKey(alternative)) continue;
            ConfigUtils.deprecationWarning(alternative, configProperty);
            return Option.ofNullable((Object)props.get(alternative));
        }
        return Option.empty();
    }

    public static <T> T getRawValueWithAltKeys(Properties props, ConfigProperty<T> configProperty, boolean useDefaultValue) {
        Option<Object> rawValue = ConfigUtils.getRawValueWithAltKeys(props, configProperty);
        if (rawValue.isPresent()) {
            return (T)rawValue.get();
        }
        if (useDefaultValue) {
            return configProperty.defaultValue();
        }
        throw new IllegalArgumentException("Property " + configProperty.key() + " not found");
    }

    public static String getStringWithAltKeys(Properties props, ConfigProperty<String> configProperty) {
        return ConfigUtils.getStringWithAltKeys(props, configProperty, false);
    }

    public static String getStringWithAltKeys(Properties props, ConfigProperty<String> configProperty, boolean useDefaultValue) {
        if (useDefaultValue) {
            return ConfigUtils.getStringWithAltKeys(props, configProperty, configProperty.hasDefaultValue() ? configProperty.defaultValue() : null);
        }
        Option<Object> rawValue = ConfigUtils.getRawValueWithAltKeys(props, configProperty);
        if (!rawValue.isPresent()) {
            throw new IllegalArgumentException("Property " + configProperty.key() + " not found");
        }
        return rawValue.get().toString();
    }

    public static String getStringWithAltKeys(Properties props, ConfigProperty<?> configProperty, String defaultValue) {
        Option<Object> rawValue = ConfigUtils.getRawValueWithAltKeys(props, configProperty);
        return (String)rawValue.map(Object::toString).orElse((Object)defaultValue);
    }

    public static <V> String getStringWithAltKeys(Map<String, V> props, ConfigProperty<?> configProperty) {
        return ConfigUtils.getStringWithAltKeys(props::get, configProperty);
    }

    public static String getStringWithAltKeys(Function<String, Object> keyMapper, ConfigProperty<?> configProperty) {
        Object value = keyMapper.apply(configProperty.key());
        if (value != null) {
            return value.toString();
        }
        for (String alternative : configProperty.getAlternatives()) {
            value = keyMapper.apply(alternative);
            if (value == null) continue;
            ConfigUtils.deprecationWarning(alternative, configProperty);
            return value.toString();
        }
        return configProperty.hasDefaultValue() ? configProperty.defaultValue().toString() : null;
    }

    private static void deprecationWarning(String alternative, ConfigProperty<?> configProperty) {
        LOG.warn("The configuration key '{}' has been deprecated and may be removed in the future. Please use the new key '{}' instead.", (Object)alternative, (Object)configProperty.key());
    }

    public static String getStringWithAltKeys(TypedProperties props, String key, String altKey, String defaultValue) {
        if (props.containsKey(altKey)) {
            return props.getString(altKey);
        }
        if (props.containsKey(key)) {
            return props.getString(key);
        }
        return defaultValue;
    }

    public static boolean getBooleanWithAltKeys(Properties props, ConfigProperty<?> configProperty) {
        Option<Object> rawValue = ConfigUtils.getRawValueWithAltKeys(props, configProperty);
        boolean defaultValue = configProperty.hasDefaultValue() && Boolean.parseBoolean(configProperty.defaultValue().toString());
        return (Boolean)rawValue.map(v -> Boolean.parseBoolean(v.toString())).orElse((Object)defaultValue);
    }

    public static int getIntWithAltKeys(Properties props, ConfigProperty<?> configProperty) {
        Option<Object> rawValue = ConfigUtils.getRawValueWithAltKeys(props, configProperty);
        int defaultValue = configProperty.hasDefaultValue() ? Integer.parseInt(configProperty.defaultValue().toString()) : 0;
        return (Integer)rawValue.map(v -> Integer.parseInt(v.toString())).orElse((Object)defaultValue);
    }

    public static long getLongWithAltKeys(TypedProperties props, ConfigProperty<Long> configProperty) {
        Option<Object> rawValue = ConfigUtils.getRawValueWithAltKeys(props, configProperty);
        long defaultValue = configProperty.hasDefaultValue() ? configProperty.defaultValue() : 0L;
        return (Long)rawValue.map(v -> Long.parseLong(v.toString())).orElse((Object)defaultValue);
    }

    public static void removeConfigFromProps(TypedProperties props, ConfigProperty<?> configProperty) {
        props.remove(configProperty.key());
        for (String alternative : configProperty.getAlternatives()) {
            props.remove(alternative);
        }
    }

    public static Map<String, Object> filterProperties(TypedProperties props, List<ConfigProperty<String>> configPropertyList) {
        Set<String> persistedKeys = ConfigUtils.getAllConfigKeys(configPropertyList);
        return props.entrySet().stream().filter(p -> persistedKeys.contains(String.valueOf(p.getKey()))).collect(Collectors.toMap((? super T e) -> String.valueOf(e.getKey()), (? super T e) -> String.valueOf(e.getValue())));
    }

    public static Set<String> getAllConfigKeys(List<ConfigProperty<String>> configPropertyList) {
        return configPropertyList.stream().flatMap(configProperty -> {
            ArrayList<String> keys = new ArrayList<String>();
            keys.add(configProperty.key());
            keys.addAll(configProperty.getAlternatives());
            return keys.stream();
        }).collect(Collectors.toSet());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TypedProperties fetchConfigs(HoodieStorage storage, StoragePath metaPath, String propertiesFile, String propertiesBackupFile, int maxReadRetries, int maxReadRetryDelayInMs) throws IOException {
        StoragePath cfgPath = new StoragePath(metaPath, propertiesFile);
        StoragePath backupCfgPath = new StoragePath(metaPath, propertiesBackupFile);
        int readRetryCount = 0;
        boolean found = false;
        TypedProperties props = new TypedProperties();
        while (true) {
            Iterator<StoragePath> iterator;
            if (readRetryCount++ < maxReadRetries) {
                iterator = Arrays.asList(cfgPath, backupCfgPath).iterator();
            } else {
                if (found) {
                    throw new IllegalArgumentException("hoodie.properties file seems invalid. Please check for left over `.updated` files if any, manually copy it to hoodie.properties and retry");
                }
                if (storage.exists(metaPath)) throw new HoodieIOException("Could not load Hoodie properties from " + cfgPath);
                throw new TableNotFoundException(metaPath.toString());
            }
            while (iterator.hasNext()) {
                StoragePath path = iterator.next();
                try (InputStream is = storage.open(path);){
                    props.clear();
                    props.load(is);
                    found = true;
                    if (props.containsKey(HoodieTableConfig.TABLE_CHECKSUM.key())) {
                        ValidationUtils.checkArgument((boolean)HoodieTableConfig.validateChecksum(props));
                    }
                    TypedProperties typedProperties = props;
                    return typedProperties;
                }
                catch (IOException e) {
                    LOG.warn("Could not read properties from {}: {}", (Object)path, (Object)e);
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Invalid properties file {}: {}", (Object)path, (Object)props);
                }
            }
            try {
                Thread.sleep(maxReadRetryDelayInMs);
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting");
                continue;
            }
            break;
        }
    }

    public static boolean isPropertiesInvalid(TypedProperties props) {
        if (!props.containsKey(HoodieTableConfig.TABLE_CHECKSUM.key())) {
            return !props.containsKey(HoodieTableConfig.NAME.key());
        }
        return !HoodieTableConfig.validateChecksum(props);
    }

    public static void recoverIfNeeded(HoodieStorage storage, StoragePath cfgPath, StoragePath backupCfgPath) throws IOException {
        Throwable throwable;
        boolean needCopy = false;
        if (!storage.exists(cfgPath)) {
            needCopy = true;
        } else {
            TypedProperties props = new TypedProperties();
            throwable = null;
            try (InputStream in = storage.open(cfgPath);){
                props.load(in);
                if (ConfigUtils.isPropertiesInvalid(props)) {
                    storage.deleteFile(cfgPath);
                    needCopy = true;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        if (needCopy && storage.exists(backupCfgPath)) {
            byte[] bytes = FileIOUtils.readAsByteArray((InputStream)storage.open(backupCfgPath));
            throwable = null;
            try (ByteArrayInputStream backupStream = new ByteArrayInputStream(bytes);){
                TypedProperties backupProps = new TypedProperties();
                backupProps.load(backupStream);
                if (ConfigUtils.isPropertiesInvalid(backupProps)) {
                    storage.deleteFile(backupCfgPath);
                    LOG.error("Invalid properties file {}: {}", (Object)backupCfgPath, (Object)backupProps);
                    throw new IOException("Corrupted backup file");
                }
                try (OutputStream out = storage.create(cfgPath, false);){
                    out.write(bytes);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        storage.deleteFile(backupCfgPath);
    }

    public static void upsertProperties(Properties current, Properties updated) {
        updated.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> current.setProperty(k.toString(), v.toString())));
    }

    public static void deleteProperties(Properties current, Properties deleted) {
        deleted.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> current.remove(k.toString())));
    }

    public static HoodieConfig getReaderConfigs(StorageConfiguration<?> storageConf) {
        HoodieConfig config = new HoodieConfig();
        config.setAll(DEFAULT_HUDI_CONFIG_FOR_READER.getProps());
        return config;
    }

    public static HoodieReaderConfig getHFileCacheConfigs(Map<String, String> options) {
        HoodieReaderConfig config = new HoodieReaderConfig();
        config.setValue(HoodieReaderConfig.HFILE_BLOCK_CACHE_ENABLED, ConfigUtils.getStringWithAltKeys(options, HoodieReaderConfig.HFILE_BLOCK_CACHE_ENABLED));
        config.setValue(HoodieReaderConfig.HFILE_BLOCK_CACHE_SIZE, ConfigUtils.getStringWithAltKeys(options, HoodieReaderConfig.HFILE_BLOCK_CACHE_SIZE));
        config.setValue(HoodieReaderConfig.HFILE_BLOCK_CACHE_TTL_MINUTES, ConfigUtils.getStringWithAltKeys(options, HoodieReaderConfig.HFILE_BLOCK_CACHE_TTL_MINUTES));
        return config;
    }

    public static TypedProperties loadGlobalProperties() {
        return ((PropertiesConfig)ReflectionUtils.loadClass((String)"org.apache.hudi.common.config.DFSPropertiesConfiguration")).getGlobalProperties();
    }

    public static Map<String, String> extractWithPrefix(TypedProperties props, String prefix) {
        if (props == null || props.isEmpty()) {
            return Collections.emptyMap();
        }
        int prefixLength = prefix.length();
        HashMap<String, String> mergeProperties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String propKey;
            String key = entry.getKey().toString();
            if (key.length() <= prefixLength || !key.startsWith(prefix) || (propKey = key.substring(prefixLength).trim()).isEmpty()) continue;
            Object value = entry.getValue();
            String stringValue = value != null ? value.toString().trim() : "";
            mergeProperties.put(propKey, stringValue);
        }
        return mergeProperties;
    }

    public static TypedProperties buildFileGroupReaderProperties(HoodieMetadataConfig metadataConfig, boolean shouldReuse) {
        HoodieCommonConfig commonConfig = HoodieCommonConfig.newBuilder().fromProperties(metadataConfig.getProps()).build();
        TypedProperties props = new TypedProperties();
        props.setProperty(HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE.key(), Long.toString(metadataConfig.getMaxReaderMemory()));
        props.setProperty(HoodieMemoryConfig.SPILLABLE_MAP_BASE_PATH.key(), metadataConfig.getSplliableMapDir());
        props.setProperty(HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.key(), commonConfig.getSpillableDiskMapType().name());
        props.setProperty(HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.key(), Boolean.toString(commonConfig.isBitCaskDiskMapCompressionEnabled()));
        props.setProperty(HoodieReaderConfig.HFILE_BLOCK_CACHE_ENABLED.key(), shouldReuse ? "true" : metadataConfig.getStringOrDefault(HoodieReaderConfig.HFILE_BLOCK_CACHE_ENABLED));
        props.setProperty(HoodieReaderConfig.HFILE_BLOCK_CACHE_ENABLED.key(), metadataConfig.getStringOrDefault(HoodieReaderConfig.HFILE_BLOCK_CACHE_ENABLED));
        props.setProperty(HoodieReaderConfig.HFILE_BLOCK_CACHE_SIZE.key(), metadataConfig.getStringOrDefault(HoodieReaderConfig.HFILE_BLOCK_CACHE_SIZE));
        props.setProperty(HoodieReaderConfig.HFILE_BLOCK_CACHE_TTL_MINUTES.key(), metadataConfig.getStringOrDefault(HoodieReaderConfig.HFILE_BLOCK_CACHE_TTL_MINUTES));
        return props;
    }
}

