/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.FileFormatUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.compress.CompressionCodec;
import org.apache.hudi.io.hfile.HFileContext;
import org.apache.hudi.io.hfile.HFileWriterImpl;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.metadata.HoodieIndexVersion;
import org.apache.hudi.stats.HoodieColumnRangeMetadata;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HFileUtils
extends FileFormatUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HFileUtils.class);
    private static final int DEFAULT_BLOCK_SIZE_FOR_LOG_FILE = 0x100000;

    public static CompressionCodec getHFileCompressionAlgorithm(Map<String, String> paramsMap) {
        String codecName = paramsMap.get(HoodieStorageConfig.HFILE_COMPRESSION_ALGORITHM_NAME.key());
        if (StringUtils.isNullOrEmpty((String)codecName)) {
            return CompressionCodec.GZIP;
        }
        return CompressionCodec.findCodecByName((String)codecName);
    }

    @Override
    public List<GenericRecord> readAvroRecords(HoodieStorage storage, StoragePath filePath) {
        throw new UnsupportedOperationException("HFileUtils does not support readAvroRecords");
    }

    @Override
    public List<GenericRecord> readAvroRecords(HoodieStorage storage, StoragePath filePath, Schema schema) {
        throw new UnsupportedOperationException("HFileUtils does not support readAvroRecords");
    }

    @Override
    public Map<String, String> readFooter(HoodieStorage storage, boolean required, StoragePath filePath, String ... footerNames) {
        throw new UnsupportedOperationException("HFileUtils does not support readFooter");
    }

    @Override
    public long getRowCount(HoodieStorage storage, StoragePath filePath) {
        throw new UnsupportedOperationException("HFileUtils does not support getRowCount");
    }

    @Override
    public Set<Pair<String, Long>> filterRowKeys(HoodieStorage storage, StoragePath filePath, Set<String> filter) {
        throw new UnsupportedOperationException("HFileUtils does not support filterRowKeys");
    }

    @Override
    public ClosableIterator<Pair<HoodieKey, Long>> fetchRecordKeysWithPositions(HoodieStorage storage, StoragePath filePath) {
        throw new UnsupportedOperationException("HFileUtils does not support fetchRecordKeysWithPositions");
    }

    @Override
    public ClosableIterator<HoodieKey> getHoodieKeyIterator(HoodieStorage storage, StoragePath filePath, Option<BaseKeyGenerator> keyGeneratorOpt, final Option<String> partitionPath) {
        try {
            HoodieFileReader reader = HoodieIOFactory.getIOFactory(storage).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(new HoodieReaderConfig(), filePath, HoodieFileFormat.HFILE);
            final ClosableIterator<String> keyIterator = reader.getRecordKeyIterator();
            return new ClosableIterator<HoodieKey>(){

                @Override
                public void close() {
                    keyIterator.close();
                }

                @Override
                public boolean hasNext() {
                    return keyIterator.hasNext();
                }

                @Override
                public HoodieKey next() {
                    String key = (String)keyIterator.next();
                    return new HoodieKey(key, (String)partitionPath.orElse(null));
                }
            };
        }
        catch (IOException e) {
            throw new HoodieIOException("Unable to read the HFile: ", e);
        }
    }

    @Override
    public ClosableIterator<HoodieKey> getHoodieKeyIterator(HoodieStorage storage, StoragePath filePath) {
        throw new UnsupportedOperationException("HFileUtils does not support getHoodieKeyIterator");
    }

    @Override
    public ClosableIterator<Pair<HoodieKey, Long>> fetchRecordKeysWithPositions(HoodieStorage storage, StoragePath filePath, Option<BaseKeyGenerator> keyGeneratorOpt, Option<String> partitionPath) {
        throw new UnsupportedOperationException("HFileUtils does not support fetchRecordKeysWithPositions");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Schema readAvroSchema(HoodieStorage storage, StoragePath filePath) {
        LOG.info("Reading schema from {}", (Object)filePath);
        try (HoodieFileReader fileReader = HoodieIOFactory.getIOFactory(storage).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(ConfigUtils.DEFAULT_HUDI_CONFIG_FOR_READER, filePath);){
            Schema schema = fileReader.getSchema();
            return schema;
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read schema from HFile", e);
        }
    }

    @Override
    public List<HoodieColumnRangeMetadata<Comparable>> readColumnStatsFromMetadata(HoodieStorage storage, StoragePath filePath, List<String> columnList, HoodieIndexVersion indexVersion) {
        throw new UnsupportedOperationException("Reading column statistics from metadata is not supported for HFile format yet");
    }

    @Override
    public HoodieFileFormat getFormat() {
        return HoodieFileFormat.HFILE;
    }

    @Override
    public void writeMetaFile(HoodieStorage storage, StoragePath filePath, Properties props) throws IOException {
        throw new UnsupportedOperationException("HFileUtils does not support writeMetaFile");
    }

    @Override
    public ByteArrayOutputStream serializeRecordsToLogBlock(HoodieStorage storage, List<HoodieRecord> records, Schema writerSchema, Schema readerSchema, String keyFieldName, Map<String, String> paramsMap) throws IOException {
        CompressionCodec compressionCodec = HFileUtils.getHFileCompressionAlgorithm(paramsMap);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream ostream = new DataOutputStream(baos);){
            HFileContext context = HFileContext.builder().blockSize(0x100000).compressionCodec(compressionCodec).build();
            boolean useIntegerKey = !HFileUtils.getRecordKey(records.get(0), readerSchema, keyFieldName).isPresent();
            int keyWidth = useIntegerKey ? (int)Math.ceil(Math.log(records.size())) + 1 : -1;
            int id = 0;
            Option keyField = Option.ofNullable((Object)writerSchema.getField(keyFieldName));
            try (HFileWriterImpl writer = new HFileWriterImpl(context, (OutputStream)ostream);){
                String previousRecordKey = null;
                for (int i = 0; i < records.size(); ++i) {
                    HoodieRecord record = records.get(i);
                    String recordKey = useIntegerKey ? String.format("%" + keyWidth + "s", id++) : (String)HFileUtils.getRecordKey(record, readerSchema, keyFieldName).get();
                    byte[] recordBytes = HFileUtils.serializeRecord(record, writerSchema, (Option<Schema.Field>)keyField);
                    if (i > 0 && recordKey.equals(previousRecordKey)) {
                        LOG.error("Found duplicate record with recordKey: {}", (Object)recordKey);
                        this.logRecordMetadata("Previous record", HFileUtils.serializeRecord(records.get(i - 1), writerSchema, (Option<Schema.Field>)keyField), writerSchema);
                        this.logRecordMetadata("Current record", HFileUtils.serializeRecord(record, writerSchema, (Option<Schema.Field>)keyField), writerSchema);
                        throw new HoodieException(String.format("Writing multiple records with same key %s not supported for Hfile format with Metadata table", recordKey));
                    }
                    try {
                        writer.append(recordKey, recordBytes);
                    }
                    catch (IOException e) {
                        throw new HoodieIOException("IOException serializing records", e);
                    }
                    previousRecordKey = recordKey;
                }
                writer.appendFileInfo("schema", StringUtils.getUTF8Bytes((String)readerSchema.toString()));
            }
            ((OutputStream)ostream).flush();
        }
        return baos;
    }

    private void logRecordMetadata(String msg, byte[] bs, Schema schema) throws IOException {
        GenericRecord record = HoodieAvroUtils.bytesToAvro(bs, schema);
        if (schema.getField(HoodieRecord.RECORD_KEY_METADATA_FIELD) != null) {
            LOG.error("{}: Hudi meta field values -> Record key: {}, Partition Path: {}, FileName: {}, CommitTime: {}, CommitSeqNo: {}", new Object[]{msg, record.get(HoodieRecord.RECORD_KEY_METADATA_FIELD), record.get(HoodieRecord.PARTITION_PATH_METADATA_FIELD), record.get(HoodieRecord.FILENAME_METADATA_FIELD), record.get(HoodieRecord.COMMIT_TIME_METADATA_FIELD), record.get(HoodieRecord.COMMIT_SEQNO_METADATA_FIELD)});
        }
    }

    @Override
    public Pair<ByteArrayOutputStream, Object> serializeRecordsToLogBlock(HoodieStorage storage, Iterator<HoodieRecord> records, HoodieRecord.HoodieRecordType recordType, Schema writerSchema, Schema readerSchema, String keyFieldName, Map<String, String> paramsMap) throws IOException {
        throw new UnsupportedOperationException("HFileUtils does not support serializeRecordsToLogBlock returning HoodieColumnRangeMetadata.");
    }

    private static Option<String> getRecordKey(HoodieRecord record, Schema readerSchema, String keyFieldName) {
        return Option.ofNullable((Object)record.getRecordKey(readerSchema, keyFieldName));
    }

    private static byte[] serializeRecord(HoodieRecord<?> record, Schema schema, Option<Schema.Field> keyField) throws IOException {
        return (byte[])record.toIndexedRecord(schema, CollectionUtils.emptyProps()).map(HoodieAvroIndexedRecord::getData).map(indexedRecord -> {
            keyField.ifPresent(field -> indexedRecord.put(field.pos(), (Object)""));
            return HoodieAvroUtils.avroToBytes(indexedRecord);
        }).orElseThrow(() -> new HoodieException("Unable to convert record to indexed record"));
    }
}

