/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;

public class HoodieDataUtils {
    public static <K, V> Map<K, V> dedupeAndCollectAsMap(HoodiePairData<K, V> pairData) {
        return pairData.mapToPair(pair -> Pair.of(Option.ofNullable(pair.getKey()), pair.getValue())).reduceByKey((existing, incoming) -> incoming, pairData.deduceNumPartitions()).collectAsList().stream().collect(HashMap::new, (map, pair) -> {
            Object key = ((Option)pair.getKey()).orElse(null);
            map.put(key, pair.getValue());
        }, HashMap::putAll);
    }

    public static <K, V> List<Pair<K, V>> dedupeAndCollectAsList(HoodiePairData<K, V> pairData) {
        return pairData.mapToPair(pair -> Pair.of(Option.ofNullable(pair.getKey()), pair.getValue())).reduceByKey((existing, incoming) -> incoming, pairData.deduceNumPartitions()).mapToPair(pair -> Pair.of(((Option)pair.getKey()).orElse(null), pair.getValue())).collectAsList();
    }

    public static <K, V> Map<K, Set<V>> collectPairDataAsMap(HoodiePairData<K, V> pairData) {
        return pairData.mapToPair(pair -> Pair.of(Option.ofNullable(pair.getKey()), Collections.singleton(pair.getValue()))).reduceByKey((set1, set2) -> {
            HashSet combined = new HashSet(set1);
            combined.addAll(set2);
            return combined;
        }, pairData.deduceNumPartitions()).collectAsList().stream().collect(HashMap::new, (map, pair) -> {
            Object key = ((Option)pair.getKey()).orElse(null);
            map.put(key, pair.getValue());
        }, HashMap::putAll);
    }
}

