/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.avro.Schema;
import org.apache.hudi.common.util.Option;

@NotThreadSafe
public class LocalAvroSchemaCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Integer, Schema> versionIdToSchema = new HashMap<Integer, Schema>();
    private final Map<Schema, Integer> schemaToVersionId = new HashMap<Schema, Integer>();
    private int nextVersionId = 0;

    private LocalAvroSchemaCache() {
    }

    public static LocalAvroSchemaCache getInstance() {
        return new LocalAvroSchemaCache();
    }

    public Integer cacheSchema(Schema schema) {
        Integer versionId = this.schemaToVersionId.get(schema);
        if (versionId == null) {
            versionId = this.nextVersionId++;
            this.schemaToVersionId.put(schema, versionId);
            this.versionIdToSchema.put(versionId, schema);
        }
        return versionId;
    }

    public Option<Schema> getSchema(Integer versionId) {
        return Option.ofNullable((Object)this.versionIdToSchema.get(versionId));
    }
}

