/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.List;
import java.util.function.Function;
import org.apache.hudi.common.util.collection.ArrayComparable;

public class OrderingValues {
    private static final Comparable<?> DEFAULT_VALUE = 0;

    public static Comparable create(Comparable[] orderingValues) {
        if (orderingValues.length == 1) {
            return orderingValues[0];
        }
        return new ArrayComparable(orderingValues);
    }

    public static Comparable create(List<String> orderingFields, Function<String, Comparable> fieldMappingFunction) {
        if (orderingFields.isEmpty()) {
            return DEFAULT_VALUE;
        }
        if (orderingFields.size() == 1) {
            return fieldMappingFunction.apply(orderingFields.get(0));
        }
        Comparable[] orderingValues = new Comparable[orderingFields.size()];
        for (int i = 0; i < orderingFields.size(); ++i) {
            orderingValues[i] = fieldMappingFunction.apply(orderingFields.get(i));
        }
        return new ArrayComparable(orderingValues);
    }

    public static Comparable create(String[] orderingFields, Function<String, Comparable> fieldMappingFunction) {
        if (orderingFields.length == 0) {
            return DEFAULT_VALUE;
        }
        if (orderingFields.length == 1) {
            return fieldMappingFunction.apply(orderingFields[0]);
        }
        Comparable[] orderingValues = new Comparable[orderingFields.length];
        for (int i = 0; i < orderingFields.length; ++i) {
            orderingValues[i] = fieldMappingFunction.apply(orderingFields[i]);
        }
        return new ArrayComparable(orderingValues);
    }

    public static Comparable getDefault() {
        return DEFAULT_VALUE;
    }

    public static boolean isDefault(Comparable orderingValue) {
        return DEFAULT_VALUE.equals(orderingValue);
    }

    public static boolean isSameClass(Comparable val1, Comparable val2) {
        if (val1.getClass() != val2.getClass()) {
            return false;
        }
        if (val1 instanceof ArrayComparable) {
            return ((ArrayComparable)val1).isValueSameClass((ArrayComparable)val2);
        }
        return true;
    }

    public static List<Comparable> getValues(ArrayComparable orderingValue) {
        return orderingValue.getValues();
    }

    public static boolean isCommitTimeOrderingValue(Comparable orderingValue) {
        return orderingValue == null || OrderingValues.isDefault(orderingValue);
    }
}

