/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.http.Consts;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.client.utils.URIBuilder;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.util.RetryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotePartitionHelper
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(RemotePartitionHelper.class);
    public static final String URL = "/v1/hoodie/partitioner/getpartitionindex";
    public static final String NUM_BUCKETS_PARAM = "numbuckets";
    public static final String PARTITION_PATH_PARAM = "partitionpath";
    public static final String PARTITION_NUM_PARAM = "partitionnum";
    private final RetryHelper retryHelper;
    private final String serverHost;
    private final Integer serverPort;
    private final ObjectMapper mapper;
    private final int timeoutMs;
    private final HashMap<String, Integer> cache;

    public RemotePartitionHelper(FileSystemViewStorageConfig viewConf) {
        this.retryHelper = new RetryHelper(viewConf.getRemoteTimelineClientMaxRetryIntervalMs().longValue(), viewConf.getRemoteTimelineClientMaxRetryNumbers().intValue(), viewConf.getRemoteTimelineInitialRetryIntervalMs().longValue(), viewConf.getRemoteTimelineClientRetryExceptions(), "Sending request");
        this.serverHost = viewConf.getRemoteViewServerHost();
        this.serverPort = viewConf.getRemoteViewServerPort();
        this.timeoutMs = viewConf.getRemoteTimelineClientTimeoutSecs() * 1000;
        this.mapper = new ObjectMapper();
        this.cache = new HashMap();
    }

    public int getPartition(int numBuckets, String partitionPath, int curBucket, int partitionNum) throws Exception {
        if (this.cache.containsKey(partitionPath)) {
            return this.computeActualPartition(this.cache.get(partitionPath), curBucket, partitionNum);
        }
        URIBuilder builder = new URIBuilder().setHost(this.serverHost).setPort(this.serverPort.intValue()).setPath(URL).setScheme("http");
        builder.addParameter(NUM_BUCKETS_PARAM, String.valueOf(numBuckets));
        builder.addParameter(PARTITION_PATH_PARAM, partitionPath);
        builder.addParameter(PARTITION_NUM_PARAM, String.valueOf(partitionNum));
        String url = builder.toString();
        LOG.debug("Sending request : (" + url + ").");
        Response response = (Response)(this.retryHelper != null ? this.retryHelper.start((RetryHelper.CheckedFunction & Serializable)() -> Request.Get((String)url).connectTimeout(this.timeoutMs).socketTimeout(this.timeoutMs).execute()) : Request.Get((String)url).connectTimeout(this.timeoutMs).socketTimeout(this.timeoutMs).execute());
        String content = response.returnContent().asString(Consts.UTF_8);
        int partitionIndex = Integer.parseInt((String)this.mapper.readValue(content, (TypeReference)new TypeReference<String>(){}));
        this.cache.put(partitionPath, partitionIndex);
        return this.computeActualPartition(partitionIndex, curBucket, partitionNum);
    }

    private int computeActualPartition(int startOffset, int curBucket, int partitionNum) {
        int res = startOffset + curBucket;
        return res >= partitionNum ? res % partitionNum : res;
    }
}

