/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.hudi.common.util.ValidationUtils;

public class ArrayComparable
implements Comparable<ArrayComparable>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Comparable[] values;

    public ArrayComparable(Comparable[] values) {
        this.values = values;
    }

    public List<Comparable> getValues() {
        return Arrays.asList(this.values);
    }

    public ArrayComparable apply(Function<Comparable, Comparable> mappingFunction) {
        return new ArrayComparable((Comparable[])Arrays.stream(this.values).map(mappingFunction).toArray(Comparable[]::new));
    }

    public ArrayComparable apply(List<Function<Comparable, Comparable>> mappingFunctions) {
        return new ArrayComparable((Comparable[])IntStream.range(0, this.values.length).mapToObj(i -> (Comparable)((Function)mappingFunctions.get(i)).apply(this.values[i])).toArray(Comparable[]::new));
    }

    public boolean isValueSameClass(ArrayComparable other) {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].getClass() == other.values[i].getClass()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(ArrayComparable otherOrderingValue) {
        ValidationUtils.checkArgument((this.values.length == otherOrderingValue.values.length ? 1 : 0) != 0, (String)"The values should be of the same size");
        for (int i = 0; i < this.values.length; ++i) {
            int comparingValue = this.values[i].compareTo(otherOrderingValue.values[i]);
            if (comparingValue == 0) continue;
            return comparingValue;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayComparable that = (ArrayComparable)o;
        if (this.values.length != that.values.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            Comparable objComparable = this.values[i];
            Comparable otherObjComparable = that.values[i];
            if (objComparable == null && otherObjComparable == null) continue;
            if (objComparable == null || otherObjComparable == null) {
                return false;
            }
            if (objComparable.equals(otherObjComparable)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.values);
    }

    public String toString() {
        return Arrays.toString(this.values);
    }
}

