/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class ClosableSortedDedupingIterator<T>
implements Iterator<T>,
AutoCloseable {
    private final Iterator<T> inner;
    private T nextUnique;
    private boolean hasNext;

    public ClosableSortedDedupingIterator(Iterator<T> inner) {
        this.inner = inner;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext) {
            return true;
        }
        while (this.inner.hasNext()) {
            T candidate = this.inner.next();
            if (Objects.equals(candidate, this.nextUnique)) continue;
            this.nextUnique = candidate;
            this.hasNext = true;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.hasNext = false;
        return this.nextUnique;
    }

    @Override
    public void close() throws Exception {
        if (this.inner instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.inner)).close();
        }
    }
}

