/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class ClosableSortingIterator<T>
implements Iterator<T>,
AutoCloseable {
    private final Iterator<T> source;
    private final boolean closable;
    private Iterator<T> sortedIterator;
    private boolean initialized = false;

    public ClosableSortingIterator(Iterator<T> source) {
        this.source = source;
        this.closable = source instanceof AutoCloseable;
    }

    @Override
    public boolean hasNext() {
        this.initializeIfNeeded();
        return this.sortedIterator.hasNext();
    }

    @Override
    public T next() {
        this.initializeIfNeeded();
        return this.sortedIterator.next();
    }

    @Override
    public void close() throws Exception {
        if (this.closable) {
            ((AutoCloseable)((Object)this.source)).close();
        }
    }

    private void initializeIfNeeded() {
        if (!this.initialized) {
            ArrayList list = new ArrayList();
            this.source.forEachRemaining(list::add);
            if (list.size() <= 1) {
                this.sortedIterator = list.iterator();
            } else {
                Object firstElement = list.get(0);
                if (!(firstElement instanceof Comparable)) {
                    throw new IllegalArgumentException("Elements must implement Comparable interface for sorting. Found: " + firstElement.getClass().getName());
                }
                try {
                    Collections.sort(list);
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Elements cannot be compared with each other for sorting", e);
                }
                this.sortedIterator = list.iterator();
            }
            this.initialized = true;
        }
    }
}

