/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.hash;

import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.ValidationUtils;

public class BucketIndexUtil {
    public static Functions.Function3<Integer, String, Integer, Integer> getPartitionIndexFunc(int parallelism) {
        return (bucketNum, partition, curBucket) -> {
            long partitionIndex = (long)((partition.hashCode() & Integer.MAX_VALUE) % parallelism) * (long)bucketNum.intValue();
            long globalIndex = partitionIndex + (long)curBucket.intValue();
            int partitionId = (int)(globalIndex % (long)parallelism);
            ValidationUtils.checkArgument((partitionId >= 0 && partitionId < parallelism ? 1 : 0) != 0, () -> "Partition id should be in range [0, " + parallelism + "), but got " + partitionId);
            return partitionId;
        };
    }
}

