/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config.metrics;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.metrics.HoodieMetricsCloudWatchConfig;
import org.apache.hudi.config.metrics.HoodieMetricsDatadogConfig;
import org.apache.hudi.config.metrics.HoodieMetricsGraphiteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsJmxConfig;
import org.apache.hudi.config.metrics.HoodieMetricsM3Config;
import org.apache.hudi.config.metrics.HoodieMetricsPrometheusConfig;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.metrics.datadog.DatadogHttpClient;

@ConfigClassProperty(name="Metrics Configurations", groupName=ConfigGroups.Names.METRICS, description="Enables reporting on Hudi metrics. Hudi publishes metrics on every commit, clean, rollback etc. The following sections list the supported reporters.")
@Immutable
public class HoodieMetricsConfig
extends HoodieConfig {
    public static final String METRIC_PREFIX = "hoodie.metrics";
    public static final ConfigProperty<Boolean> TURN_METRICS_ON = ConfigProperty.key("hoodie.metrics.on").defaultValue(false).sinceVersion("0.5.0").withDocumentation("Turn on/off metrics reporting. off by default.");
    public static final ConfigProperty<MetricsReporterType> METRICS_REPORTER_TYPE_VALUE = ConfigProperty.key("hoodie.metrics.reporter.type").defaultValue(MetricsReporterType.GRAPHITE).sinceVersion("0.5.0").withDocumentation("Type of metrics reporter.");
    public static final ConfigProperty<String> METRICS_REPORTER_CLASS_NAME = ConfigProperty.key("hoodie.metrics.reporter.class").defaultValue("").markAdvanced().sinceVersion("0.6.0").withDocumentation("");
    public static final ConfigProperty<String> METRICS_REPORTER_PREFIX = ConfigProperty.key("hoodie.metrics.reporter.metricsname.prefix").defaultValue("").sinceVersion("0.11.0").withInferFunction(cfg -> {
        if (cfg.contains(HoodieTableConfig.NAME)) {
            return Option.of((Object)cfg.getString(HoodieTableConfig.NAME));
        }
        return Option.empty();
    }).markAdvanced().withDocumentation("The prefix given to the metrics names.");
    public static final ConfigProperty<String> EXECUTOR_METRICS_ENABLE = ConfigProperty.key("hoodie.metrics.executor.enable").noDefaultValue().markAdvanced().sinceVersion("0.7.0").withDocumentation("");
    public static final ConfigProperty<Boolean> LOCK_METRICS_ENABLE = ConfigProperty.key("hoodie.metrics.lock.enable").defaultValue(false).withInferFunction(cfg -> {
        if (cfg.contains(TURN_METRICS_ON)) {
            return Option.of((Object)cfg.getBoolean(TURN_METRICS_ON));
        }
        return Option.empty();
    }).markAdvanced().sinceVersion("0.13.0").withDocumentation("Enable metrics for locking infra. Useful when operating in multiwriter mode");
    public static final ConfigProperty<String> METRICS_REPORTER_FILE_BASED_CONFIGS_PATH = ConfigProperty.key("hoodie.metrics.configs.properties").defaultValue("").markAdvanced().sinceVersion("0.14.0").withDocumentation("Comma separated list of config file paths for metric exporter configs");
    public static final ConfigProperty<Boolean> TURN_METRICS_COMPACTION_LOG_BLOCKS_ON = ConfigProperty.key("hoodie.metricscompaction.log.blocks.on").defaultValue(false).sinceVersion("0.14.0").withDocumentation("Turn on/off metrics reporting for log blocks with compaction commit. off by default.");
    @Deprecated
    public static final String METRICS_ON = TURN_METRICS_ON.key();
    @Deprecated
    public static final boolean DEFAULT_METRICS_ON = TURN_METRICS_ON.defaultValue();
    @Deprecated
    public static final String METRICS_REPORTER_TYPE = METRICS_REPORTER_TYPE_VALUE.key();
    @Deprecated
    public static final MetricsReporterType DEFAULT_METRICS_REPORTER_TYPE = METRICS_REPORTER_TYPE_VALUE.defaultValue();
    @Deprecated
    public static final String METRICS_REPORTER_CLASS = METRICS_REPORTER_CLASS_NAME.key();
    @Deprecated
    public static final String DEFAULT_METRICS_REPORTER_CLASS = METRICS_REPORTER_CLASS_NAME.defaultValue();
    @Deprecated
    public static final String ENABLE_EXECUTOR_METRICS = EXECUTOR_METRICS_ENABLE.key();

    private HoodieMetricsConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getBasePath() {
        String basePathKey = this.getString(HoodieCommonConfig.BASE_PATH);
        if (basePathKey == null) {
            return this.getString("hoodie.datasource.meta.sync.base.path");
        }
        return basePathKey;
    }

    public boolean isMetricsOn() {
        return this.getBoolean(TURN_METRICS_ON);
    }

    public boolean isCompactionLogBlockMetricsOn() {
        return this.getBoolean(TURN_METRICS_COMPACTION_LOG_BLOCKS_ON);
    }

    public boolean isExecutorMetricsEnabled() {
        return Boolean.parseBoolean(this.getStringOrDefault(EXECUTOR_METRICS_ENABLE, "false"));
    }

    public boolean isLockingMetricsEnabled() {
        return this.getBoolean(LOCK_METRICS_ENABLE);
    }

    public MetricsReporterType getMetricsReporterType() {
        return MetricsReporterType.valueOf(this.getString(METRICS_REPORTER_TYPE_VALUE));
    }

    public String getGraphiteServerHost() {
        return this.getString(HoodieMetricsGraphiteConfig.GRAPHITE_SERVER_HOST_NAME);
    }

    public int getGraphiteServerPort() {
        return this.getInt(HoodieMetricsGraphiteConfig.GRAPHITE_SERVER_PORT_NUM);
    }

    public String getGraphiteMetricPrefix() {
        return this.getString(HoodieMetricsGraphiteConfig.GRAPHITE_METRIC_PREFIX_VALUE);
    }

    public int getGraphiteReportPeriodSeconds() {
        return this.getInt(HoodieMetricsGraphiteConfig.GRAPHITE_REPORT_PERIOD_IN_SECONDS);
    }

    public String getM3ServerHost() {
        return this.getString(HoodieMetricsM3Config.M3_SERVER_HOST_NAME);
    }

    public int getM3ServerPort() {
        return this.getInt(HoodieMetricsM3Config.M3_SERVER_PORT_NUM);
    }

    public String getM3Tags() {
        return this.getString(HoodieMetricsM3Config.M3_TAGS);
    }

    public String getM3Env() {
        return this.getString(HoodieMetricsM3Config.M3_ENV);
    }

    public String getM3Service() {
        return this.getString(HoodieMetricsM3Config.M3_SERVICE);
    }

    public String getJmxHost() {
        return this.getString(HoodieMetricsJmxConfig.JMX_HOST_NAME);
    }

    public String getJmxPort() {
        return this.getString(HoodieMetricsJmxConfig.JMX_PORT_NUM);
    }

    public int getDatadogReportPeriodSeconds() {
        return this.getInt(HoodieMetricsDatadogConfig.REPORT_PERIOD_IN_SECONDS);
    }

    public DatadogHttpClient.ApiSite getDatadogApiSite() {
        return DatadogHttpClient.ApiSite.valueOf(this.getString(HoodieMetricsDatadogConfig.API_SITE_VALUE));
    }

    public String getDatadogApiKey() {
        if (this.props.containsKey(HoodieMetricsDatadogConfig.API_KEY.key())) {
            return this.getString(HoodieMetricsDatadogConfig.API_KEY);
        }
        Supplier apiKeySupplier = (Supplier)ReflectionUtils.loadClass((String)this.getString(HoodieMetricsDatadogConfig.API_KEY_SUPPLIER));
        return (String)apiKeySupplier.get();
    }

    public boolean getDatadogApiKeySkipValidation() {
        return this.getBoolean(HoodieMetricsDatadogConfig.API_KEY_SKIP_VALIDATION);
    }

    public int getDatadogApiTimeoutSeconds() {
        return this.getInt(HoodieMetricsDatadogConfig.API_TIMEOUT_IN_SECONDS);
    }

    public String getDatadogMetricPrefix() {
        return this.getString(HoodieMetricsDatadogConfig.METRIC_PREFIX_VALUE);
    }

    public String getDatadogMetricHost() {
        return this.getString(HoodieMetricsDatadogConfig.METRIC_HOST_NAME);
    }

    public List<String> getDatadogMetricTags() {
        return Arrays.stream(this.getStringOrDefault(HoodieMetricsDatadogConfig.METRIC_TAG_VALUES, ",").split("\\s*,\\s*")).collect(Collectors.toList());
    }

    public int getCloudWatchReportPeriodSeconds() {
        return this.getInt(HoodieMetricsCloudWatchConfig.REPORT_PERIOD_SECONDS);
    }

    public String getCloudWatchMetricPrefix() {
        return this.getString(HoodieMetricsCloudWatchConfig.METRIC_PREFIX);
    }

    public String getCloudWatchMetricNamespace() {
        return this.getString(HoodieMetricsCloudWatchConfig.METRIC_NAMESPACE);
    }

    public int getCloudWatchMaxDatumsPerRequest() {
        return this.getInt(HoodieMetricsCloudWatchConfig.MAX_DATUMS_PER_REQUEST);
    }

    public String getMetricReporterClassName() {
        return this.getString(METRICS_REPORTER_CLASS_NAME);
    }

    public int getPrometheusPort() {
        return this.getInt(HoodieMetricsPrometheusConfig.PROMETHEUS_PORT_NUM);
    }

    public String getPushGatewayHost() {
        return this.getString(HoodieMetricsPrometheusConfig.PUSHGATEWAY_HOST_NAME);
    }

    public int getPushGatewayPort() {
        return this.getInt(HoodieMetricsPrometheusConfig.PUSHGATEWAY_PORT_NUM);
    }

    public int getPushGatewayReportPeriodSeconds() {
        return this.getInt(HoodieMetricsPrometheusConfig.PUSHGATEWAY_REPORT_PERIOD_IN_SECONDS);
    }

    public boolean getPushGatewayDeleteOnShutdown() {
        return this.getBoolean(HoodieMetricsPrometheusConfig.PUSHGATEWAY_DELETE_ON_SHUTDOWN_ENABLE);
    }

    public String getPushGatewayJobName() {
        return this.getString(HoodieMetricsPrometheusConfig.PUSHGATEWAY_JOBNAME);
    }

    public String getPushGatewayLabels() {
        return this.getString(HoodieMetricsPrometheusConfig.PUSHGATEWAY_LABELS);
    }

    public boolean getPushGatewayRandomJobNameSuffix() {
        return this.getBoolean(HoodieMetricsPrometheusConfig.PUSHGATEWAY_RANDOM_JOBNAME_SUFFIX);
    }

    public String getMetricReporterMetricsNamePrefix() {
        return this.getStringOrDefault(METRICS_REPORTER_PREFIX).replaceAll("\\.", "_");
    }

    public String getMetricReporterFileBasedConfigs() {
        return this.getStringOrDefault(METRICS_REPORTER_FILE_BASED_CONFIGS_PATH);
    }

    public static class Builder {
        private final HoodieMetricsConfig hoodieMetricsConfig = new HoodieMetricsConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.hoodieMetricsConfig.getProps().load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromInputStream(InputStream inputStream) throws IOException {
            try {
                this.hoodieMetricsConfig.getProps().load(inputStream);
                Builder builder = this;
                return builder;
            }
            finally {
                inputStream.close();
            }
        }

        public Builder fromProperties(Properties props) {
            this.hoodieMetricsConfig.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public Builder on(boolean metricsOn) {
            this.hoodieMetricsConfig.setValue(TURN_METRICS_ON, String.valueOf(metricsOn));
            return this;
        }

        public Builder compactionLogBlocksEnable(boolean compactionLogBlockMetricsEnable) {
            this.hoodieMetricsConfig.setValue(TURN_METRICS_COMPACTION_LOG_BLOCKS_ON, String.valueOf(compactionLogBlockMetricsEnable));
            return this;
        }

        public Builder withPath(String basePath) {
            this.hoodieMetricsConfig.setValue(HoodieCommonConfig.BASE_PATH, basePath);
            return this;
        }

        public Builder withReporterType(String reporterType) {
            this.hoodieMetricsConfig.setValue(METRICS_REPORTER_TYPE_VALUE, reporterType);
            return this;
        }

        public Builder withMetricsReporterMetricNamePrefix(String metricNamePrefix) {
            this.hoodieMetricsConfig.setValue(METRICS_REPORTER_PREFIX, metricNamePrefix);
            return this;
        }

        public Builder withReporterClass(String className) {
            this.hoodieMetricsConfig.setValue(METRICS_REPORTER_CLASS_NAME, className);
            return this;
        }

        public Builder withExecutorMetrics(boolean enable) {
            this.hoodieMetricsConfig.setValue(EXECUTOR_METRICS_ENABLE, String.valueOf(enable));
            return this;
        }

        public Builder withLockingMetrics(boolean enable) {
            this.hoodieMetricsConfig.setValue(LOCK_METRICS_ENABLE, String.valueOf(enable));
            return this;
        }

        public HoodieMetricsConfig build() {
            this.hoodieMetricsConfig.setDefaults(HoodieMetricsConfig.class.getName());
            MetricsReporterType reporterType = MetricsReporterType.valueOf(this.hoodieMetricsConfig.getString(METRICS_REPORTER_TYPE_VALUE));
            this.hoodieMetricsConfig.setDefaultOnCondition(reporterType == MetricsReporterType.DATADOG, HoodieMetricsDatadogConfig.newBuilder().fromProperties(this.hoodieMetricsConfig.getProps()).build());
            this.hoodieMetricsConfig.setDefaultOnCondition(reporterType == MetricsReporterType.PROMETHEUS_PUSHGATEWAY, HoodieMetricsPrometheusConfig.newBuilder().fromProperties(this.hoodieMetricsConfig.getProps()).build());
            this.hoodieMetricsConfig.setDefaultOnCondition(reporterType == MetricsReporterType.PROMETHEUS, HoodieMetricsPrometheusConfig.newBuilder().fromProperties(this.hoodieMetricsConfig.getProps()).build());
            this.hoodieMetricsConfig.setDefaultOnCondition(reporterType == MetricsReporterType.JMX, HoodieMetricsJmxConfig.newBuilder().fromProperties(this.hoodieMetricsConfig.getProps()).build());
            this.hoodieMetricsConfig.setDefaultOnCondition(reporterType == MetricsReporterType.GRAPHITE, HoodieMetricsGraphiteConfig.newBuilder().fromProperties(this.hoodieMetricsConfig.getProps()).build());
            this.hoodieMetricsConfig.setDefaultOnCondition(reporterType == MetricsReporterType.CLOUDWATCH, HoodieMetricsCloudWatchConfig.newBuilder().fromProperties(this.hoodieMetricsConfig.getProps()).build());
            this.hoodieMetricsConfig.setDefaultOnCondition(reporterType == MetricsReporterType.M3, HoodieMetricsM3Config.newBuilder().fromProperties(this.hoodieMetricsConfig.getProps()).build());
            return this.hoodieMetricsConfig;
        }
    }
}

