/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.internal.schema.InternalSchemaBuilder;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;

public class InternalSchema
implements Serializable {
    public static final String ARRAY_ELEMENT = "element";
    public static final String MAP_KEY = "key";
    public static final String MAP_VALUE = "value";
    private static final InternalSchema EMPTY_SCHEMA = new InternalSchema(-1L, Types.RecordType.get(new Types.Field[0]));
    private static final long DEFAULT_VERSION_ID = 0L;
    private final Types.RecordType record;
    private int maxColumnId;
    private long versionId;
    private transient Map<Integer, Types.Field> idToField = null;
    private transient Map<String, Integer> nameToId = null;
    private transient Map<Integer, String> idToName = null;
    private transient Map<String, Integer> nameToPosition = null;

    public static InternalSchema getEmptyInternalSchema() {
        return EMPTY_SCHEMA;
    }

    public boolean isEmptySchema() {
        return this.versionId < 0L;
    }

    public InternalSchema(Types.RecordType recordType) {
        this(0L, recordType);
    }

    public InternalSchema(long versionId, int maxColumnId, Types.RecordType recordType) {
        this.maxColumnId = maxColumnId;
        this.versionId = versionId;
        this.record = recordType;
        this.getIdToName();
    }

    public InternalSchema(long versionId, Types.RecordType recordType) {
        this.versionId = versionId;
        this.record = recordType;
        this.idToName = InternalSchema.buildIdToName(this.record);
        this.nameToId = recordType.fields().isEmpty() ? Collections.emptyMap() : this.idToName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.maxColumnId = this.idToName.isEmpty() ? -1 : this.idToName.keySet().stream().max(Comparator.comparing(Integer::valueOf)).get();
    }

    public Types.RecordType getRecord() {
        return this.record;
    }

    private static Map<Integer, String> buildIdToName(Types.RecordType record) {
        return record.fields().isEmpty() ? Collections.emptyMap() : InternalSchemaBuilder.getBuilder().buildIdToName(record);
    }

    private Map<Integer, String> getIdToName() {
        if (this.idToName == null) {
            this.idToName = InternalSchema.buildIdToName(this.record);
        }
        return this.idToName;
    }

    private Map<String, Integer> buildNameToId() {
        if (this.nameToId == null) {
            if (this.idToName != null && !this.idToName.isEmpty()) {
                this.nameToId = this.idToName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
                return this.nameToId;
            }
            this.nameToId = InternalSchemaBuilder.getBuilder().buildNameToId(this.record);
        }
        return this.nameToId;
    }

    private Map<Integer, Types.Field> buildIdToField() {
        if (this.idToField == null) {
            this.idToField = InternalSchemaBuilder.getBuilder().buildIdToField(this.record);
        }
        return this.idToField;
    }

    public List<String> getAllColsFullName() {
        if (this.nameToId == null) {
            this.nameToId = InternalSchemaBuilder.getBuilder().buildNameToId(this.record);
        }
        return new ArrayList<String>(this.nameToId.keySet());
    }

    public InternalSchema setSchemaId(long versionId) {
        this.versionId = versionId;
        return this;
    }

    public long schemaId() {
        return this.versionId;
    }

    public void setMaxColumnId(int maxColumnId) {
        this.maxColumnId = maxColumnId;
    }

    public int getMaxColumnId() {
        return this.maxColumnId;
    }

    public List<Types.Field> columns() {
        return this.record.fields();
    }

    public String findFullName(int id) {
        String result = this.getIdToName().get(id);
        return result == null ? "" : result;
    }

    public Type findType(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        Integer id = this.buildNameToId().get(name);
        if (id != null) {
            return this.findType(id);
        }
        return null;
    }

    public Type findType(int id) {
        Types.Field field = this.buildIdToField().get(id);
        if (field != null) {
            return field.type();
        }
        return null;
    }

    public Set<Integer> getAllIds() {
        return this.getIdToName().keySet();
    }

    public Types.Field findField(int id) {
        return this.buildIdToField().get(id);
    }

    public Types.Field findField(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        Integer id = this.buildNameToId().get(name);
        if (id != null) {
            return this.buildIdToField().get(id);
        }
        return null;
    }

    public boolean hasColumn(String colName, boolean caseSensitive) {
        if (caseSensitive) {
            return this.getIdToName().containsValue(colName);
        }
        return this.getIdToName().values().stream().map(fieldName -> fieldName.toLowerCase(Locale.ROOT)).collect(Collectors.toSet()).contains(colName.toLowerCase(Locale.ROOT));
    }

    public int findIdByName(String name) {
        if (name == null || name.isEmpty()) {
            return -1;
        }
        return this.buildNameToId().getOrDefault(name, -1);
    }

    public Map<String, Integer> getNameToPosition() {
        if (this.nameToPosition == null) {
            this.nameToPosition = InternalSchemaBuilder.getBuilder().buildNameToPosition(this.record);
        }
        return this.nameToPosition;
    }

    public String toString() {
        return String.format("table {\n%s\n}", StringUtils.join((String[])((String[])this.record.fields().stream().map(f -> " " + f).toArray(String[]::new)), (String)"\n"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalSchema)) {
            return false;
        }
        InternalSchema that = (InternalSchema)o;
        if (this.versionId != that.schemaId()) {
            return false;
        }
        return this.record.equals(that.record);
    }

    public boolean equalsIgnoringVersion(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalSchema)) {
            return false;
        }
        InternalSchema that = (InternalSchema)o;
        return this.record.equals(that.record);
    }

    public int hashCode() {
        return this.record.hashCode();
    }
}

