/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.hudi.internal.schema.Types;

public interface Type
extends Serializable {
    public static final OffsetDateTime EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    public static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();

    public static TypeID fromValue(String value) {
        try {
            return TypeID.valueOf(value.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid value of Type: %s", value));
        }
    }

    public static Object fromPartitionString(String partitionValue, Type type) {
        if (partitionValue == null || "__HIVE_DEFAULT_PARTITION__".equals(partitionValue) || "default".equals(partitionValue)) {
            return null;
        }
        switch (type.typeId()) {
            case INT: {
                return Integer.parseInt(partitionValue);
            }
            case LONG: {
                return Long.parseLong(partitionValue);
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(partitionValue);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(partitionValue));
            }
            case DECIMAL: 
            case DECIMAL_BYTES: 
            case DECIMAL_FIXED: {
                return new BigDecimal(partitionValue);
            }
            case DOUBLE: {
                return Double.parseDouble(partitionValue);
            }
            case UUID: {
                return UUID.fromString(partitionValue);
            }
            case DATE: {
                return Math.toIntExact(ChronoUnit.DAYS.between(EPOCH_DAY, LocalDate.parse(partitionValue, DateTimeFormatter.ISO_LOCAL_DATE)));
            }
            case STRING: {
                return partitionValue;
            }
        }
        throw new UnsupportedOperationException("Cast value " + partitionValue + " to type " + type + " is not supported yet");
    }

    public TypeID typeId();

    default public boolean isNestedType() {
        return false;
    }

    public static abstract class NestedType
    implements Type {
        @Override
        public boolean isNestedType() {
            return true;
        }

        public abstract List<Types.Field> fields();

        public abstract Type fieldType(String var1);

        public abstract Types.Field field(int var1);
    }

    public static abstract class PrimitiveType
    implements Type {
        @Override
        public boolean isNestedType() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PrimitiveType)) {
                return false;
            }
            PrimitiveType that = (PrimitiveType)o;
            return this.typeId().equals((Object)that.typeId());
        }

        public int hashCode() {
            return Objects.hashCode((Object)this.typeId());
        }
    }

    public static enum TypeID {
        RECORD(Types.RecordType.class),
        ARRAY(List.class),
        MAP(Map.class),
        FIXED(ByteBuffer.class),
        STRING(String.class),
        BINARY(ByteBuffer.class),
        INT(Integer.class),
        LONG(Long.class),
        FLOAT(Float.class),
        DOUBLE(Double.class),
        DATE(Integer.class),
        BOOLEAN(Boolean.class),
        TIME(Long.class),
        TIMESTAMP(Long.class),
        DECIMAL(BigDecimal.class),
        UUID(UUID.class),
        DECIMAL_BYTES(BigDecimal.class),
        DECIMAL_FIXED(BigDecimal.class),
        TIME_MILLIS(Integer.class),
        TIMESTAMP_MILLIS(Long.class),
        LOCAL_TIMESTAMP_MILLIS(Long.class),
        LOCAL_TIMESTAMP_MICROS(Long.class);

        private final String name = this.name().toLowerCase(Locale.ROOT);
        private final Class<?> classTag;

        private TypeID(Class<?> classTag) {
            this.classTag = classTag;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getClassTag() {
            return this.classTag;
        }
    }
}

