/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.InternalSchemaBuilder;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.action.TableChange;
import org.apache.hudi.internal.schema.action.TableChangesHelper;
import org.apache.hudi.internal.schema.utils.SchemaChangeUtils;

public class TableChanges {

    public static class ColumnAddChange
    extends TableChange.BaseColumnChange {
        private final Map<String, Integer> fullColName2Id = new HashMap<String, Integer>();
        private final Map<Integer, ArrayList<Types.Field>> parentId2AddCols = new HashMap<Integer, ArrayList<Types.Field>>();
        private int nextId;

        public static ColumnAddChange get(InternalSchema internalSchema) {
            return new ColumnAddChange(internalSchema);
        }

        public Type applyAdd(Types.Field originalField, Type type) {
            int fieldId = originalField.fieldId();
            ArrayList<Types.Field> addFields = this.parentId2AddCols.getOrDefault(fieldId, new ArrayList());
            ArrayList<TableChange.ColumnPositionChange> pchanges = this.positionChangeMap.getOrDefault(fieldId, new ArrayList());
            if (!addFields.isEmpty() || !pchanges.isEmpty()) {
                List<Types.Field> newFields = TableChangesHelper.applyAddChange2Fields(((Types.RecordType)type).fields(), addFields, pchanges);
                return Types.RecordType.get(newFields);
            }
            return type;
        }

        public ColumnAddChange addColumns(String name, Type type, String doc) {
            this.checkColModifyIsLegal(name);
            return this.addColumns("", name, type, doc);
        }

        public ColumnAddChange addColumns(String parent, String name, Type type, String doc) {
            this.checkColModifyIsLegal(name);
            this.addColumnsInternal(parent, name, type, doc);
            return this;
        }

        private void addColumnsInternal(String parent, String name, Type type, String doc) {
            int parentId = -1;
            String fullName = name;
            if (!parent.isEmpty()) {
                Types.Field parentField = this.internalSchema.findField(parent);
                if (parentField == null) {
                    throw new HoodieSchemaException(String.format("Cannot add column '%s' because its parent column '%s' does not exist in the schema", name, parent));
                }
                if (!(parentField.type() instanceof Types.RecordType)) {
                    throw new HoodieSchemaException(String.format("Cannot add nested column '%s' to parent '%s' of type '%s'. Nested columns can only be added to struct/record types", name, parent, parentField.type()));
                }
                parentId = parentField.fieldId();
                Types.Field newParentField = this.internalSchema.findField(parent + "." + name);
                if (newParentField != null) {
                    throw new HoodieSchemaException(String.format("Cannot add column '%s' to parent '%s' because the column already exists at path '%s'", name, parent, parent + "." + name));
                }
                fullName = parent + "." + name;
            } else if (this.internalSchema.hasColumn(name, this.caseSensitive)) {
                throw new HoodieSchemaException(String.format("Cannot add column '%s' because it already exists in the schema", name));
            }
            if (this.fullColName2Id.containsKey(fullName)) {
                throw new HoodieSchemaException(String.format("Cannot add column '%s' multiple times. Column at path '%s' has already been added in this change set", name, fullName));
            }
            this.fullColName2Id.put(fullName, this.nextId);
            if (parentId != -1) {
                this.id2parent.put(this.nextId, parentId);
            }
            AtomicInteger assignNextId = new AtomicInteger(this.nextId + 1);
            Type typeWithNewId = InternalSchemaBuilder.getBuilder().refreshNewId(type, assignNextId);
            ArrayList<Types.Field> adds = this.parentId2AddCols.getOrDefault(parentId, new ArrayList());
            adds.add(Types.Field.get(this.nextId, true, name, typeWithNewId, doc));
            this.parentId2AddCols.put(parentId, adds);
            this.nextId = assignNextId.get();
        }

        private ColumnAddChange(InternalSchema internalSchema) {
            super(internalSchema);
            this.nextId = internalSchema.getMaxColumnId() + 1;
        }

        public Map<Integer, ArrayList<Types.Field>> getParentId2AddCols() {
            return this.parentId2AddCols;
        }

        public Map<Integer, ArrayList<TableChange.ColumnPositionChange>> getPositionChangeMap() {
            return this.positionChangeMap;
        }

        public Map<String, Integer> getFullColName2Id() {
            return this.fullColName2Id;
        }

        @Override
        protected Integer findIdByFullName(String fullName) {
            Types.Field field = this.internalSchema.findField(fullName);
            if (field != null) {
                return field.fieldId();
            }
            return this.fullColName2Id.getOrDefault(fullName, -1);
        }

        @Override
        public TableChange.ColumnChangeID columnChangeId() {
            return TableChange.ColumnChangeID.ADD;
        }

        @Override
        public boolean withPositionChange() {
            return true;
        }
    }

    public static class ColumnDeleteChange
    extends TableChange.BaseColumnChange {
        private final Set<Integer> deletes = new HashSet<Integer>();

        @Override
        public TableChange.ColumnChangeID columnChangeId() {
            return TableChange.ColumnChangeID.DELETE;
        }

        public static ColumnDeleteChange get(InternalSchema schema) {
            return new ColumnDeleteChange(schema);
        }

        private ColumnDeleteChange(InternalSchema schema) {
            super(schema);
        }

        @Override
        public boolean withPositionChange() {
            return false;
        }

        @Override
        public TableChange.BaseColumnChange addPositionChange(String srcId, String dsrId, String orderType) {
            throw new UnsupportedOperationException("no support add position change for ColumnDeleteChange");
        }

        public ColumnDeleteChange deleteColumn(String name) {
            this.checkColModifyIsLegal(name);
            Types.Field field = this.internalSchema.findField(name);
            if (field == null) {
                throw new SchemaCompatibilityException(String.format("Cannot delete column '%s' because it does not exist in the schema", name));
            }
            this.deletes.add(field.fieldId());
            return this;
        }

        public Type applyDelete(int id, Type type) {
            if (this.deletes.contains(id)) {
                return null;
            }
            return type;
        }

        public Set<Integer> getDeletes() {
            return this.deletes;
        }

        @Override
        protected Integer findIdByFullName(String fullName) {
            throw new UnsupportedOperationException("delete change cannot support this method");
        }
    }

    public static class ColumnUpdateChange
    extends TableChange.BaseColumnChange {
        private final Map<Integer, Types.Field> updates = new HashMap<Integer, Types.Field>();

        private ColumnUpdateChange(InternalSchema schema) {
            super(schema, false);
        }

        private ColumnUpdateChange(InternalSchema schema, boolean caseSensitive) {
            super(schema, caseSensitive);
        }

        @Override
        public boolean withPositionChange() {
            return true;
        }

        public Type applyUpdates(Types.Field oldField, Type type) {
            Types.Field update = this.updates.get(oldField.fieldId());
            if (update != null && update.type() != oldField.type()) {
                return update.type();
            }
            ArrayList<TableChange.ColumnPositionChange> pchanges = this.positionChangeMap.getOrDefault(oldField.fieldId(), new ArrayList());
            if (!pchanges.isEmpty()) {
                List<Types.Field> newFields = TableChangesHelper.applyAddChange2Fields(((Types.RecordType)type).fields(), new ArrayList<Types.Field>(), pchanges);
                return Types.RecordType.get(newFields);
            }
            return type;
        }

        public Map<Integer, Types.Field> getUpdates() {
            return this.updates;
        }

        public ColumnUpdateChange updateColumnType(String name, Type newType) {
            this.checkColModifyIsLegal(name);
            if (newType.isNestedType()) {
                throw new SchemaCompatibilityException(String.format("Cannot update column '%s' to nested type '%s'.", name, newType));
            }
            Types.Field field = this.internalSchema.findField(name);
            if (field == null) {
                throw new SchemaCompatibilityException(String.format("Cannot update type for column '%s' because it does not exist in the schema", name));
            }
            if (!SchemaChangeUtils.isTypeUpdateAllow(field.type(), newType)) {
                throw new SchemaCompatibilityException(String.format("Cannot update column '%s' from type '%s' to incompatible type '%s'.", name, field.type(), newType));
            }
            if (field.type().equals(newType)) {
                return this;
            }
            Types.Field update = this.updates.get(field.fieldId());
            if (update == null) {
                this.updates.put(field.fieldId(), Types.Field.get(field.fieldId(), field.isOptional(), field.name(), newType, field.doc()));
            } else {
                this.updates.put(field.fieldId(), Types.Field.get(field.fieldId(), update.isOptional(), update.name(), newType, update.doc()));
            }
            return this;
        }

        public ColumnUpdateChange updateColumnComment(String name, String newDoc) {
            this.checkColModifyIsLegal(name);
            Types.Field field = this.internalSchema.findField(name);
            if (field == null) {
                throw new SchemaCompatibilityException(String.format("Cannot update comment for column '%s' because it does not exist in the schema", name));
            }
            if (Objects.equals(field.doc(), newDoc)) {
                return this;
            }
            Types.Field update = this.updates.get(field.fieldId());
            if (update == null) {
                this.updates.put(field.fieldId(), Types.Field.get(field.fieldId(), field.isOptional(), field.name(), field.type(), newDoc));
            } else {
                this.updates.put(field.fieldId(), Types.Field.get(field.fieldId(), update.isOptional(), update.name(), update.type(), newDoc));
            }
            return this;
        }

        public ColumnUpdateChange renameColumn(String name, String newName) {
            this.checkColModifyIsLegal(name);
            Types.Field field = this.internalSchema.findField(name);
            if (field == null) {
                throw new SchemaCompatibilityException(String.format("Cannot rename column '%s' because it does not exist in the schema", name));
            }
            if (newName == null || newName.isEmpty()) {
                throw new SchemaCompatibilityException(String.format("Cannot rename column '%s' to empty or null name. New name must be non-empty", name));
            }
            if (this.internalSchema.hasColumn(newName, this.caseSensitive)) {
                throw new SchemaCompatibilityException(String.format("Cannot rename column '%s' to '%s' because a column with name '%s' already exists in the schema", name, newName, newName));
            }
            Types.Field update = this.updates.get(field.fieldId());
            if (update == null) {
                this.updates.put(field.fieldId(), Types.Field.get(field.fieldId(), field.isOptional(), newName, field.type(), field.doc()));
            } else {
                this.updates.put(field.fieldId(), Types.Field.get(field.fieldId(), update.isOptional(), newName, update.type(), update.doc()));
            }
            return this;
        }

        public ColumnUpdateChange updateColumnNullability(String name, boolean nullable) {
            return this.updateColumnNullability(name, nullable, false);
        }

        public ColumnUpdateChange updateColumnNullability(String name, boolean nullable, boolean force) {
            this.checkColModifyIsLegal(name);
            Types.Field field = this.internalSchema.findField(name);
            if (field == null) {
                throw new SchemaCompatibilityException(String.format("Cannot update nullability for column '%s' because it does not exist in the schema", name));
            }
            if (field.isOptional() == nullable) {
                return this;
            }
            if (field.isOptional() && !nullable && !force) {
                throw new SchemaCompatibilityException(String.format("Cannot change column '%s' from optional to required. This would break compatibility with existing data that may contain null values", name));
            }
            Types.Field update = this.updates.get(field.fieldId());
            if (update == null) {
                this.updates.put(field.fieldId(), Types.Field.get(field.fieldId(), nullable, field.name(), field.type(), field.doc()));
            } else {
                this.updates.put(field.fieldId(), Types.Field.get(field.fieldId(), nullable, update.name(), update.type(), update.doc()));
            }
            return this;
        }

        public Map<Integer, ArrayList<TableChange.ColumnPositionChange>> getPositionChangeMap() {
            return this.positionChangeMap;
        }

        @Override
        public TableChange.ColumnChangeID columnChangeId() {
            return TableChange.ColumnChangeID.UPDATE;
        }

        @Override
        protected Integer findIdByFullName(String fullName) {
            Types.Field field = this.internalSchema.findField(fullName);
            if (field != null) {
                return field.fieldId();
            }
            throw new SchemaCompatibilityException(String.format("Cannot find column ID for column path '%s'. The column may not exist in the schema", fullName));
        }

        public static ColumnUpdateChange get(InternalSchema schema) {
            return new ColumnUpdateChange(schema);
        }

        public static ColumnUpdateChange get(InternalSchema schema, boolean caseSensitive) {
            return new ColumnUpdateChange(schema, caseSensitive);
        }
    }
}

