/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.hudi.common.config.HoodieTimeGeneratorConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.io.AbstractInternalSchemaStorageManager;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.apache.hudi.storage.HoodieInstantWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedInternalSchemaStorageManager
extends AbstractInternalSchemaStorageManager {
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedInternalSchemaStorageManager.class);
    public static final String SCHEMA_NAME = ".schema";
    private final StoragePath baseSchemaPath;
    private final HoodieStorage storage;
    private HoodieTableMetaClient metaClient;

    public FileBasedInternalSchemaStorageManager(HoodieStorage storage, StoragePath baseTablePath) {
        StoragePath metaPath = new StoragePath(baseTablePath, ".hoodie");
        this.baseSchemaPath = new StoragePath(metaPath, SCHEMA_NAME);
        this.storage = storage;
    }

    public FileBasedInternalSchemaStorageManager(HoodieTableMetaClient metaClient) {
        this.baseSchemaPath = new StoragePath(metaClient.getMetaPath(), SCHEMA_NAME);
        this.storage = metaClient.getStorage();
        this.metaClient = metaClient;
    }

    private HoodieTableMetaClient getMetaClient() {
        if (this.metaClient == null) {
            this.metaClient = HoodieTableMetaClient.builder().setBasePath(this.baseSchemaPath.getParent().getParent().toString()).setStorage(this.storage).setTimeGeneratorConfig(HoodieTimeGeneratorConfig.defaultConfig(this.baseSchemaPath.getParent().getParent().toString())).build();
        }
        return this.metaClient;
    }

    @Override
    public void persistHistorySchemaStr(String instantTime, String historySchemaStr) {
        this.cleanResidualFiles();
        HoodieActiveTimeline timeline = this.getMetaClient().getActiveTimeline();
        HoodieInstant hoodieInstant = this.metaClient.createNewInstant(HoodieInstant.State.REQUESTED, "schemacommit", instantTime);
        timeline.createNewInstant(hoodieInstant);
        byte[] writeContent = StringUtils.getUTF8Bytes((String)historySchemaStr);
        timeline.transitionRequestedToInflight(hoodieInstant, Option.empty());
        timeline.saveAsComplete(false, this.metaClient.createNewInstant(HoodieInstant.State.INFLIGHT, hoodieInstant.getAction(), hoodieInstant.requestedTime()), Option.of((Object)HoodieInstantWriter.convertByteArrayToWriter((byte[])writeContent)));
        LOG.info(String.format("persist history schema success on commit time: %s", instantTime));
    }

    private void cleanResidualFiles() {
        List<String> validateCommits = this.getValidInstants();
        try {
            if (this.storage.exists(this.baseSchemaPath)) {
                List candidateSchemaFiles = this.storage.listDirectEntries(this.baseSchemaPath).stream().filter(f -> f.isFile()).map(file -> file.getPath().getName()).collect(Collectors.toList());
                List<String> residualSchemaFiles = candidateSchemaFiles.stream().filter(f -> !validateCommits.contains(this.getMetaClient().getInstantFileNameParser().extractTimestamp((String)f))).collect(Collectors.toList());
                residualSchemaFiles.forEach(f -> {
                    try {
                        this.storage.deleteFile(new StoragePath(this.getMetaClient().getSchemaFolderName(), f));
                    }
                    catch (IOException o) {
                        throw new HoodieException((Throwable)o);
                    }
                });
            }
        }
        catch (IOException e) {
            throw new HoodieException((Throwable)e);
        }
    }

    public void cleanOldFiles(List<String> validateCommits) {
        try {
            if (this.storage.exists(this.baseSchemaPath)) {
                List candidateSchemaFiles = this.storage.listDirectEntries(this.baseSchemaPath).stream().filter(f -> f.isFile()).map(file -> file.getPath().getName()).collect(Collectors.toList());
                List validateSchemaFiles = candidateSchemaFiles.stream().filter(f -> validateCommits.contains(this.getMetaClient().getInstantFileNameParser().extractTimestamp((String)f))).collect(Collectors.toList());
                for (int i = 0; i < validateSchemaFiles.size(); ++i) {
                    this.storage.deleteFile(new StoragePath((String)validateSchemaFiles.get(i)));
                }
            }
        }
        catch (IOException e) {
            throw new HoodieException((Throwable)e);
        }
    }

    private List<String> getValidInstants() {
        return this.getMetaClient().getCommitsTimeline().filterCompletedInstants().getInstantsAsStream().map(f -> f.requestedTime()).collect(Collectors.toList());
    }

    @Override
    public String getHistorySchemaStr() {
        return this.getHistorySchemaStrByGivenValidCommits(Collections.EMPTY_LIST);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getHistorySchemaStrByGivenValidCommits(List<String> validCommits) {
        List<String> commitList = validCommits == null || validCommits.isEmpty() ? this.getValidInstants() : validCommits;
        try {
            List validaSchemaFiles;
            if (this.storage.exists(this.baseSchemaPath) && !(validaSchemaFiles = this.storage.listDirectEntries(this.baseSchemaPath).stream().filter(f -> f.isFile() && f.getPath().getName().endsWith("schemacommit")).map(file -> file.getPath().getName()).filter(Objects::nonNull).filter(f -> commitList.contains(this.getMetaClient().getInstantFileNameParser().extractTimestamp((String)f))).sorted().collect(Collectors.toList())).isEmpty()) {
                StoragePath latestFilePath = new StoragePath(this.baseSchemaPath, (String)validaSchemaFiles.get(validaSchemaFiles.size() - 1));
                try (InputStream is = this.storage.open(latestFilePath);){
                    byte[] content = FileIOUtils.readAsByteArray((InputStream)is);
                    LOG.info(String.format("read history schema success from file : %s", latestFilePath));
                    String string = StringUtils.fromUTF8Bytes((byte[])content);
                    return string;
                }
                catch (IOException e) {
                    throw new HoodieIOException("Could not read history schema from " + latestFilePath, e);
                }
            }
        }
        catch (IOException io) {
            throw new HoodieException((Throwable)io);
        }
        LOG.info("failed to read history schema");
        return "";
    }

    public Option<InternalSchema> getSchemaByKey(String versionId) {
        String historySchemaStr = this.getHistorySchemaStr();
        if (historySchemaStr.isEmpty()) {
            return Option.empty();
        }
        TreeMap<Long, InternalSchema> treeMap = SerDeHelper.parseSchemas(historySchemaStr);
        InternalSchema result = InternalSchemaUtils.searchSchema((long)Long.valueOf(versionId), treeMap);
        if (result == null) {
            return Option.empty();
        }
        return Option.of((Object)result);
    }
}

