/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.action.TableChanges;
import org.apache.hudi.internal.schema.action.TableChangesHelper;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.SchemaChangeUtils;

public class AvroSchemaEvolutionUtils {
    private static final Set<String> META_FIELD_NAMES = Arrays.stream(HoodieRecord.HoodieMetadataField.values()).map(HoodieRecord.HoodieMetadataField::getFieldName).collect(Collectors.toSet());

    public static InternalSchema reconcileSchema(Schema incomingSchema, InternalSchema oldTableSchema, boolean makeMissingFieldsNullable) {
        InternalSchema evolvedSchema;
        if (incomingSchema.getType() == Schema.Type.NULL) {
            return oldTableSchema;
        }
        InternalSchema inComingInternalSchema = AvroInternalSchemaConverter.convert(incomingSchema, oldTableSchema.getNameToPosition());
        List<String> colNamesFromIncoming = inComingInternalSchema.getAllColsFullName();
        List<String> colNamesFromOldSchema = oldTableSchema.getAllColsFullName();
        List diffFromOldSchema = colNamesFromOldSchema.stream().filter(f -> !colNamesFromIncoming.contains(f)).collect(Collectors.toList());
        List diffFromEvolutionColumns = colNamesFromIncoming.stream().filter(f -> !colNamesFromOldSchema.contains(f)).collect(Collectors.toList());
        List typeChangeColumns = colNamesFromIncoming.stream().filter(f -> colNamesFromOldSchema.contains(f) && !inComingInternalSchema.findType((String)f).equals(oldTableSchema.findType((String)f))).collect(Collectors.toList());
        if (colNamesFromIncoming.size() == colNamesFromOldSchema.size() && diffFromOldSchema.size() == 0 && typeChangeColumns.isEmpty()) {
            return oldTableSchema;
        }
        TreeMap<Integer, String> finalAddAction = new TreeMap<Integer, String>();
        for (int i = 0; i < diffFromEvolutionColumns.size(); ++i) {
            String parentName;
            String name = (String)diffFromEvolutionColumns.get(i);
            int splitPoint = name.lastIndexOf(".");
            String string = parentName = splitPoint > 0 ? name.substring(0, splitPoint) : "";
            if (!parentName.isEmpty() && diffFromEvolutionColumns.contains(parentName)) continue;
            finalAddAction.put(inComingInternalSchema.findIdByName(name), name);
        }
        TableChanges.ColumnAddChange addChange = TableChanges.ColumnAddChange.get(oldTableSchema);
        finalAddAction.entrySet().stream().forEach(f -> {
            String name = (String)f.getValue();
            int splitPoint = name.lastIndexOf(".");
            String parentName = splitPoint > 0 ? name.substring(0, splitPoint) : "";
            String rawName = splitPoint > 0 ? name.substring(splitPoint + 1) : name;
            Optional<String> inferPosition = colNamesFromIncoming.stream().filter(c -> c.lastIndexOf(".") == splitPoint && c.startsWith(parentName) && inComingInternalSchema.findIdByName((String)c) > inComingInternalSchema.findIdByName(name) && oldTableSchema.findIdByName((String)c) > 0).sorted((s1, s2) -> oldTableSchema.findIdByName((String)s1) - oldTableSchema.findIdByName((String)s2)).findFirst();
            addChange.addColumns(parentName, rawName, inComingInternalSchema.findType(name), null);
            inferPosition.map(i -> addChange.addPositionChange(name, (String)i, "before"));
        });
        InternalSchema internalSchemaAfterAddColumns = SchemaChangeUtils.applyTableChanges2Schema(oldTableSchema, addChange);
        TableChanges.ColumnUpdateChange typeChange = TableChanges.ColumnUpdateChange.get(internalSchemaAfterAddColumns);
        typeChangeColumns.stream().filter(f -> !inComingInternalSchema.findType((String)f).isNestedType()).forEach(col -> typeChange.updateColumnType((String)col, inComingInternalSchema.findType((String)col)));
        if (makeMissingFieldsNullable) {
            HashSet visited = new HashSet();
            diffFromOldSchema.stream().filter(col -> !META_FIELD_NAMES.contains(col)).sorted().forEach(col -> {
                String parent = TableChangesHelper.getParentName(col);
                if (!visited.contains(parent)) {
                    typeChange.updateColumnNullability((String)col, true);
                }
                visited.add(col);
            });
        }
        if ((evolvedSchema = SchemaChangeUtils.applyTableChanges2Schema(internalSchemaAfterAddColumns, typeChange)).equalsIgnoringVersion(oldTableSchema)) {
            return oldTableSchema;
        }
        return evolvedSchema;
    }

    public static Schema reconcileSchema(Schema incomingSchema, Schema oldTableSchema, boolean makeMissingFieldsNullable) {
        return AvroInternalSchemaConverter.convert(AvroSchemaEvolutionUtils.reconcileSchema(incomingSchema, AvroInternalSchemaConverter.convert(oldTableSchema), makeMissingFieldsNullable), oldTableSchema.getFullName());
    }

    public static Schema reconcileSchemaRequirements(Schema sourceSchema, Schema targetSchema, boolean shouldReorderColumns) {
        if (targetSchema.getType() == Schema.Type.NULL || targetSchema.getFields().isEmpty()) {
            return sourceSchema;
        }
        if (sourceSchema == null || sourceSchema.getType() == Schema.Type.NULL || sourceSchema.getFields().isEmpty()) {
            return targetSchema;
        }
        InternalSchema targetInternalSchema = AvroInternalSchemaConverter.convert(targetSchema);
        InternalSchema sourceInternalSchema = AvroInternalSchemaConverter.convert(sourceSchema, shouldReorderColumns ? targetInternalSchema.getNameToPosition() : Collections.emptyMap());
        List<String> colNamesSourceSchema = sourceInternalSchema.getAllColsFullName();
        List<String> colNamesTargetSchema = targetInternalSchema.getAllColsFullName();
        ArrayList nullableUpdateColsInSource = new ArrayList();
        ArrayList typeUpdateColsInSource = new ArrayList();
        colNamesSourceSchema.forEach(field -> {
            if (colNamesTargetSchema.contains(field) && sourceInternalSchema.findField((String)field).isOptional() != targetInternalSchema.findField((String)field).isOptional()) {
                nullableUpdateColsInSource.add(field);
            }
            if (colNamesTargetSchema.contains(field) && SchemaChangeUtils.shouldPromoteType(sourceInternalSchema.findType((String)field), targetInternalSchema.findType((String)field))) {
                typeUpdateColsInSource.add(field);
            }
        });
        if (nullableUpdateColsInSource.isEmpty() && typeUpdateColsInSource.isEmpty()) {
            return AvroInternalSchemaConverter.convert(sourceInternalSchema, sourceSchema.getFullName());
        }
        TableChanges.ColumnUpdateChange schemaChange = TableChanges.ColumnUpdateChange.get(sourceInternalSchema);
        if (!nullableUpdateColsInSource.isEmpty()) {
            schemaChange = CollectionUtils.reduce(nullableUpdateColsInSource, schemaChange, (change, field) -> change.updateColumnNullability((String)field, true));
        }
        if (!typeUpdateColsInSource.isEmpty()) {
            schemaChange = CollectionUtils.reduce(typeUpdateColsInSource, schemaChange, (change, field) -> change.updateColumnType((String)field, targetInternalSchema.findType((String)field)));
        }
        return AvroInternalSchemaConverter.convert(SchemaChangeUtils.applyTableChanges2Schema(sourceInternalSchema, schemaChange), sourceSchema.getFullName());
    }
}

