/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.expression.Predicate;
import org.apache.hudi.io.storage.HoodieFileReader;

public abstract class HoodieAvroFileReader
implements HoodieFileReader<IndexedRecord> {
    @Override
    public ClosableIterator<HoodieRecord<IndexedRecord>> getRecordIterator(Schema readerSchema, Schema requestedSchema) throws IOException {
        ClosableIterator<IndexedRecord> iterator = this.getIndexedRecordIterator(readerSchema, requestedSchema);
        return new CloseableMappingIterator<IndexedRecord, HoodieRecord>(iterator, data -> (HoodieRecord)TypeUtils.unsafeCast(new HoodieAvroIndexedRecord((IndexedRecord)data)));
    }

    protected ClosableIterator<IndexedRecord> getIndexedRecordIterator(Schema readerSchema) throws IOException {
        return this.getIndexedRecordIterator(readerSchema, readerSchema);
    }

    public ClosableIterator<IndexedRecord> getIndexedRecordIterator(Schema readerSchema, Schema requestedSchema) throws IOException {
        return this.getIndexedRecordIterator(readerSchema, requestedSchema, Collections.emptyMap());
    }

    public abstract ClosableIterator<IndexedRecord> getIndexedRecordIterator(Schema var1, Schema var2, Map<String, String> var3) throws IOException;

    public abstract ClosableIterator<IndexedRecord> getIndexedRecordsByKeysIterator(List<String> var1, Schema var2) throws IOException;

    public abstract ClosableIterator<IndexedRecord> getIndexedRecordsByKeyPrefixIterator(List<String> var1, Schema var2) throws IOException;

    public boolean supportKeyPredicate() {
        return false;
    }

    public boolean supportKeyPrefixPredicate() {
        return false;
    }

    public List<String> extractKeys(Option<Predicate> keyPredicateOpt) {
        throw new UnsupportedOperationException("Option extractKeys is not supported");
    }

    public List<String> extractKeyPrefixes(Option<Predicate> keyPrefixPredicateOpt) {
        throw new UnsupportedOperationException("Option extractKeyPrefixes is not supported");
    }
}

