/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.io.storage.HoodieFileWriter;

public interface HoodieAvroFileWriter
extends HoodieFileWriter {
    @Override
    public boolean canWrite();

    @Override
    public void close() throws IOException;

    public void writeAvroWithMetadata(HoodieKey var1, IndexedRecord var2) throws IOException;

    public void writeAvro(String var1, IndexedRecord var2) throws IOException;

    @Override
    default public void writeWithMetadata(HoodieKey key, HoodieRecord record, Schema schema, Properties props) throws IOException {
        IndexedRecord avroPayload = ((HoodieAvroIndexedRecord)record.toIndexedRecord(schema, props).get()).getData();
        this.writeAvroWithMetadata(key, avroPayload);
    }

    @Override
    default public void write(String recordKey, HoodieRecord record, Schema schema, Properties props) throws IOException {
        IndexedRecord avroPayload = ((HoodieAvroIndexedRecord)record.toIndexedRecord(schema, props).get()).getData();
        this.writeAvro(recordKey, avroPayload);
    }

    default public void prepRecordWithMetadata(HoodieKey key, IndexedRecord avroRecord, String instantTime, Integer partitionId, long recordIndex, String fileName) {
        String seqId = HoodieRecord.generateSequenceId(instantTime, partitionId, recordIndex);
        HoodieAvroUtils.addHoodieKeyToRecord((GenericRecord)avroRecord, key.getRecordKey(), key.getPartitionPath(), fileName);
        HoodieAvroUtils.addCommitMetadataToRecord((GenericRecord)avroRecord, instantTime, seqId);
    }
}

