/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.io.storage.HoodieAvroFileReader;
import org.apache.hudi.io.storage.HoodieSeekingFileReader;

public abstract class HoodieAvroHFileReaderImplBase
extends HoodieAvroFileReader
implements HoodieSeekingFileReader<IndexedRecord> {
    public static final String SCHEMA_KEY = "schema";
    public static final String KEY_BLOOM_FILTER_META_BLOCK = "bloomFilter";
    public static final String KEY_BLOOM_FILTER_TYPE_CODE = "bloomFilterTypeCode";
    public static final String KEY_FIELD_NAME = "key";
    public static final String KEY_MIN_RECORD = "minRecordKey";
    public static final String KEY_MAX_RECORD = "maxRecordKey";

    public static List<IndexedRecord> readAllRecords(HoodieAvroFileReader reader) throws IOException {
        Schema schema = reader.getSchema();
        try (ClosableIterator<IndexedRecord> indexedRecordIterator = reader.getIndexedRecordIterator(schema);){
            List<IndexedRecord> list = CollectionUtils.toStream(indexedRecordIterator).collect(Collectors.toList());
            return list;
        }
    }

    public static List<IndexedRecord> readRecords(HoodieAvroHFileReaderImplBase reader, List<String> keys) throws IOException {
        return HoodieAvroHFileReaderImplBase.readRecords(reader, keys, reader.getSchema());
    }

    public static List<IndexedRecord> readRecords(HoodieAvroHFileReaderImplBase reader, List<String> keys, Schema schema) throws IOException {
        Collections.sort(keys);
        try (ClosableIterator<IndexedRecord> indexedRecordsByKeysIterator = reader.getIndexedRecordsByKeysIterator(keys, schema);){
            List<IndexedRecord> list = CollectionUtils.toStream(indexedRecordsByKeysIterator).collect(Collectors.toList());
            return list;
        }
    }

    protected static GenericRecord deserialize(byte[] keyBytes, int keyOffset, int keyLength, byte[] valueBytes, int valueOffset, int valueLength, GenericDatumReader<GenericRecord> datumReader, Schema.Field keyFieldSchema) throws IOException {
        BinaryDecoder binaryDecoder = HoodieAvroUtils.getBinaryDecoder(valueBytes, valueOffset, valueLength);
        GenericRecord avroRecord = (GenericRecord)datumReader.read(null, (Decoder)binaryDecoder);
        if (keyFieldSchema == null) {
            return avroRecord;
        }
        Object keyObject = avroRecord.get(keyFieldSchema.pos());
        if (keyObject != null && keyObject.toString().isEmpty()) {
            avroRecord.put(keyFieldSchema.pos(), (Object)StringUtils.fromUTF8Bytes((byte[])keyBytes, (int)keyOffset, (int)keyLength));
        }
        return avroRecord;
    }

    static Option<Schema.Field> getKeySchema(Schema schema) {
        return schema.getType() != Schema.Type.RECORD ? Option.empty() : Option.ofNullable((Object)schema.getField(KEY_FIELD_NAME));
    }
}

