/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.CollectionUtils;

public interface HoodieFileWriter
extends AutoCloseable {
    public boolean canWrite();

    public void writeWithMetadata(HoodieKey var1, HoodieRecord var2, Schema var3, Properties var4) throws IOException;

    public void write(String var1, HoodieRecord var2, Schema var3, Properties var4) throws IOException;

    @Override
    public void close() throws IOException;

    default public void writeWithMetadata(HoodieKey key, HoodieRecord record, Schema schema) throws IOException {
        this.writeWithMetadata(key, record, schema, CollectionUtils.emptyProps());
    }

    default public void write(String recordKey, HoodieRecord record, Schema schema) throws IOException {
        this.write(recordKey, record, schema, CollectionUtils.emptyProps());
    }

    default public Object getFileFormatMetadata() {
        throw new UnsupportedOperationException("HoodieFileWriter#getFormatMetadata is unsupported by default.");
    }
}

