/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.io.compress.CompressionCodec;
import org.apache.hudi.storage.StorageConfiguration;

public class HoodieHFileConfig {
    private final CompressionCodec compressionCodec;
    private final int blockSize;
    private final long maxFileSize;
    private final StorageConfiguration storageConf;
    private final BloomFilter bloomFilter;
    private final String keyFieldName;

    public HoodieHFileConfig(StorageConfiguration storageConf, CompressionCodec compressionCodec, int blockSize, long maxFileSize, String keyFieldName, BloomFilter bloomFilter) {
        this.storageConf = storageConf;
        this.compressionCodec = compressionCodec;
        this.blockSize = blockSize;
        this.maxFileSize = maxFileSize;
        this.bloomFilter = bloomFilter;
        this.keyFieldName = keyFieldName;
    }

    public StorageConfiguration getStorageConf() {
        return this.storageConf;
    }

    public CompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public boolean useBloomFilter() {
        return this.bloomFilter != null;
    }

    public BloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public String getKeyFieldName() {
        return this.keyFieldName;
    }
}

