/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.PublicAPIClass;
import org.apache.hudi.PublicAPIMethod;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.KeyGeneratorInterface;

@PublicAPIClass(maturity=ApiMaturityLevel.STABLE)
public abstract class KeyGenerator
implements KeyGeneratorInterface {
    public static final String NULL_RECORDKEY_PLACEHOLDER = "__null__";
    public static final String EMPTY_RECORDKEY_PLACEHOLDER = "__empty__";
    public static final String DEFAULT_COLUMN_VALUE_SEPARATOR = ":";
    public static final String DEFAULT_RECORD_KEY_PARTS_SEPARATOR = ",";
    protected final TypedProperties config;

    protected KeyGenerator(TypedProperties config) {
        this.config = config;
    }

    @Override
    @PublicAPIMethod(maturity=ApiMaturityLevel.STABLE)
    public abstract HoodieKey getKey(GenericRecord var1);

    @Override
    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public List<String> getRecordKeyFieldNames() {
        throw new UnsupportedOperationException("Bootstrap not supported for key generator. Please override this method in your custom key generator.");
    }

    public static String constructRecordKey(String[] recordKeyFields, BiFunction<String, Integer, String> recordValueFunction) {
        boolean keyIsNullEmpty = true;
        StringBuilder recordKey = new StringBuilder();
        for (int i = 0; i < recordKeyFields.length; ++i) {
            String recordKeyField = recordKeyFields[i];
            String recordKeyValue = recordValueFunction.apply(recordKeyField, i);
            if (recordKeyValue == null) {
                recordKey.append(recordKeyField).append(DEFAULT_COLUMN_VALUE_SEPARATOR).append(NULL_RECORDKEY_PLACEHOLDER);
            } else if (recordKeyValue.isEmpty()) {
                recordKey.append(recordKeyField).append(DEFAULT_COLUMN_VALUE_SEPARATOR).append(EMPTY_RECORDKEY_PLACEHOLDER);
            } else {
                recordKey.append(recordKeyField).append(DEFAULT_COLUMN_VALUE_SEPARATOR).append(recordKeyValue);
                keyIsNullEmpty = false;
            }
            if (i == recordKeyFields.length - 1) continue;
            recordKey.append(DEFAULT_RECORD_KEY_PARTS_SEPARATOR);
        }
        if (keyIsNullEmpty) {
            throw new HoodieKeyException("recordKey values: \"" + recordKey + "\" for fields: " + Arrays.toString(recordKeyFields) + " cannot be entirely null or empty.");
        }
        return recordKey.toString();
    }
}

