/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen.constant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hudi.common.config.EnumDescription;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnumDescription(value="Key generator type, indicating the key generator class to use, that implements `org.apache.hudi.keygen.KeyGenerator`.")
public enum KeyGeneratorType {
    SIMPLE("org.apache.hudi.keygen.SimpleKeyGenerator"),
    SIMPLE_AVRO("org.apache.hudi.keygen.SimpleAvroKeyGenerator"),
    COMPLEX("org.apache.hudi.keygen.ComplexKeyGenerator"),
    COMPLEX_AVRO("org.apache.hudi.keygen.ComplexAvroKeyGenerator"),
    TIMESTAMP("org.apache.hudi.keygen.TimestampBasedKeyGenerator"),
    TIMESTAMP_AVRO("org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator"),
    CUSTOM("org.apache.hudi.keygen.CustomKeyGenerator"),
    CUSTOM_AVRO("org.apache.hudi.keygen.CustomAvroKeyGenerator"),
    NON_PARTITION("org.apache.hudi.keygen.NonpartitionedKeyGenerator"),
    NON_PARTITION_AVRO("org.apache.hudi.keygen.NonpartitionedAvroKeyGenerator"),
    GLOBAL_DELETE("org.apache.hudi.keygen.GlobalDeleteKeyGenerator"),
    GLOBAL_DELETE_AVRO("org.apache.hudi.keygen.GlobalAvroDeleteKeyGenerator"),
    AUTO_RECORD("org.apache.hudi.keygen.AutoRecordGenWrapperKeyGenerator"),
    AUTO_RECORD_AVRO("org.apache.hudi.keygen.AutoRecordGenWrapperAvroKeyGenerator"),
    HOODIE_TABLE_METADATA("org.apache.hudi.metadata.HoodieTableMetadataKeyGenerator"),
    SPARK_SQL("org.apache.spark.sql.hudi.command.SqlKeyGenerator"),
    SPARK_SQL_UUID("org.apache.spark.sql.hudi.command.UuidKeyGenerator"),
    SPARK_SQL_MERGE_INTO("org.apache.spark.sql.hudi.command.MergeIntoKeyGenerator"),
    USER_PROVIDED("");

    private String className;
    private static final Logger LOG;

    private KeyGeneratorType(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public static KeyGeneratorType fromClassName(String className) {
        if (StringUtils.isNullOrEmpty((String)className)) {
            throw new IllegalArgumentException("Invalid keyGenerator class: " + className);
        }
        for (KeyGeneratorType type : KeyGeneratorType.values()) {
            if (!type.getClassName().equals(className)) continue;
            return type;
        }
        return USER_PROVIDED;
    }

    public static List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>(KeyGeneratorType.values().length);
        Arrays.stream(KeyGeneratorType.values()).forEach(x -> names.add(x.name()));
        return names;
    }

    @Nullable
    public static String getKeyGeneratorClassName(TypedProperties props) {
        if (ConfigUtils.containsConfigProperty(props, HoodieTableConfig.KEY_GENERATOR_CLASS_NAME)) {
            return ConfigUtils.getStringWithAltKeys(props, HoodieTableConfig.KEY_GENERATOR_CLASS_NAME);
        }
        if (ConfigUtils.containsConfigProperty(props, HoodieTableConfig.KEY_GENERATOR_TYPE)) {
            KeyGeneratorType keyGeneratorType = KeyGeneratorType.valueOf(ConfigUtils.getStringWithAltKeys(props, HoodieTableConfig.KEY_GENERATOR_TYPE));
            if (USER_PROVIDED == keyGeneratorType) {
                throw new IllegalArgumentException("No key generator class is provided properly for type: " + USER_PROVIDED.name());
            }
            return keyGeneratorType.getClassName();
        }
        LOG.info("No key generator type is set properly");
        return null;
    }

    @Nullable
    public static String getKeyGeneratorClassName(HoodieConfig config) {
        return KeyGeneratorType.getKeyGeneratorClassName(config.getProps());
    }

    @Nullable
    public static String getKeyGeneratorClassName(Map<String, String> config) {
        TypedProperties props = new TypedProperties();
        config.forEach(props::setProperty);
        return KeyGeneratorType.getKeyGeneratorClassName(props);
    }

    public static boolean isComplexKeyGenerator(HoodieConfig config) {
        KeyGeneratorType keyGeneratorType;
        if (config.contains(HoodieTableConfig.KEY_GENERATOR_TYPE)) {
            keyGeneratorType = KeyGeneratorType.valueOf(config.getString(HoodieTableConfig.KEY_GENERATOR_TYPE));
        } else if (config.contains(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME)) {
            try {
                keyGeneratorType = KeyGeneratorType.fromClassName(config.getString(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME));
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        } else {
            return false;
        }
        return keyGeneratorType == COMPLEX || keyGeneratorType == COMPLEX_AVRO;
    }

    static {
        LOG = LoggerFactory.getLogger(KeyGeneratorType.class);
    }
}

