/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieMetadataBloomFilter;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.HoodieDataUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.metadata.AbstractHoodieTableMetadata;
import org.apache.hudi.metadata.BloomFilterIndexRawKey;
import org.apache.hudi.metadata.ColumnStatsIndexRawKey;
import org.apache.hudi.metadata.FilesIndexRawKey;
import org.apache.hudi.metadata.HoodieMetadataMetrics;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.metadata.RawKey;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTableMetadata
extends AbstractHoodieTableMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTableMetadata.class);
    protected final HoodieTableMetaClient dataMetaClient;
    protected final Option<HoodieMetadataMetrics> metrics;
    protected final HoodieMetadataConfig metadataConfig;
    protected boolean isMetadataTableInitialized;
    protected final boolean hiveStylePartitioningEnabled;
    protected final boolean urlEncodePartitioningEnabled;

    protected BaseTableMetadata(HoodieEngineContext engineContext, HoodieStorage storage, HoodieMetadataConfig metadataConfig, String dataBasePath) {
        super(engineContext, storage, dataBasePath);
        this.dataMetaClient = HoodieTableMetaClient.builder().setStorage(storage).setBasePath(dataBasePath).build();
        this.hiveStylePartitioningEnabled = Boolean.parseBoolean(this.dataMetaClient.getTableConfig().getHiveStylePartitioningEnable());
        this.urlEncodePartitioningEnabled = Boolean.parseBoolean(this.dataMetaClient.getTableConfig().getUrlEncodePartitioning());
        this.metadataConfig = metadataConfig;
        this.isMetadataTableInitialized = this.dataMetaClient.getTableConfig().isMetadataTableAvailable();
        this.metrics = metadataConfig.isMetricsEnabled() ? Option.of((Object)new HoodieMetadataMetrics(HoodieMetricsConfig.newBuilder().fromProperties(metadataConfig.getProps()).withPath(dataBasePath).build(), this.dataMetaClient.getStorage())) : Option.empty();
    }

    protected HoodieEngineContext getEngineContext() {
        if (this.engineContext == null) {
            this.engineContext = new HoodieLocalEngineContext(this.dataMetaClient.getStorageConf());
        }
        return this.engineContext;
    }

    @Override
    public List<String> getAllPartitionPaths() throws IOException {
        ValidationUtils.checkArgument((boolean)this.isMetadataTableInitialized);
        try {
            return this.fetchAllPartitionPaths();
        }
        catch (Exception e) {
            throw new HoodieMetadataException("Failed to retrieve list of partition from metadata", e);
        }
    }

    @Override
    public List<StoragePathInfo> getAllFilesInPartition(StoragePath partitionPath) throws IOException {
        ValidationUtils.checkArgument((boolean)this.isMetadataTableInitialized);
        try {
            return this.fetchAllFilesInPartition(partitionPath);
        }
        catch (Exception e) {
            throw new HoodieMetadataException("Failed to retrieve files in partition " + partitionPath + " from metadata", e);
        }
    }

    @Override
    public Map<String, List<StoragePathInfo>> getAllFilesInPartitions(Collection<String> partitions) throws IOException {
        ValidationUtils.checkArgument((boolean)this.isMetadataTableInitialized);
        if (partitions.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            List<StoragePath> partitionPaths = partitions.stream().map(StoragePath::new).collect(Collectors.toList());
            return this.fetchAllFilesInPartitionPaths(partitionPaths);
        }
        catch (Exception e) {
            throw new HoodieMetadataException("Failed to retrieve files in partition from metadata", e);
        }
    }

    @Override
    public Option<BloomFilter> getBloomFilter(String partitionName, String fileName, String metadataPartitionName) throws HoodieMetadataException {
        if (!this.dataMetaClient.getTableConfig().getMetadataPartitions().contains(metadataPartitionName)) {
            LOG.error("Metadata bloom filter index is disabled!");
            return Option.empty();
        }
        Pair<String, String> partitionFileName = Pair.of(partitionName, fileName);
        Map<Pair<String, String>, BloomFilter> bloomFilters = this.getBloomFilters(Collections.singletonList(partitionFileName), metadataPartitionName);
        if (bloomFilters.isEmpty()) {
            LOG.error("Meta index: missing bloom filter for partition: {}, file: {}", (Object)partitionName, (Object)fileName);
            return Option.empty();
        }
        ValidationUtils.checkState((boolean)bloomFilters.containsKey(partitionFileName));
        return Option.of((Object)bloomFilters.get(partitionFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Pair<String, String>, BloomFilter> getBloomFilters(List<Pair<String, String>> partitionNameFileNameList, String metadataPartitionName) throws HoodieMetadataException {
        List<Pair<String, HoodieMetadataPayload>> hoodieRecords;
        if (!this.dataMetaClient.getTableConfig().getMetadataPartitions().contains(metadataPartitionName)) {
            LOG.error("Metadata bloom filter index is disabled!");
            return Collections.emptyMap();
        }
        if (partitionNameFileNameList.isEmpty()) {
            return Collections.emptyMap();
        }
        HoodieTimer timer = HoodieTimer.start();
        HashMap fileToKeyMap = new HashMap();
        ArrayList bloomFilterKeys = new ArrayList();
        partitionNameFileNameList.forEach(partitionNameFileNamePair -> {
            BloomFilterIndexRawKey rawKey = new BloomFilterIndexRawKey((String)partitionNameFileNamePair.getLeft(), (String)partitionNameFileNamePair.getRight());
            bloomFilterKeys.add(rawKey);
            fileToKeyMap.put(rawKey.encode(), partitionNameFileNamePair);
        });
        HoodiePairData<String, HoodieMetadataPayload> recordsData = this.readIndexRecordsWithKeys(HoodieListData.eager(bloomFilterKeys), metadataPartitionName);
        try {
            hoodieRecords = HoodieDataUtils.dedupeAndCollectAsList(recordsData);
            this.metrics.ifPresent(m -> m.updateMetrics("lookup_meta_index_bloom_filters", timer.endTimer()));
            this.metrics.ifPresent(m -> m.setMetric("lookup_meta_index_bloom_filters_file_count", bloomFilterKeys.size()));
        }
        finally {
            recordsData.unpersistWithDependencies();
        }
        HashMap<Pair<String, String>, BloomFilter> partitionFileToBloomFilterMap = new HashMap<Pair<String, String>, BloomFilter>(hoodieRecords.size());
        for (Pair<String, HoodieMetadataPayload> entry : hoodieRecords) {
            Option<HoodieMetadataBloomFilter> bloomFilterMetadata = entry.getValue().getBloomFilterMetadata();
            if (bloomFilterMetadata.isPresent()) {
                if (((HoodieMetadataBloomFilter)((Object)bloomFilterMetadata.get())).getIsDeleted()) continue;
                ValidationUtils.checkState((boolean)fileToKeyMap.containsKey(entry.getKey()));
                ByteBuffer bloomFilterByteBuffer = ((HoodieMetadataBloomFilter)((Object)bloomFilterMetadata.get())).getBloomFilter().duplicate();
                String bloomFilterType = ((HoodieMetadataBloomFilter)((Object)bloomFilterMetadata.get())).getType();
                BloomFilter bloomFilter = BloomFilterFactory.fromString(StandardCharsets.UTF_8.decode(bloomFilterByteBuffer).toString(), bloomFilterType);
                partitionFileToBloomFilterMap.put((Pair<String, String>)fileToKeyMap.get(entry.getKey()), bloomFilter);
                continue;
            }
            LOG.error("Meta index bloom filter missing for: {}", fileToKeyMap.get(entry.getKey()));
        }
        return partitionFileToBloomFilterMap;
    }

    @Override
    public Map<Pair<String, String>, HoodieMetadataColumnStats> getColumnStats(List<Pair<String, String>> partitionNameFileNameList, String columnName) throws HoodieMetadataException {
        Map<Pair<String, String>, List<HoodieMetadataColumnStats>> partitionNameFileToColStats = this.getColumnStats(partitionNameFileNameList, Collections.singletonList(columnName));
        ValidationUtils.checkArgument((partitionNameFileToColStats.isEmpty() || partitionNameFileToColStats.values().stream().anyMatch(stats -> stats.size() == 1) ? 1 : 0) != 0);
        return partitionNameFileToColStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (HoodieMetadataColumnStats)((Object)((Object)((List)entry.getValue()).get(0)))));
    }

    @Override
    public Map<Pair<String, String>, List<HoodieMetadataColumnStats>> getColumnStats(List<Pair<String, String>> partitionNameFileNameList, List<String> columnNames) throws HoodieMetadataException {
        if (!this.dataMetaClient.getTableConfig().isMetadataPartitionAvailable(MetadataPartitionType.COLUMN_STATS)) {
            LOG.error("Metadata column stats index is disabled!");
            return Collections.emptyMap();
        }
        Pair<List<ColumnStatsIndexRawKey>, Map<String, Pair<String, String>>> rawKeysAndMap = this.computeColStatRawKeys(partitionNameFileNameList, columnNames);
        return this.computeFileToColumnStatsMap(rawKeysAndMap.getLeft(), rawKeysAndMap.getRight());
    }

    protected List<String> fetchAllPartitionPaths() {
        HoodieTimer timer = HoodieTimer.start();
        Option<HoodieMetadataPayload> recordOpt = this.readFilesIndexRecords("__all_partitions__", MetadataPartitionType.FILES.getPartitionPath());
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_partitions", timer.endTimer()));
        List partitions = (List)recordOpt.map(metadataPayload -> {
            this.checkForSpuriousDeletes((HoodieMetadataPayload)metadataPayload, "\"all partitions\"");
            List<String> relativePaths = metadataPayload.getFilenames();
            if (relativePaths.size() == 1 && relativePaths.get(0).equals(".")) {
                return Collections.singletonList("");
            }
            return relativePaths;
        }).orElse(Collections.emptyList());
        LOG.info("Listed partitions from metadata: #partitions={}", (Object)partitions.size());
        return partitions;
    }

    List<StoragePathInfo> fetchAllFilesInPartition(StoragePath partitionPath) {
        String relativePartitionPath = FSUtils.getRelativePartitionPath(this.dataBasePath, partitionPath);
        String recordKey = relativePartitionPath.isEmpty() ? "." : relativePartitionPath;
        HoodieTimer timer = HoodieTimer.start();
        Option<HoodieMetadataPayload> metadataPayloadOpt = this.readFilesIndexRecords(recordKey, MetadataPartitionType.FILES.getPartitionPath());
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_files", timer.endTimer()));
        List pathInfoList = (List)metadataPayloadOpt.map(metadataPayload -> {
            this.checkForSpuriousDeletes((HoodieMetadataPayload)metadataPayload, recordKey);
            try {
                return metadataPayload.getFileList(this.dataMetaClient.getStorage(), partitionPath);
            }
            catch (Exception e) {
                throw new HoodieException("Failed to extract file-pathInfoList from the payload", (Throwable)e);
            }
        }).orElseGet(Collections::emptyList);
        LOG.debug("Listed file in partition from metadata: partition={}, #files={}", (Object)relativePartitionPath, (Object)pathInfoList.size());
        return pathInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, List<StoragePathInfo>> fetchAllFilesInPartitionPaths(List<StoragePath> partitionPaths) {
        List<Pair<String, HoodieMetadataPayload>> partitionIdRecordPairs;
        Map partitionIdToPathMap = partitionPaths.parallelStream().collect(Collectors.toMap(partitionPath -> {
            String partitionId = FSUtils.getRelativePartitionPath(this.dataBasePath, partitionPath);
            return partitionId.isEmpty() ? "." : partitionId;
        }, Function.identity()));
        HoodieTimer timer = HoodieTimer.start();
        List filesKeys = partitionIdToPathMap.keySet().stream().map(FilesIndexRawKey::new).collect(Collectors.toList());
        HoodiePairData<String, HoodieMetadataPayload> recordsData = this.readIndexRecordsWithKeys(HoodieListData.eager(filesKeys), MetadataPartitionType.FILES.getPartitionPath());
        try {
            partitionIdRecordPairs = HoodieDataUtils.dedupeAndCollectAsList(recordsData);
        }
        finally {
            recordsData.unpersistWithDependencies();
        }
        this.metrics.ifPresent(m -> m.updateMetrics("lookup_files", timer.endTimer()));
        Map<String, List<StoragePathInfo>> partitionPathToFilesMap = partitionIdRecordPairs.stream().map(e -> {
            String partitionId = (String)e.getKey();
            StoragePath partitionPath = (StoragePath)partitionIdToPathMap.get(partitionId);
            HoodieMetadataPayload metadataPayload = (HoodieMetadataPayload)e.getValue();
            this.checkForSpuriousDeletes(metadataPayload, partitionId);
            List<StoragePathInfo> files = metadataPayload.getFileList(this.dataMetaClient.getStorage(), partitionPath);
            return Pair.of(partitionPath.toString(), files);
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        LOG.info("Listed files in {} partitions from metadata", (Object)partitionPaths.size());
        return partitionPathToFilesMap;
    }

    private Pair<List<ColumnStatsIndexRawKey>, Map<String, Pair<String, String>>> computeColStatRawKeys(List<Pair<String, String>> partitionNameFileNameList, List<String> columnNames) {
        ArrayList<ColumnStatsIndexRawKey> rawKeys = new ArrayList<ColumnStatsIndexRawKey>();
        HashMap<String, Pair<String, String>> columnStatKeyToFileNameMap = new HashMap<String, Pair<String, String>>();
        for (String columnName : columnNames) {
            for (Pair<String, String> partitionNameFileNamePair : partitionNameFileNameList) {
                ColumnStatsIndexRawKey rawKey = new ColumnStatsIndexRawKey(partitionNameFileNamePair.getLeft(), partitionNameFileNamePair.getRight(), columnName);
                rawKeys.add(rawKey);
                columnStatKeyToFileNameMap.put(rawKey.encode(), partitionNameFileNamePair);
            }
        }
        return Pair.of(rawKeys, columnStatKeyToFileNameMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Pair<String, String>, List<HoodieMetadataColumnStats>> computeFileToColumnStatsMap(List<ColumnStatsIndexRawKey> rawKeys, Map<String, Pair<String, String>> columnStatKeyToFileNameMap) {
        List<Pair<String, HoodieMetadataPayload>> hoodieRecords;
        HoodieTimer timer = HoodieTimer.start();
        HoodiePairData<String, HoodieMetadataPayload> recordsData = this.readIndexRecordsWithKeys(HoodieListData.eager(rawKeys), MetadataPartitionType.COLUMN_STATS.getPartitionPath());
        try {
            hoodieRecords = HoodieDataUtils.dedupeAndCollectAsList(recordsData);
            this.metrics.ifPresent(m -> m.updateMetrics("lookup_meta_index_column_ranges", timer.endTimer()));
        }
        finally {
            recordsData.unpersistWithDependencies();
        }
        HashMap<Pair<String, String>, List<HoodieMetadataColumnStats>> fileToColumnStatMap = new HashMap<Pair<String, String>, List<HoodieMetadataColumnStats>>();
        for (Pair<String, HoodieMetadataPayload> entry : hoodieRecords) {
            Option<HoodieMetadataColumnStats> columnStatMetadata = entry.getValue().getColumnStatMetadata();
            if (columnStatMetadata.isPresent() && !((HoodieMetadataColumnStats)((Object)columnStatMetadata.get())).getIsDeleted()) {
                ValidationUtils.checkState((boolean)columnStatKeyToFileNameMap.containsKey(entry.getKey()));
                Pair<String, String> partitionFileNamePair = columnStatKeyToFileNameMap.get(entry.getKey());
                fileToColumnStatMap.computeIfAbsent(partitionFileNamePair, k -> new ArrayList()).add(columnStatMetadata.get());
                continue;
            }
            LOG.error("Meta index column stats missing for {}", (Object)entry.getKey());
        }
        return fileToColumnStatMap;
    }

    private void checkForSpuriousDeletes(HoodieMetadataPayload metadataPayload, String partitionName) {
        if (!metadataPayload.getDeletions().isEmpty()) {
            if (this.metadataConfig.shouldIgnoreSpuriousDeletes()) {
                LOG.warn("Metadata record for {} encountered some files to be deleted which were not added before. Ignoring the spurious deletes as the `{}` config is set to true", (Object)partitionName, (Object)HoodieMetadataConfig.IGNORE_SPURIOUS_DELETES.key());
            } else {
                throw new HoodieMetadataException("Metadata record for " + partitionName + " is inconsistent: " + metadataPayload);
            }
        }
    }

    protected abstract Option<HoodieMetadataPayload> readFilesIndexRecords(String var1, String var2);

    public abstract HoodiePairData<String, HoodieMetadataPayload> readIndexRecordsWithKeys(HoodieData<? extends RawKey> var1, String var2);

    protected abstract HoodiePairData<String, HoodieMetadataPayload> readIndexRecordsWithKeys(HoodieData<? extends RawKey> var1, String var2, Option<String> var3);

    public abstract HoodiePairData<String, String> readSecondaryIndexDataTableRecordKeysWithKeys(HoodieData<String> var1, String var2);

    public HoodieMetadataConfig getMetadataConfig() {
        return this.metadataConfig;
    }

    protected StorageConfiguration<?> getStorageConf() {
        return this.dataMetaClient.getStorageConf();
    }

    protected String getLatestDataInstantTime() {
        return (String)this.dataMetaClient.getActiveTimeline().filterCompletedInstants().lastInstant().map(HoodieInstant::requestedTime).orElse((Object)"00000000000000");
    }

    public boolean isMetadataTableInitialized() {
        return this.isMetadataTableInitialized;
    }
}

