/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Objects;
import org.apache.hudi.common.util.hash.FileIndexID;
import org.apache.hudi.common.util.hash.PartitionIndexID;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.RawKey;

public class BloomFilterIndexRawKey
implements RawKey {
    private final String partitionName;
    private final String fileName;

    public BloomFilterIndexRawKey(String partitionName, String fileName) {
        this.partitionName = Objects.requireNonNull(partitionName);
        this.fileName = Objects.requireNonNull(fileName);
    }

    @Override
    public String encode() {
        return HoodieMetadataPayload.getBloomFilterIndexKey(new PartitionIndexID(HoodieTableMetadataUtil.getBloomFilterIndexPartitionIdentifier(this.partitionName)), new FileIndexID(this.fileName));
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BloomFilterIndexRawKey that = (BloomFilterIndexRawKey)o;
        return Objects.equals(this.partitionName, that.partitionName) && Objects.equals(this.fileName, that.fileName);
    }

    public int hashCode() {
        return Objects.hash(this.partitionName, this.fileName);
    }

    public String toString() {
        return "BloomFilterRawKey{partitionName='" + this.partitionName + '\'' + ", fileName='" + this.fileName + '\'' + '}';
    }
}

