/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Objects;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.hash.ColumnIndexID;
import org.apache.hudi.common.util.hash.PartitionIndexID;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.RawKey;

public class ColumnStatsIndexPrefixRawKey
implements RawKey {
    private static final long serialVersionUID = 1L;
    private final String columnName;
    private final Option<String> partitionName;

    public ColumnStatsIndexPrefixRawKey(String columnName) {
        this(columnName, (Option<String>)Option.empty());
    }

    public ColumnStatsIndexPrefixRawKey(String columnName, String partitionName) {
        this(columnName, (Option<String>)Option.of((Object)partitionName));
    }

    public ColumnStatsIndexPrefixRawKey(String columnName, Option<String> partitionName) {
        this.columnName = Objects.requireNonNull(columnName, "Column name cannot be null");
        this.partitionName = Objects.requireNonNull(partitionName, "Partition name option cannot be null");
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Option<String> getPartitionName() {
        return this.partitionName;
    }

    @Override
    public String encode() {
        String encodedValue;
        ColumnIndexID columnIndexID = new ColumnIndexID(this.columnName);
        if (this.partitionName.isPresent()) {
            PartitionIndexID partitionIndexId = new PartitionIndexID(HoodieTableMetadataUtil.getColumnStatsIndexPartitionIdentifier((String)this.partitionName.get()));
            encodedValue = columnIndexID.asBase64EncodedString().concat(partitionIndexId.asBase64EncodedString());
        } else {
            encodedValue = columnIndexID.asBase64EncodedString();
        }
        return encodedValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnStatsIndexPrefixRawKey that = (ColumnStatsIndexPrefixRawKey)o;
        return Objects.equals(this.columnName, that.columnName) && Objects.equals(this.partitionName, that.partitionName);
    }

    public int hashCode() {
        return Objects.hash(this.columnName, this.partitionName);
    }

    public String toString() {
        return "ColumnStatsIndexKey{columnName='" + this.columnName + "', partitionName=" + this.partitionName + "}";
    }
}

