/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Objects;
import org.apache.hudi.common.util.hash.ColumnIndexID;
import org.apache.hudi.common.util.hash.FileIndexID;
import org.apache.hudi.common.util.hash.PartitionIndexID;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.RawKey;

public class ColumnStatsIndexRawKey
implements RawKey {
    private final String partitionName;
    private final String fileName;
    private final String columnName;

    public ColumnStatsIndexRawKey(String partitionName, String fileName, String columnName) {
        this.partitionName = Objects.requireNonNull(partitionName);
        this.fileName = Objects.requireNonNull(fileName);
        this.columnName = Objects.requireNonNull(columnName);
    }

    @Override
    public String encode() {
        return HoodieMetadataPayload.getColumnStatsIndexKey(new PartitionIndexID(HoodieTableMetadataUtil.getColumnStatsIndexPartitionIdentifier(this.partitionName)), new FileIndexID(this.fileName), new ColumnIndexID(this.columnName));
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnStatsIndexRawKey that = (ColumnStatsIndexRawKey)o;
        return Objects.equals(this.partitionName, that.partitionName) && Objects.equals(this.fileName, that.fileName) && Objects.equals(this.columnName, that.columnName);
    }

    public int hashCode() {
        return Objects.hash(this.partitionName, this.fileName, this.columnName);
    }

    public String toString() {
        return "ColumnStatsFileRawKey{partitionName='" + this.partitionName + '\'' + ", fileName='" + this.fileName + '\'' + ", columnName='" + this.columnName + '\'' + '}';
    }
}

