/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroReaderContext;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.data.HoodieListPairData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializableBiFunction;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializableFunctionUnchecked;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordGlobalLocation;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.table.read.FileGroupReaderSchemaHandler;
import org.apache.hudi.common.table.read.HoodieFileGroupReader;
import org.apache.hudi.common.table.read.buffer.FileGroupRecordBufferLoader;
import org.apache.hudi.common.table.read.buffer.ReusableFileGroupRecordBufferLoader;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.ClosableSortedDedupingIterator;
import org.apache.hudi.common.util.collection.CloseableFilterIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.common.util.collection.EmptyIterator;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.expression.BindVisitor;
import org.apache.hudi.expression.Expression;
import org.apache.hudi.expression.Literal;
import org.apache.hudi.expression.Predicate;
import org.apache.hudi.expression.Predicates;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.io.storage.HoodieAvroFileReader;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.metadata.BaseTableMetadata;
import org.apache.hudi.metadata.FilesIndexRawKey;
import org.apache.hudi.metadata.HoodieDataCleanupManager;
import org.apache.hudi.metadata.HoodieIndexVersion;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.metadata.RawKey;
import org.apache.hudi.metadata.RecordIndexRawKey;
import org.apache.hudi.metadata.SecondaryIndexKeyUtils;
import org.apache.hudi.metadata.SecondaryIndexPrefixRawKey;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieBackedTableMetadata
extends BaseTableMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieBackedTableMetadata.class);
    private static final Schema SCHEMA = HoodieAvroUtils.addMetadataFields(HoodieMetadataRecord.getClassSchema());
    private final String metadataBasePath;
    private final HoodieDataCleanupManager dataCleanupManager = new HoodieDataCleanupManager();
    private HoodieTableMetaClient metadataMetaClient;
    private Set<String> validInstantTimestamps = null;
    private HoodieTableFileSystemView metadataFileSystemView;
    private final boolean reuse;
    private transient Map<HoodieFileGroupId, Pair<HoodieAvroFileReader, ReusableFileGroupRecordBufferLoader<IndexedRecord>>> reusableFileReaders;
    private final Map<String, List<FileSlice>> partitionFileSliceMap = new ConcurrentHashMap<String, List<FileSlice>>();
    private final Map<String, List<FileSlice>> partitionedRLIFileSliceMap = new ConcurrentHashMap<String, List<FileSlice>>();

    public HoodieBackedTableMetadata(HoodieEngineContext engineContext, HoodieStorage storage, HoodieMetadataConfig metadataConfig, String datasetBasePath) {
        this(engineContext, storage, metadataConfig, datasetBasePath, false);
    }

    public HoodieBackedTableMetadata(HoodieEngineContext engineContext, HoodieStorage storage, HoodieMetadataConfig metadataConfig, String datasetBasePath, boolean reuse) {
        super(engineContext, storage, metadataConfig, datasetBasePath);
        this.reuse = reuse;
        this.metadataBasePath = HoodieTableMetadata.getMetadataTableBasePath(this.dataBasePath.toString());
        this.initIfNeeded();
    }

    private void initIfNeeded() {
        if (!this.isMetadataTableInitialized) {
            if (!HoodieTableMetadata.isMetadataTable(this.metadataBasePath)) {
                LOG.info("Metadata table is disabled.");
            }
        } else if (this.metadataMetaClient == null) {
            try {
                this.metadataMetaClient = HoodieTableMetaClient.builder().setStorage(this.getStorage()).setBasePath(this.metadataBasePath).build();
            }
            catch (TableNotFoundException e) {
                LOG.warn("Metadata table was not found at path {}", (Object)this.metadataBasePath);
                this.isMetadataTableInitialized = false;
                this.metadataMetaClient = null;
                this.metadataFileSystemView = null;
                this.validInstantTimestamps = null;
            }
            catch (Exception e) {
                LOG.error("Failed to initialize metadata table at path {}", (Object)this.metadataBasePath, (Object)e);
                this.isMetadataTableInitialized = false;
                this.metadataMetaClient = null;
                this.metadataFileSystemView = null;
                this.validInstantTimestamps = null;
            }
        }
    }

    private synchronized Map<HoodieFileGroupId, Pair<HoodieAvroFileReader, ReusableFileGroupRecordBufferLoader<IndexedRecord>>> getReusableFileReaders() {
        if (this.reusableFileReaders == null) {
            this.reusableFileReaders = new ConcurrentHashMap<HoodieFileGroupId, Pair<HoodieAvroFileReader, ReusableFileGroupRecordBufferLoader<IndexedRecord>>>();
        }
        return this.reusableFileReaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Option<HoodieMetadataPayload> readFilesIndexRecords(String key, String partitionName) {
        HoodiePairData<String, HoodieMetadataPayload> recordsData = this.readIndexRecordsWithKeys(HoodieListData.eager(Collections.singletonList(new FilesIndexRawKey(key))), partitionName);
        try {
            List<HoodieMetadataPayload> records = recordsData.values().collectAsList();
            ValidationUtils.checkArgument((records.size() <= 1 ? 1 : 0) != 0, () -> "Found more than 1 record for record key " + key);
            Option option = records.isEmpty() ? Option.empty() : Option.ofNullable((Object)records.get(0));
            return option;
        }
        finally {
            recordsData.unpersistWithDependencies();
        }
    }

    @Override
    public List<String> getPartitionPathWithPathPrefixUsingFilterExpression(List<String> relativePathPrefixes, Types.RecordType partitionFields, Expression expression) throws IOException {
        Expression boundedExpr = expression.accept(new BindVisitor(partitionFields, false));
        List<String> selectedPartitionPaths = this.getPartitionPathWithPathPrefixes(relativePathPrefixes);
        if (this.hiveStylePartitioningEnabled && HoodieBackedTableMetadata.getPathPartitionLevel(partitionFields, selectedPartitionPaths.get(0)) == partitionFields.fields().size()) {
            return selectedPartitionPaths.stream().filter(p -> (Boolean)boundedExpr.eval(HoodieBackedTableMetadata.extractPartitionValues(partitionFields, p, this.urlEncodePartitioningEnabled))).collect(Collectors.toList());
        }
        return selectedPartitionPaths;
    }

    @Override
    public List<String> getPartitionPathWithPathPrefixes(List<String> relativePathPrefixes) throws IOException {
        return this.getAllPartitionPaths().stream().filter(p -> relativePathPrefixes.stream().anyMatch(relativePathPrefix -> StringUtils.isNullOrEmpty((String)relativePathPrefix) || p.equals(relativePathPrefix) || p.startsWith(relativePathPrefix + "/"))).collect(Collectors.toList());
    }

    @Override
    public HoodieData<HoodieRecord<HoodieMetadataPayload>> getRecordsByKeyPrefixes(HoodieData<? extends RawKey> rawKeys, String partitionName, boolean shouldLoadInMemory) {
        ArrayList<String> sortedKeyPrefixes = new ArrayList<String>(rawKeys.map(key -> key.encode()).collectAsList());
        Collections.sort(sortedKeyPrefixes);
        List partitionFileSlices = this.partitionFileSliceMap.computeIfAbsent(partitionName, k -> HoodieTableMetadataUtil.getPartitionLatestMergedFileSlices(this.metadataMetaClient, this.getMetadataFileSystemView(), partitionName));
        ValidationUtils.checkState((!partitionFileSlices.isEmpty() ? 1 : 0) != 0, () -> "Number of file slices for partition " + partitionName + " should be > 0");
        return (shouldLoadInMemory ? HoodieListData.lazy(partitionFileSlices) : this.getEngineContext().parallelize(partitionFileSlices)).flatMap(fileSlice -> this.readSliceAndFilterByKeysIntoList(partitionName, (Collection<String>)sortedKeyPrefixes, (FileSlice)fileSlice, metadataRecord -> {
            HoodieMetadataPayload payload = new HoodieMetadataPayload((Option<GenericRecord>)Option.of((Object)metadataRecord));
            String rowKey = payload.key != null ? payload.key : metadataRecord.get("key").toString();
            HoodieKey key = new HoodieKey(rowKey, partitionName);
            return new HoodieAvroRecord<HoodieMetadataPayload>(key, payload);
        }, false)).filter(r -> !((HoodieMetadataPayload)r.getData()).isDeleted());
    }

    private static TreeSet<String> getDistinctSortedKeysForSingleSlice(HoodieData<String> keys) {
        List<String> keysList = keys.collectAsList();
        return new TreeSet<String>(keysList);
    }

    private HoodieData<HoodieRecord<HoodieMetadataPayload>> lookupIndexRecords(HoodieData<String> keys, String partitionName, List<FileSlice> fileSlices, Option<String> dataTablePartition) {
        if (dataTablePartition.isPresent()) {
            List fileSlicesForDataPartition = fileSlices.stream().filter(fileSlice -> HoodieTableMetadataUtil.getDataTablePartitionNameFromFileGroupName(fileSlice.getFileId()).equals(dataTablePartition.get())).collect(Collectors.toList());
            TreeSet<String> distinctSortedKeys = HoodieBackedTableMetadata.getDistinctSortedKeysForSingleSlice(keys);
            int fileGroupIndex = HoodieTableMetadataUtil.mapRecordKeyToFileGroupIndex((String)distinctSortedKeys.stream().findFirst().get(), fileSlicesForDataPartition.size());
            return this.readSliceAndFilterByKeysIntoList(partitionName, distinctSortedKeys, (FileSlice)fileSlicesForDataPartition.get(fileGroupIndex), false);
        }
        if (partitionName.equals(MetadataPartitionType.RECORD_INDEX.getPartitionPath()) && !fileSlices.isEmpty() && HoodieTableMetadataUtil.verifyRLIFile(fileSlices.get(0).getFileId(), true)) {
            if (keys.isEmpty()) {
                return HoodieListData.lazy(Collections.emptyList());
            }
            throw new IllegalArgumentException("File pruning with partitioned rli has not yet been implemented");
        }
        boolean isSecondaryIndex = MetadataPartitionType.fromPartitionPath(partitionName).equals((Object)MetadataPartitionType.SECONDARY_INDEX);
        int numFileSlices = fileSlices.size();
        if (numFileSlices == 1) {
            return this.readSliceAndFilterByKeysIntoList(partitionName, HoodieBackedTableMetadata.getDistinctSortedKeysForSingleSlice(keys), fileSlices.get(0), !isSecondaryIndex);
        }
        SerializableBiFunction<String, Integer, Integer> mappingFunction = HoodieTableMetadataUtil::mapRecordKeyToFileGroupIndex;
        keys = this.repartitioningIfNeeded(keys, partitionName, numFileSlices, mappingFunction);
        HoodiePairData persistedInitialPairData = keys.mapToPair(encodedKey -> new ImmutablePair(mappingFunction.apply((String)encodedKey, numFileSlices), (String)encodedKey));
        persistedInitialPairData.persist("MEMORY_AND_DISK_SER");
        this.dataCleanupManager.trackPersistedData(persistedInitialPairData);
        SerializableFunction processFunction = sortedKeys -> {
            ArrayList<String> keysList = new ArrayList<String>();
            try (ClosableSortedDedupingIterator distinctSortedKeyIter = new ClosableSortedDedupingIterator(sortedKeys);){
                if (!distinctSortedKeyIter.hasNext()) {
                    Iterator iterator = Collections.emptyIterator();
                    return iterator;
                }
                distinctSortedKeyIter.forEachRemaining(keysList::add);
            }
            FileSlice fileSlice = (FileSlice)fileSlices.get((Integer)mappingFunction.apply((String)keysList.get(0), numFileSlices));
            return this.lookupRecordsItr(partitionName, keysList, fileSlice, !isSecondaryIndex);
        };
        List keySpace = IntStream.range(0, numFileSlices).boxed().collect(Collectors.toList());
        return this.getEngineContext().mapGroupsByKey(persistedInitialPairData, processFunction, keySpace, true);
    }

    @Override
    public HoodiePairData<String, HoodieRecordGlobalLocation> readRecordIndexLocationsWithKeys(HoodieData<String> recordKeys) {
        return this.readRecordIndexLocationsWithKeys(recordKeys, (Option<String>)Option.empty());
    }

    @Override
    public HoodiePairData<String, HoodieRecordGlobalLocation> readRecordIndexLocationsWithKeys(HoodieData<String> recordKeys, Option<String> dataTablePartition) {
        ValidationUtils.checkState((boolean)this.dataMetaClient.getTableConfig().isMetadataPartitionAvailable(MetadataPartitionType.RECORD_INDEX), (String)"Record index is not initialized in MDT");
        return this.dataCleanupManager.ensureDataCleanupOnException(v -> {
            HoodieData<RecordIndexRawKey> rawKeys = recordKeys.map(RecordIndexRawKey::new);
            return this.readIndexRecordsWithKeys(rawKeys, MetadataPartitionType.RECORD_INDEX.getPartitionPath(), dataTablePartition).mapToPair(p -> Pair.of(p.getLeft(), ((HoodieMetadataPayload)p.getRight()).getRecordGlobalLocation()));
        });
    }

    @Override
    public HoodieData<HoodieRecordGlobalLocation> readRecordIndexLocations(HoodieData<String> recordKeys) {
        ValidationUtils.checkState((boolean)this.dataMetaClient.getTableConfig().isMetadataPartitionAvailable(MetadataPartitionType.RECORD_INDEX), (String)"Record index is not initialized in MDT");
        return this.dataCleanupManager.ensureDataCleanupOnException(v -> {
            HoodieData<RecordIndexRawKey> rawKeys = recordKeys.map(RecordIndexRawKey::new);
            return this.readIndexRecords(rawKeys, MetadataPartitionType.RECORD_INDEX.getPartitionPath(), (Option<String>)Option.empty()).map(r -> ((HoodieMetadataPayload)r.getData()).getRecordGlobalLocation());
        });
    }

    @Override
    public HoodiePairData<String, HoodieRecordGlobalLocation> readSecondaryIndexLocationsWithKeys(HoodieData<String> secondaryKeys, String partitionName) {
        HoodieIndexVersion indexVersion = HoodieTableMetadataUtil.existingIndexVersionOrDefault(partitionName, this.dataMetaClient);
        return this.dataCleanupManager.ensureDataCleanupOnException(v -> {
            if (indexVersion.equals((Object)HoodieIndexVersion.V1)) {
                return this.readSecondaryIndexLocationsWithKeysV1(secondaryKeys, partitionName);
            }
            if (indexVersion.equals((Object)HoodieIndexVersion.V2)) {
                return this.readSecondaryIndexLocationsWithKeysV2(secondaryKeys, partitionName);
            }
            throw new IllegalArgumentException("readSecondaryIndex does not support index with version " + (Object)((Object)indexVersion));
        });
    }

    @Override
    public HoodieData<HoodieRecordGlobalLocation> readSecondaryIndexLocations(HoodieData<String> secondaryKeys, String partitionName) {
        HoodieIndexVersion indexVersion = HoodieTableMetadataUtil.existingIndexVersionOrDefault(partitionName, this.dataMetaClient);
        return this.dataCleanupManager.ensureDataCleanupOnException(v -> {
            if (indexVersion.equals((Object)HoodieIndexVersion.V1)) {
                return this.readSecondaryIndexLocationsWithKeysV1(secondaryKeys, partitionName).values();
            }
            if (indexVersion.equals((Object)HoodieIndexVersion.V2)) {
                return this.readRecordIndexLocations(this.readSecondaryIndexDataTableRecordKeysV2(secondaryKeys, partitionName));
            }
            throw new IllegalArgumentException("readSecondaryIndexResult does not support index with version " + (Object)((Object)indexVersion));
        });
    }

    @Override
    public HoodiePairData<String, HoodieMetadataPayload> readIndexRecordsWithKeys(HoodieData<? extends RawKey> rawKeys, String partitionName) {
        return this.readIndexRecordsWithKeys(rawKeys, partitionName, (Option<String>)Option.empty());
    }

    @Override
    public HoodiePairData<String, HoodieMetadataPayload> readIndexRecordsWithKeys(HoodieData<? extends RawKey> rawKeys, String partitionName, Option<String> dataTablePartition) {
        return this.readIndexRecords(rawKeys, partitionName, dataTablePartition).mapToPair(record -> Pair.of(record.getRecordKey(), record.getData()));
    }

    public HoodieData<String> readSecondaryIndexDataTableRecordKeysV2(HoodieData<String> secondaryKeys, String partitionName) {
        return this.dataCleanupManager.ensureDataCleanupOnException(v -> {
            HoodieData<SecondaryIndexPrefixRawKey> rawKeys = secondaryKeys.map(SecondaryIndexPrefixRawKey::new);
            return this.readIndexRecordsWithKeys(rawKeys, partitionName, (Option<String>)Option.empty()).map(hoodieRecord -> SecondaryIndexKeyUtils.getRecordKeyFromSecondaryIndexKey((String)hoodieRecord.getLeft()));
        });
    }

    private HoodiePairData<String, HoodieRecordGlobalLocation> readSecondaryIndexLocationsWithKeysV2(HoodieData<String> secondaryKeys, String partitionName) {
        return this.readRecordIndexLocationsWithKeys(this.readSecondaryIndexDataTableRecordKeysV2(secondaryKeys, partitionName));
    }

    private HoodiePairData<String, HoodieRecordGlobalLocation> readSecondaryIndexLocationsWithKeysV1(HoodieData<String> secondaryKeys, String partitionName) {
        ValidationUtils.checkState((boolean)(secondaryKeys instanceof HoodieListData), (String)"readSecondaryIndex only support HoodieListData at the moment");
        ValidationUtils.checkState((boolean)this.dataMetaClient.getTableConfig().isMetadataPartitionAvailable(MetadataPartitionType.RECORD_INDEX), (String)"Record index is not initialized in MDT");
        ValidationUtils.checkState((boolean)this.dataMetaClient.getTableConfig().getMetadataPartitions().contains(partitionName), () -> "Secondary index is not initialized in MDT for: " + partitionName);
        HoodiePairData<String, String> pairedData = this.readSecondaryIndexDataTableRecordKeysWithKeys(HoodieListData.eager(secondaryKeys.collectAsList()), partitionName);
        List<String> recordKeys = pairedData.map(Pair::getValue).collectAsList();
        return this.readRecordIndexLocationsWithKeys(HoodieListData.eager(recordKeys));
    }

    protected HoodieData<HoodieRecord<HoodieMetadataPayload>> readIndexRecords(HoodieData<? extends RawKey> rawKeys, String partitionName, Option<String> dataTablePartition) {
        List fileSlices = this.partitionFileSliceMap.computeIfAbsent(partitionName, k -> HoodieTableMetadataUtil.getPartitionLatestMergedFileSlices(this.metadataMetaClient, this.getMetadataFileSystemView(), partitionName));
        ValidationUtils.checkState((!fileSlices.isEmpty() ? 1 : 0) != 0, (String)("No file slices found for partition: " + partitionName));
        HoodieData<String> keys = rawKeys.map(key -> key.encode());
        return this.lookupIndexRecords(keys, partitionName, fileSlices, dataTablePartition);
    }

    private HoodieData<String> repartitioningIfNeeded(HoodieData<String> keys, String partitionName, int numFileSlices, SerializableBiFunction<String, Integer, Integer> mappingFunction) {
        if (keys instanceof HoodieListData) {
            int parallelism = (int)keys.map(k -> (Integer)mappingFunction.apply((String)k, numFileSlices)).distinct().count();
            parallelism = Math.max(parallelism, 1);
            LOG.info("Repartitioning keys for partition {} from list data with parallelism: {}", (Object)partitionName, (Object)parallelism);
            keys = this.getEngineContext().parallelize(keys.collectAsList(), parallelism);
        } else if (keys.getNumPartitions() < this.metadataConfig.getRepartitionMinPartitionsThreshold()) {
            LOG.info("Repartitioning keys for partition {} to {} partitions", (Object)partitionName, (Object)this.metadataConfig.getRepartitionDefaultPartitions());
            keys = keys.repartition(this.metadataConfig.getRepartitionDefaultPartitions());
        }
        return keys;
    }

    private ClosableIterator<IndexedRecord> readSliceWithFilter(Predicate predicate, FileSlice fileSlice) throws IOException {
        Option<HoodieInstant> latestMetadataInstant = this.metadataMetaClient.getActiveTimeline().filterCompletedInstants().lastInstant();
        String latestMetadataInstantTime = (String)latestMetadataInstant.map(HoodieInstant::requestedTime).orElse((Object)"00000000000000");
        Set<String> validInstantTimestamps = this.getValidInstantTimestamps();
        Option instantRange = Option.of((Object)InstantRange.builder().rangeType(InstantRange.RangeType.EXACT_MATCH).explicitInstants(validInstantTimestamps).build());
        Map<StoragePath, HoodieAvroFileReader> baseFileReaders = Collections.emptyMap();
        ReusableFileGroupRecordBufferLoader recordBufferLoader = null;
        boolean shouldReuse = this.reuse && this.isFullScanAllowedForPartition(fileSlice.getPartitionPath());
        TypedProperties fileGroupReaderProps = ConfigUtils.buildFileGroupReaderProperties(this.metadataConfig, shouldReuse);
        if (shouldReuse) {
            Pair readers = this.getReusableFileReaders().computeIfAbsent(fileSlice.getFileGroupId(), fgId -> {
                try {
                    HoodieAvroFileReader baseFileReader = null;
                    if (fileSlice.getBaseFile().isPresent()) {
                        HoodieConfig fileGroupReaderConfig = new HoodieConfig(fileGroupReaderProps);
                        baseFileReader = (HoodieAvroFileReader)HoodieIOFactory.getIOFactory(this.getStorage()).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(fileGroupReaderConfig, ((HoodieBaseFile)fileSlice.getBaseFile().get()).getStoragePath(), this.metadataMetaClient.getTableConfig().getBaseFileFormat(), (Option<Schema>)Option.empty());
                    }
                    return Pair.of(baseFileReader, this.buildReusableRecordBufferLoader(fileSlice, latestMetadataInstantTime, (Option<InstantRange>)instantRange));
                }
                catch (IOException ex) {
                    throw new HoodieIOException("Error opening readers for metadata table partition " + fileSlice.getPartitionPath(), ex);
                }
            });
            if (fileSlice.getBaseFile().isPresent()) {
                baseFileReaders = Collections.singletonMap(((HoodieBaseFile)fileSlice.getBaseFile().get()).getStoragePath(), readers.getLeft());
            }
            ValidationUtils.checkArgument((boolean)(predicate instanceof Predicates.In), (String)"For Metadata Table Reuse, key filter should be based on full keys");
            recordBufferLoader = (ReusableFileGroupRecordBufferLoader)readers.getRight();
        }
        HoodieAvroReaderContext readerContext = new HoodieAvroReaderContext(this.storageConf, this.metadataMetaClient.getTableConfig(), (Option<InstantRange>)instantRange, (Option<Predicate>)Option.of((Object)predicate), baseFileReaders, fileGroupReaderProps);
        HoodieFileGroupReader<IndexedRecord> fileGroupReader = HoodieFileGroupReader.newBuilder().withReaderContext(readerContext).withHoodieTableMetaClient(this.metadataMetaClient).withLatestCommitTime(latestMetadataInstantTime).withFileSlice(fileSlice).withDataSchema(SCHEMA).withRequestedSchema(SCHEMA).withProps(fileGroupReaderProps).withRecordBufferLoader(recordBufferLoader).withEnableOptimizedLogBlockScan(this.metadataConfig.isOptimizedLogBlocksScanEnabled()).build();
        return fileGroupReader.getClosableIterator();
    }

    private ReusableFileGroupRecordBufferLoader<IndexedRecord> buildReusableRecordBufferLoader(FileSlice fileSlice, String latestMetadataInstantTime, Option<InstantRange> instantRangeOption) {
        HoodieAvroReaderContext readerContext = new HoodieAvroReaderContext(this.storageConf, this.metadataMetaClient.getTableConfig(), instantRangeOption, (Option<Predicate>)Option.empty(), ConfigUtils.buildFileGroupReaderProperties(this.metadataConfig, true));
        readerContext.initRecordMerger(this.metadataConfig.getProps());
        readerContext.setHasBootstrapBaseFile(false);
        readerContext.setHasLogFiles(fileSlice.hasLogFiles());
        readerContext.setSchemaHandler(new FileGroupReaderSchemaHandler<IndexedRecord>(readerContext, SCHEMA, SCHEMA, (Option<InternalSchema>)Option.empty(), this.metadataConfig.getProps(), this.metadataMetaClient));
        readerContext.setShouldMergeUseRecordPosition(false);
        readerContext.setLatestCommitTime(latestMetadataInstantTime);
        return FileGroupRecordBufferLoader.createReusable(readerContext);
    }

    private HoodieData<HoodieRecord<HoodieMetadataPayload>> readSliceAndFilterByKeysIntoList(String partitionName, Collection<String> sortedKeys, FileSlice fileSlice, boolean isFullKey) {
        return HoodieListData.lazy(this.lookupRecordsItr(partitionName, sortedKeys, fileSlice, isFullKey));
    }

    private ClosableIterator<Pair<String, HoodieRecord<HoodieMetadataPayload>>> readSliceAndFilterByKeys(String partitionName, List<String> sortedKeys, FileSlice fileSlice) {
        boolean isSecondaryIndex = MetadataPartitionType.fromPartitionPath(partitionName).equals((Object)MetadataPartitionType.SECONDARY_INDEX);
        return new CloseableFilterIterator<Pair<String, HoodieRecord<HoodieMetadataPayload>>>(this.readSliceAndFilterByKeysIntoList(partitionName, sortedKeys, fileSlice, metadataRecord -> {
            HoodieMetadataPayload payload = new HoodieMetadataPayload((Option<GenericRecord>)Option.of((Object)metadataRecord));
            String rowKey = payload.key != null ? payload.key : metadataRecord.get("key").toString();
            HoodieKey hoodieKey = new HoodieKey(rowKey, partitionName);
            return Pair.of(rowKey, new HoodieAvroRecord<HoodieMetadataPayload>(hoodieKey, payload));
        }, !isSecondaryIndex), p -> !((HoodieMetadataPayload)((HoodieRecord)p.getValue()).getData()).isDeleted());
    }

    private ClosableIterator<HoodieRecord<HoodieMetadataPayload>> lookupRecordsItr(String partitionName, Collection<String> keys, FileSlice fileSlice, boolean isFullKey) {
        return new CloseableFilterIterator<HoodieRecord<HoodieMetadataPayload>>(this.readSliceAndFilterByKeysIntoList(partitionName, keys, fileSlice, metadataRecord -> {
            HoodieMetadataPayload payload = new HoodieMetadataPayload((Option<GenericRecord>)Option.of((Object)metadataRecord));
            return new HoodieAvroRecord<HoodieMetadataPayload>(new HoodieKey(payload.key, partitionName), payload);
        }, isFullKey), r -> !((HoodieMetadataPayload)r.getData()).isDeleted());
    }

    private <T> ClosableIterator<T> readSliceAndFilterByKeysIntoList(String partitionName, Collection<String> sortedKeys, FileSlice fileSlice, SerializableFunctionUnchecked<GenericRecord, T> transformer, boolean isFullKey) {
        if (sortedKeys.isEmpty()) {
            return new EmptyIterator();
        }
        try {
            Predicate predicate = HoodieBackedTableMetadata.buildPredicate(partitionName, sortedKeys, isFullKey);
            ClosableIterator<IndexedRecord> rawIterator = this.readSliceWithFilter(predicate, fileSlice);
            return new CloseableMappingIterator<IndexedRecord, Object>(rawIterator, record -> {
                GenericRecord metadataRecord = (GenericRecord)record;
                return transformer.apply(metadataRecord);
            });
        }
        catch (IOException e) {
            throw new HoodieIOException("Error merging records from metadata table for " + sortedKeys.size() + " keys", e);
        }
    }

    static Predicate buildPredicate(String partitionName, Collection<String> sortedKeys, boolean isFullKey) {
        if (isFullKey) {
            ValidationUtils.checkArgument((!MetadataPartitionType.fromPartitionPath(partitionName).equals((Object)MetadataPartitionType.SECONDARY_INDEX) ? 1 : 0) != 0, (String)"Secondary index should never use full-key lookup");
            return Predicates.in(null, sortedKeys.stream().map(Literal::from).collect(Collectors.toList()));
        }
        return Predicates.startsWithAny(null, sortedKeys.stream().map(Literal::from).collect(Collectors.toList()));
    }

    private Set<String> getValidInstantTimestamps() {
        if (this.validInstantTimestamps == null) {
            this.validInstantTimestamps = HoodieTableMetadataUtil.getValidInstantTimestamps(this.dataMetaClient, this.metadataMetaClient);
        }
        return this.validInstantTimestamps;
    }

    private boolean isFullScanAllowedForPartition(String partitionName) {
        switch (partitionName) {
            case "files": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void close() {
        this.partitionFileSliceMap.clear();
        this.partitionedRLIFileSliceMap.clear();
        if (this.metadataFileSystemView != null) {
            this.metadataFileSystemView.close();
            this.metadataFileSystemView = null;
        }
        this.closeReusableReaders();
    }

    private void closeReusableReaders() {
        if (this.reuse) {
            this.getReusableFileReaders().values().forEach(pair -> {
                if (pair.getLeft() != null) {
                    ((HoodieAvroFileReader)pair.getLeft()).close();
                }
                if (pair.getRight() != null) {
                    ((ReusableFileGroupRecordBufferLoader)pair.getRight()).close();
                }
            });
            this.getReusableFileReaders().clear();
        }
    }

    public boolean enabled() {
        return this.isMetadataTableInitialized;
    }

    public HoodieTableMetaClient getMetadataMetaClient() {
        return this.metadataMetaClient;
    }

    public HoodieTableFileSystemView getMetadataFileSystemView() {
        if (this.metadataFileSystemView == null) {
            this.metadataFileSystemView = HoodieTableMetadataUtil.getFileSystemViewForMetadataTable(this.metadataMetaClient);
        }
        return this.metadataFileSystemView;
    }

    public Map<String, String> stats() {
        Set allMetadataPartitionPaths = Arrays.stream(MetadataPartitionType.getValidValues()).map(MetadataPartitionType::getPartitionPath).collect(Collectors.toSet());
        return (Map)this.metrics.map(m -> m.getStats(true, this.metadataMetaClient, (HoodieTableMetadata)this, (Set<String>)allMetadataPartitionPaths)).orElseGet(HashMap::new);
    }

    @Override
    public Option<String> getSyncedInstantTime() {
        Option<HoodieInstant> latestInstant;
        if (this.metadataMetaClient != null && (latestInstant = this.metadataMetaClient.getActiveTimeline().getDeltaCommitTimeline().filterCompletedInstants().lastInstant()).isPresent()) {
            return Option.of((Object)((HoodieInstant)latestInstant.get()).requestedTime());
        }
        return Option.empty();
    }

    @Override
    public Option<String> getLatestCompactionTime() {
        Option<HoodieInstant> latestCompaction;
        if (this.metadataMetaClient != null && (latestCompaction = this.metadataMetaClient.getActiveTimeline().getCommitAndReplaceTimeline().filterCompletedInstants().lastInstant()).isPresent()) {
            return Option.of((Object)((HoodieInstant)latestCompaction.get()).requestedTime());
        }
        return Option.empty();
    }

    @Override
    public void reset() {
        this.initIfNeeded();
        this.dataMetaClient.reloadActiveTimeline();
        if (this.metadataMetaClient != null) {
            this.metadataMetaClient.reloadActiveTimeline();
            if (this.metadataFileSystemView != null) {
                this.metadataFileSystemView.close();
            }
            this.metadataFileSystemView = null;
        }
        this.validInstantTimestamps = null;
        this.partitionFileSliceMap.clear();
        this.partitionedRLIFileSliceMap.clear();
        this.closeReusableReaders();
    }

    public List<FileSlice> getFilegroupsForPartition(MetadataPartitionType partition) {
        this.partitionFileSliceMap.computeIfAbsent(partition.getPartitionPath(), k -> HoodieTableMetadataUtil.getPartitionLatestMergedFileSlices(this.metadataMetaClient, this.getMetadataFileSystemView(), partition.getPartitionPath()));
        return this.partitionFileSliceMap.get(partition.getPartitionPath());
    }

    @Override
    public int getNumFileGroupsForPartition(MetadataPartitionType partition) {
        return this.getFilegroupsForPartition(partition).size();
    }

    @Override
    public Map<String, List<FileSlice>> getBucketizedFileGroupsForPartitionedRLI(MetadataPartitionType partition) {
        if (!partition.equals((Object)MetadataPartitionType.RECORD_INDEX)) {
            throw new IllegalArgumentException("This method should only be used by RLI");
        }
        if (this.partitionedRLIFileSliceMap.isEmpty()) {
            List<FileSlice> fileSlices = this.getFilegroupsForPartition(partition);
            if (fileSlices.isEmpty()) {
                return Collections.emptyMap();
            }
            if (HoodieTableMetadataUtil.verifyRLIFile(fileSlices.get(0).getFileId(), false)) {
                throw new IllegalArgumentException("This method should only be used with partitioned RLI");
            }
            fileSlices.forEach(s -> this.partitionedRLIFileSliceMap.computeIfAbsent(HoodieTableMetadataUtil.getDataTablePartitionNameFromFileGroupName(s.getFileId()), x -> new ArrayList()).add(s));
        }
        return this.partitionedRLIFileSliceMap;
    }

    @Override
    public Map<Pair<String, StoragePath>, List<StoragePathInfo>> listPartitions(List<Pair<String, StoragePath>> partitionPathList) throws IOException {
        Map absoluteToPairMap = partitionPathList.stream().collect(Collectors.toMap(pair -> ((StoragePath)pair.getRight()).toString(), Function.identity()));
        return this.getAllFilesInPartitions(partitionPathList.stream().map(pair -> ((StoragePath)pair.getRight()).toString()).collect(Collectors.toList())).entrySet().stream().collect(Collectors.toMap(entry -> (Pair)absoluteToPairMap.get(entry.getKey()), Map.Entry::getValue));
    }

    @Override
    public HoodiePairData<String, String> readSecondaryIndexDataTableRecordKeysWithKeys(HoodieData<String> secondaryKeys, String partitionName) {
        HoodieIndexVersion indexVersion = HoodieTableMetadataUtil.existingIndexVersionOrDefault(partitionName, this.dataMetaClient);
        return this.dataCleanupManager.ensureDataCleanupOnException(v -> {
            if (indexVersion.equals((Object)HoodieIndexVersion.V1)) {
                return this.readSecondaryIndexDataTableRecordKeysWithKeysV1(secondaryKeys, partitionName);
            }
            if (indexVersion.equals((Object)HoodieIndexVersion.V2)) {
                return this.readSecondaryIndexDataTableRecordKeysWithKeysV2(secondaryKeys, partitionName);
            }
            throw new IllegalArgumentException("getSecondaryIndexRecords does not support index with version " + (Object)((Object)indexVersion));
        });
    }

    private HoodiePairData<String, String> readSecondaryIndexDataTableRecordKeysWithKeysV1(HoodieData<String> keys, String partitionName) {
        if (keys.isEmpty()) {
            return HoodieListPairData.eager(Collections.emptyList());
        }
        HoodieData<SecondaryIndexPrefixRawKey> rawKeys = keys.map(SecondaryIndexPrefixRawKey::new);
        return this.getRecordsByKeyPrefixes(rawKeys, partitionName, false).mapToPair(hoodieRecord -> SecondaryIndexKeyUtils.getSecondaryKeyRecordKeyPair(hoodieRecord.getRecordKey()));
    }

    private HoodiePairData<String, String> readSecondaryIndexDataTableRecordKeysWithKeysV2(HoodieData<String> secondaryKeys, String partitionName) {
        if (secondaryKeys.isEmpty()) {
            return HoodieListPairData.eager(Collections.emptyList());
        }
        HoodieData<SecondaryIndexPrefixRawKey> rawKeys = secondaryKeys.map(SecondaryIndexPrefixRawKey::new);
        return this.readIndexRecords(rawKeys, partitionName, (Option<String>)Option.empty()).mapToPair(hoodieRecord -> SecondaryIndexKeyUtils.getSecondaryKeyRecordKeyPair(hoodieRecord.getRecordKey()));
    }
}

