/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.function.SerializableFunctionUnchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieDataCleanupManager
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieDataCleanupManager.class);
    private final ConcurrentHashMap<Long, List<Object>> threadPersistedData = new ConcurrentHashMap();

    public void trackPersistedData(HoodiePairData<?, ?> data) {
        long threadId = Thread.currentThread().getId();
        this.threadPersistedData.computeIfAbsent(threadId, k -> new ArrayList()).add(data);
    }

    public void trackPersistedData(HoodieData<?> data) {
        long threadId = Thread.currentThread().getId();
        this.threadPersistedData.computeIfAbsent(threadId, k -> new ArrayList()).add(data);
    }

    public <T> T ensureDataCleanupOnException(SerializableFunctionUnchecked<Void, T> operation) {
        try {
            T t = operation.apply(null);
            return t;
        }
        catch (Exception e) {
            this.cleanupPersistedData();
            throw (RuntimeException)e;
        }
        finally {
            this.clearThreadTracking();
        }
    }

    private void cleanupPersistedData() {
        long threadId = Thread.currentThread().getId();
        List<Object> dataObjects = this.threadPersistedData.get(threadId);
        if (dataObjects != null) {
            for (Object data : dataObjects) {
                try {
                    if (data instanceof HoodiePairData) {
                        ((HoodiePairData)data).unpersistWithDependencies();
                        continue;
                    }
                    if (!(data instanceof HoodieData)) continue;
                    ((HoodieData)data).unpersistWithDependencies();
                }
                catch (Exception e) {
                    LOG.warn("Failed to unpersist data on exception cleanup", (Throwable)e);
                }
            }
        }
    }

    private void clearThreadTracking() {
        long threadId = Thread.currentThread().getId();
        this.threadPersistedData.remove(threadId);
    }

    ConcurrentHashMap<Long, List<Object>> getThreadPersistedData() {
        return this.threadPersistedData;
    }
}

