/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.MetadataPartitionType;

public enum HoodieIndexVersion {
    V1(1),
    V2(2);

    private final int versionCode;

    private HoodieIndexVersion(int versionCode) {
        this.versionCode = versionCode;
    }

    public int versionCode() {
        return this.versionCode;
    }

    public static HoodieIndexVersion getCurrentVersion(HoodieTableVersion tableVersion, String partitionPath) {
        return HoodieIndexVersion.getCurrentVersion(tableVersion, MetadataPartitionType.fromPartitionPath(partitionPath));
    }

    public static HoodieIndexVersion getCurrentVersion(HoodieTableVersion tableVersion, MetadataPartitionType partitionType) {
        switch (partitionType) {
            case RECORD_INDEX: {
                return V1;
            }
            case COLUMN_STATS: 
            case PARTITION_STATS: 
            case EXPRESSION_INDEX: {
                if (tableVersion.lesserThan(HoodieTableVersion.NINE)) {
                    return V1;
                }
                return V2;
            }
            case BLOOM_FILTERS: {
                return V1;
            }
            case SECONDARY_INDEX: {
                if (tableVersion.greaterThanOrEquals(HoodieTableVersion.NINE)) {
                    return V2;
                }
                return V1;
            }
            case FILES: {
                return V1;
            }
            case ALL_PARTITIONS: {
                return V1;
            }
        }
        throw new HoodieException("Unknown metadata partition type: " + (Object)((Object)partitionType));
    }

    public static boolean isValidIndexDefinition(HoodieTableVersion tv, HoodieIndexDefinition idxDef) {
        HoodieIndexVersion iv = idxDef.getVersion();
        MetadataPartitionType metadataPartitionType = MetadataPartitionType.fromPartitionPath(idxDef.getIndexName());
        if (tv == HoodieTableVersion.EIGHT && iv == null) {
            return true;
        }
        if (tv.greaterThanOrEquals(HoodieTableVersion.NINE) && iv == null) {
            return false;
        }
        return tv != HoodieTableVersion.EIGHT || !MetadataPartitionType.SECONDARY_INDEX.equals((Object)metadataPartitionType) || iv == V1;
    }

    public boolean greaterThan(HoodieIndexVersion other) {
        return this.versionCode > other.versionCode;
    }

    public boolean greaterThanOrEquals(HoodieIndexVersion other) {
        return this.versionCode >= other.versionCode;
    }

    public boolean lowerThan(HoodieIndexVersion other) {
        return this.versionCode < other.versionCode;
    }

    public boolean lowerThanOrEquals(HoodieIndexVersion other) {
        return this.versionCode <= other.versionCode;
    }

    public String toString() {
        return this.name();
    }
}

